/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.keybind;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.settings.KeyBinding;

public class KeyBindAPI {
    private static final Set<KeyBinding> forceCheckKey = new HashSet<KeyBinding>();
    private static final Map<KeyBinding, Set<KeyBinding>> compatibiliyMap = new HashMap<KeyBinding, Set<KeyBinding>>();

    public static void forceCheckKeyBind(KeyBinding keyBinding) {
        if (keyBinding == null) {
            throw new NullPointerException();
        }
        forceCheckKey.add(keyBinding);
    }

    public static boolean doForceCheckKeyBind(KeyBinding keyBinding) {
        return keyBinding != null && forceCheckKey.contains(keyBinding);
    }

    public static void setCompatible(KeyBinding keyBinding1, KeyBinding keyBinding2) {
        if (keyBinding1 == keyBinding2 || keyBinding1 == null || keyBinding2 == null) {
            throw new IllegalArgumentException();
        }
        compatibiliyMap.computeIfAbsent(keyBinding1, key -> new HashSet()).add(keyBinding2);
        compatibiliyMap.computeIfAbsent(keyBinding2, key -> new HashSet()).add(keyBinding1);
    }

    public static boolean areCompatible(KeyBinding keyBinding1, KeyBinding keyBinding2) {
        return compatibiliyMap.getOrDefault(keyBinding1, Collections.emptySet()).contains(keyBinding2);
    }

    public static Collection<KeyBinding> getCompatibles(KeyBinding keyBinding) {
        return compatibiliyMap.getOrDefault(keyBinding, Collections.emptySet());
    }
}

