/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen.viewport;

import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.GuiViewportStack;
import com.cleanroommc.modularui.screen.viewport.LocatedElement;
import com.cleanroommc.modularui.screen.viewport.TransformationMatrix;
import java.util.ArrayList;

public class LocatedWidget
extends LocatedElement<IWidget> {
    private static final GuiViewportStack STACK = new GuiViewportStack();
    public static final LocatedWidget EMPTY = new LocatedWidget(null, TransformationMatrix.EMPTY, null);
    private final Object additionalHoverInfo;

    public static LocatedWidget of(IWidget widget) {
        if (widget == null) {
            return EMPTY;
        }
        IWidget parent = widget;
        ArrayList<IWidget> ancestors = new ArrayList<IWidget>();
        while (true) {
            ancestors.add(0, parent);
            if (parent instanceof ModularPanel) break;
            parent = parent.getParent();
        }
        STACK.reset();
        for (IWidget widget1 : ancestors) {
            if (widget1 instanceof IViewport) {
                IViewport viewport = (IViewport)widget1;
                STACK.pushViewport(viewport, widget1.getArea());
                widget1.transform(STACK);
                viewport.transformChildren(STACK);
                continue;
            }
            STACK.pushMatrix();
            widget1.transform(STACK);
        }
        return new LocatedWidget(widget, STACK.peek(), null);
    }

    public LocatedWidget(IWidget element, TransformationMatrix transformationMatrix, Object additionalHoverInfo) {
        super(element, transformationMatrix);
        this.additionalHoverInfo = additionalHoverInfo;
    }

    public Object getAdditionalHoverInfo() {
        return this.additionalHoverInfo;
    }

    @Override
    public String toString() {
        return "LocatedWidget[" + this.getElement() + " | " + this.additionalHoverInfo + "]";
    }
}

