/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import java.nio.FloatBuffer;
import java.util.Objects;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Vector3f {
    public static final Vector3f UNIT_X = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f UNIT_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    public float x;
    public float y;
    public float z;

    public static void resetUnitVectors() {
        UNIT_X.set(1.0f, 0.0f, 0.0f);
        UNIT_Y.set(0.0f, 1.0f, 0.0f);
        UNIT_Z.set(0.0f, 0.0f, 1.0f);
    }

    public Vector3f() {
    }

    public Vector3f(Vector3f src) {
        this.set(src);
    }

    public Vector3f(Vec3d src) {
        this.set(src);
    }

    public Vector3f(float x, float y, float z) {
        this.set(x, y, z);
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public Vector3f set(Vector3f src) {
        this.x = src.getX();
        this.y = src.getY();
        this.z = src.getZ();
        return this;
    }

    public Vector3f set(Vec3d src) {
        this.set(src.field_72450_a, src.field_72448_b, src.field_72449_c);
        return this;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public Vector3f translate(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3f translate(double x, double y, double z) {
        return this.translate((float)x, (float)y, (float)z);
    }

    public static Vector3f add(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            return new Vector3f(left.x + right.x, left.y + right.y, left.z + right.z);
        }
        dest.set(left.x + right.x, left.y + right.y, left.z + right.z);
        return dest;
    }

    public static Vector3f add(Vector3f a, Vector3f b, Vector3f c, Vector3f dest) {
        if (dest == null) {
            dest = new Vector3f();
        }
        dest.set(a.x + b.x + c.x, a.y + b.y + c.y, a.z + b.z + c.z);
        return dest;
    }

    public Vector3f add(Vector3f v) {
        return Vector3f.add(v, this, this);
    }

    public Vector3f add(Vector3f v, Vector3f dest) {
        return Vector3f.add(this, v, dest);
    }

    public static Vector3f sub(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            return new Vector3f(left.x - right.x, left.y - right.y, left.z - right.z);
        }
        dest.set(left.x - right.x, left.y - right.y, left.z - right.z);
        return dest;
    }

    public static Vector3f cross(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            dest = new Vector3f();
        }
        dest.set(left.y * right.z - left.z * right.y, right.x * left.z - right.z * left.x, left.x * right.y - left.y * right.x);
        return dest;
    }

    public Vector3f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f negate(Vector3f dest) {
        if (dest == null) {
            dest = new Vector3f();
        }
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public Vector3f normalise() {
        return this.normalise(this);
    }

    public Vector3f normalise(Vector3f dest) {
        float lsq;
        if (dest == null) {
            dest = new Vector3f();
        }
        if ((lsq = this.lengthSquared()) == 1.0f) {
            return dest.set(this);
        }
        float f = (float)(1.0 / Math.sqrt(lsq));
        dest.set(this.x * f, this.y * f, this.z * f);
        return dest;
    }

    public static float dot(Vector3f left, Vector3f right) {
        return left.x * right.x + left.y * right.y + left.z * right.z;
    }

    public static float angle(Vector3f a, Vector3f b) {
        float dls = Vector3f.dot(a, b) / (a.length() * b.length());
        if (dls < -1.0f) {
            dls = -1.0f;
        } else if (dls > 1.0f) {
            dls = 1.0f;
        }
        return (float)Math.acos(dls);
    }

    public Vector3f load(FloatBuffer buf) {
        this.x = buf.get();
        this.y = buf.get();
        this.z = buf.get();
        return this;
    }

    public Vector3f scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    public Vector3f store(FloatBuffer buf) {
        buf.put(this.x);
        buf.put(this.y);
        buf.put(this.z);
        return this;
    }

    public float distanceTo(Vector3f vec) {
        return MathHelper.func_76129_c((float)this.squareDistanceTo(vec));
    }

    public float squareDistanceTo(Vector3f v) {
        return this.squareDistanceTo(v.x, v.y, v.z);
    }

    public float squareDistanceTo(float xIn, float yIn, float zIn) {
        float d0 = xIn - this.x;
        float d1 = yIn - this.y;
        float d2 = zIn - this.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public Vector3f rotatePitch(float pitch) {
        float cos = MathHelper.func_76134_b((float)pitch);
        float sin = MathHelper.func_76126_a((float)pitch);
        float x = this.x;
        float y = this.y * cos + this.z * sin;
        float z = this.z * cos - this.y * sin;
        this.set(x, y, z);
        return this;
    }

    public Vector3f rotateYaw(float yaw) {
        float sin = MathHelper.func_76134_b((float)yaw);
        float cos = MathHelper.func_76126_a((float)yaw);
        float x = this.x * sin + this.z * cos;
        float y = this.y;
        float z = this.z * sin - this.x * cos;
        this.set(x, y, z);
        return this;
    }

    public Vector3f copy() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public Vec3d toVec3d() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final void setX(float x) {
        this.x = x;
    }

    public final void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public float getZ() {
        return this.z;
    }

    public String toString() {
        return "Vec3f[" + this.x + ", " + this.y + ", " + this.z + ']';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3f other = (Vector3f)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

