/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import com.cleanroommc.modularui.utils.fakeworld.BlockPosUtil;
import com.cleanroommc.modularui.utils.fakeworld.DummyWorld;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapSchema
implements ISchema {
    private final World world;
    private final Object2ObjectOpenHashMap<BlockPos, BlockInfo> blocks = new Object2ObjectOpenHashMap();
    private BiPredicate<BlockPos, BlockInfo> renderFilter;
    private final BlockPos origin;
    private final Vec3d center;

    public MapSchema(Map<BlockPos, BlockInfo> blocks) {
        this(blocks, null);
    }

    public MapSchema(Map<BlockPos, BlockInfo> blocks, BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.world = new DummyWorld();
        this.renderFilter = renderFilter;
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos(BlockPosUtil.MAX);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos(BlockPosUtil.MIN);
        if (!blocks.isEmpty()) {
            for (Map.Entry<BlockPos, BlockInfo> entry : blocks.entrySet()) {
                if (entry.getValue().getBlockState().func_177230_c() == Blocks.field_150350_a) continue;
                this.blocks.put((Object)entry.getKey(), (Object)entry.getValue());
                entry.getValue().apply(this.world, entry.getKey());
                BlockPosUtil.setMin(min, entry.getKey());
                BlockPosUtil.setMax(max, entry.getKey());
            }
        } else {
            min.func_181079_c(0, 0, 0);
            max.func_181079_c(0, 0, 0);
        }
        this.origin = min.func_185334_h();
        this.center = BlockPosUtil.getCenterD((BlockPos)min, (BlockPos)max);
    }

    @Override
    public void setRenderFilter(@Nullable BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.renderFilter = renderFilter;
    }

    @Override
    @Nullable
    public BiPredicate<BlockPos, BlockInfo> getRenderFilter() {
        return this.renderFilter;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Vec3d getFocus() {
        return this.center;
    }

    @Override
    public BlockPos getOrigin() {
        return this.origin;
    }

    @Override
    @NotNull
    public Iterator<Pair<BlockPos, BlockInfo>> iterator() {
        return new AbstractIterator<Pair<BlockPos, BlockInfo>>(){
            private final ObjectIterator<Object2ObjectMap.Entry<BlockPos, BlockInfo>> it;
            private final MutablePair<BlockPos, BlockInfo> pair;
            {
                this.it = MapSchema.this.blocks.object2ObjectEntrySet().fastIterator();
                this.pair = new MutablePair(null, null);
            }

            protected Pair<BlockPos, BlockInfo> computeNext() {
                while (this.it.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.it.next();
                    if (MapSchema.this.renderFilter != null && !MapSchema.this.renderFilter.test((BlockPos)entry.getKey(), (BlockInfo)entry.getValue())) continue;
                    this.pair.setLeft((Object)((BlockPos)entry.getKey()));
                    this.pair.setRight((Object)((BlockInfo)entry.getValue()));
                    return this.pair;
                }
                return (Pair)this.endOfData();
            }
        };
    }

    public static class Builder {
        private final Object2ObjectOpenHashMap<BlockPos, BlockInfo> blocks = new Object2ObjectOpenHashMap();
        private BiPredicate<BlockPos, BlockInfo> renderFilter;

        public Builder add(BlockPos pos, IBlockState state) {
            return this.add(pos, state, null);
        }

        public Builder add(BlockPos pos, IBlockState state, TileEntity customTile) {
            if (state.func_177230_c() == Blocks.field_150350_a) {
                return this;
            }
            this.blocks.put((Object)pos, (Object)new BlockInfo(state, customTile));
            return this;
        }

        public Builder add(BlockPos pos, BlockInfo blockInfo) {
            this.blocks.put((Object)pos, (Object)blockInfo.toImmutable());
            return this;
        }

        public Builder add(Iterable<BlockPos> posList, Function<BlockPos, BlockInfo> function) {
            for (BlockPos pos : posList) {
                BlockInfo info = function.apply(pos).toImmutable();
                this.add(pos, info);
            }
            return this;
        }

        public Builder add(Map<BlockPos, BlockInfo> blocks) {
            this.blocks.putAll(blocks);
            return this;
        }

        public Builder setRenderFilter(BiPredicate<BlockPos, BlockInfo> renderFilter) {
            this.renderFilter = renderFilter;
            return this;
        }

        public MapSchema build() {
            if (this.renderFilter == null) {
                return new MapSchema((Map<BlockPos, BlockInfo>)this.blocks);
            }
            return new MapSchema((Map<BlockPos, BlockInfo>)this.blocks, this.renderFilter);
        }
    }
}

