/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.animation;

import com.cleanroommc.modularui.animation.IAnimator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AnimatorManager {
    private static final List<IAnimator> animators = new ArrayList<IAnimator>(16);
    private static final List<IAnimator> queuedAnimators = new ArrayList<IAnimator>(8);
    private static long lastTime = 0L;

    static void startAnimation(IAnimator animator) {
        if (!animators.contains(animator) && !queuedAnimators.contains(animator)) {
            queuedAnimators.add(animator);
        }
    }

    private AnimatorManager() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new AnimatorManager());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDraw(GuiScreenEvent.DrawScreenEvent.Pre event) {
        long time = Minecraft.getSystemTime();
        int elapsedTime = IAnimator.getTimeDiff(lastTime, time);
        if (lastTime > 0L && !animators.isEmpty()) {
            animators.removeIf(animator -> {
                if (animator == null) {
                    return true;
                }
                if (animator.isPaused()) {
                    return false;
                }
                animator.advance(elapsedTime);
                return !animator.isAnimating();
            });
        }
        lastTime = time;
        animators.addAll(queuedAnimators);
        queuedAnimators.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDraw(GuiOpenEvent event) {
        if (event.getGui() == null) {
            animators.forEach(iAnimator -> iAnimator.stop(false));
            animators.clear();
        }
    }
}

