/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.widget;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.layout.IResizeable;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.drawable.Stencil;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Flex;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IWidget
extends IGuiElement {
    public void initialise(@NotNull IWidget var1, boolean var2);

    public void dispose();

    public boolean isValid();

    public void drawBackground(ModularGuiContext var1, WidgetThemeEntry<?> var2);

    @Override
    @Deprecated
    @ApiStatus.NonExtendable
    default public void draw(ModularGuiContext context) {
        this.draw(context, this.getWidgetTheme(context.getTheme()));
    }

    public void draw(ModularGuiContext var1, WidgetThemeEntry<?> var2);

    public void drawOverlay(ModularGuiContext var1, WidgetThemeEntry<?> var2);

    public void drawForeground(ModularGuiContext var1);

    default public void transform(IViewportStack stack) {
        stack.translate(this.getArea().rx, this.getArea().ry, this.getArea().getPanelLayer() * 20);
    }

    default public Object getAdditionalHoverInfo(IViewportStack viewportStack, int mouseX, int mouseY) {
        return null;
    }

    default public WidgetThemeEntry<?> getWidgetTheme(ITheme theme) {
        return theme.getFallback();
    }

    public void onUpdate();

    @Override
    public Area getArea();

    default public boolean isInside(IViewportStack stack, int mx, int my) {
        return this.isInside(stack, mx, my, true);
    }

    default public boolean isInside(IViewportStack stack, int mx, int my, boolean absolute) {
        int x = mx;
        int y = my;
        if (absolute) {
            x = stack.unTransformX(mx, my);
            y = stack.unTransformY(mx, my);
        }
        return x >= 0 && x < this.getArea().w() && y >= 0 && y < this.getArea().h();
    }

    @NotNull
    default public List<IWidget> getChildren() {
        return Collections.emptyList();
    }

    default public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @NotNull
    public ModularPanel getPanel();

    @Override
    public boolean isEnabled();

    public void setEnabled(boolean var1);

    default public boolean areAncestorsEnabled() {
        IWidget parent = this;
        do {
            if (parent.isEnabled()) continue;
            return false;
        } while ((parent = parent.getParent()).hasParent());
        return true;
    }

    default public boolean canBeSeen(IViewportStack stack) {
        return Stencil.isInsideScissorArea(this.getArea(), stack);
    }

    default public boolean canHover() {
        return true;
    }

    default public boolean canClickThrough() {
        return true;
    }

    default public boolean canHoverThrough() {
        return false;
    }

    public void markTooltipDirty();

    @Override
    @NotNull
    public IWidget getParent();

    @Override
    default public boolean hasParent() {
        return this.isValid();
    }

    public ModularGuiContext getContext();

    public Flex flex();

    default public IWidget flexBuilder(Consumer<Flex> builder) {
        builder.accept(this.flex());
        return this;
    }

    @Override
    @NotNull
    public IResizeable resizer();

    public void resizer(IResizeable var1);

    default public void beforeResize(boolean onOpen) {
    }

    default public void onResized() {
    }

    default public void postResize() {
    }

    public Flex getFlex();

    default public boolean isExpanded() {
        Flex flex = this.getFlex();
        return flex != null && flex.isExpanded();
    }

    @Nullable
    public String getName();

    default public boolean isName(String name) {
        return name.equals(this.getName());
    }

    default public boolean isType(Class<? extends IWidget> type) {
        return type.isAssignableFrom(this.getClass());
    }

    default public boolean isNameAndType(String name, Class<? extends IWidget> type) {
        return this.isName(name) && this.isType(type);
    }
}

