/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.core;

import com.cleanroommc.modularui.core.ModularUICore;
import com.cleanroommc.modularui.core.temp.ClassSplicer;
import com.cleanroommc.modularui.core.visitor.PacketByteBufferVisitor;
import java.util.function.Consumer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!ModularUICore.stackUpLoaded) {
            if (ModularUICore.ae2Loaded && transformedName.equals("net.minecraftforge.common.util.PacketUtil")) {
                Consumer<ClassNode> consumer = node -> ClassSplicer.spliceClasses(node, "com.cleanroommc.modularui.core.temp.PacketUtilPatch", "writeItemStackFromClientToServer");
                ModularUICore.LOGGER.info("Applied {} ASM, specific for AE2, from ModularUI", (Object)transformedName);
                return ClassSplicer.processNode(basicClass, consumer);
            }
            if (transformedName.equals("net.minecraftforge.common.util.PacketUtil") || transformedName.equals("net.minecraft.network.PacketBuffer")) {
                ClassWriter classWriter = new ClassWriter(0);
                new ClassReader(basicClass).accept((ClassVisitor)new PacketByteBufferVisitor((ClassVisitor)classWriter), 0);
                ModularUICore.LOGGER.info("Applied {} ASM from ModularUI", (Object)transformedName);
                return classWriter.toByteArray();
            }
        }
        return basicClass;
    }
}

