/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable.text;

import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.FormattingState;
import java.util.Arrays;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class FontRenderHelper {
    private static final int min = 48;
    private static final int max = 114;
    private static final TextFormatting[] formattingMap = new TextFormatting[67];

    @Nullable
    public static TextFormatting getForCharacter(char c) {
        if (c < '0' || c > 'r') {
            return null;
        }
        return formattingMap[c - 48];
    }

    public static void addAfter(TextFormatting[] state, TextFormatting formatting, boolean removeAllOnReset) {
        if (formatting == TextFormatting.RESET) {
            if (removeAllOnReset) {
                Arrays.fill(state, null);
            }
            state[0] = formatting;
            return;
        }
        if (removeAllOnReset) {
            state[6] = null;
        }
        if (formatting.isFancyStyling()) {
            state[formatting.ordinal() - 15] = formatting;
            return;
        }
        state[0] = formatting;
    }

    public static String format(@Nullable FormattingState state, @Nullable FormattingState parentState, String text) {
        if (state == null) {
            if (parentState == null) {
                return text;
            }
            return parentState.prependText(new StringBuilder().append(TextFormatting.RESET)).append(text).toString();
        }
        StringBuilder s = state.prependText(new StringBuilder().append(TextFormatting.RESET), parentState).append(text);
        return s.toString();
    }

    public static String formatArgs(Object[] args, @Nullable FormattingState parentState, String text, boolean translate) {
        if (args == null || args.length == 0) {
            return translate ? I18n.format((String)text, (Object[])new Object[0]) : text;
        }
        args = Arrays.copyOf(args, args.length);
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof IKey)) continue;
            IKey key = (IKey)object;
            args[i] = FormattingState.appendFormat(new StringBuilder(key.getFormatted(parentState)).append(TextFormatting.RESET), parentState).toString();
        }
        return translate ? I18n.format((String)text, (Object[])args) : String.format(text, args);
    }

    public static int getDefaultTextHeight() {
        FontRenderer fr = MCHelper.getFontRenderer();
        return fr != null ? fr.FONT_HEIGHT : 9;
    }

    public static int getFormatLength(String s, int start) {
        int l = 0;
        for (int i = Math.max(0, start); i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\u00a7') {
                if (i + 1 >= s.length()) {
                    return l;
                }
                if (FontRenderHelper.getForCharacter(c) == null) {
                    return l;
                }
                l += 2;
                ++i;
                continue;
            }
            return l;
        }
        return l;
    }

    static {
        for (TextFormatting formatting : TextFormatting.values()) {
            char c = formatting.toString().charAt(1);
            FontRenderHelper.formattingMap[c - 48] = formatting;
            if (!Character.isLetter(c)) continue;
            FontRenderHelper.formattingMap[Character.toUpperCase((char)c) - 48] = formatting;
        }
    }
}

