/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable.text;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.AnimatedText;
import com.cleanroommc.modularui.drawable.text.BaseKey;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widgets.TextWidget;
import java.util.function.IntSupplier;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public class StyledText
extends BaseKey {
    private final IKey key;
    private Alignment alignment = Alignment.Center;
    private IntSupplier color = null;
    private Boolean shadow = null;
    private float scale = 1.0f;

    public StyledText(IKey key) {
        this.key = key;
    }

    @Override
    public String get() {
        return this.key.get();
    }

    @Override
    public String getFormatted() {
        return this.key.getFormatted();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        renderer.setAlignment(this.alignment, width, height);
        renderer.setColor(this.color != null ? this.color.getAsInt() : widgetTheme.getTextColor());
        renderer.setScale(this.scale);
        renderer.setPos(x, y);
        renderer.setShadow(this.shadow != null ? this.shadow.booleanValue() : widgetTheme.getTextShadow());
        renderer.draw(this.getFormatted());
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    @Nullable
    public IntSupplier getColor() {
        return this.color;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Nullable
    public Boolean isShadow() {
        return this.shadow;
    }

    @Override
    public BaseKey style(TextFormatting formatting) {
        this.key.style(formatting);
        return this;
    }

    @Override
    public StyledText alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @Override
    public StyledText color(int color) {
        return this.color(() -> color);
    }

    @Override
    public StyledText color(@Nullable IntSupplier color) {
        this.color = color;
        return this;
    }

    @Override
    public StyledText scale(float scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public StyledText shadow(@Nullable Boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    @Override
    public TextWidget<?> asWidget() {
        return ((TextWidget)((TextWidget)((TextWidget)new TextWidget(this.key).alignment(this.alignment)).color(this.color)).scale(this.scale)).shadow(this.shadow);
    }

    @Override
    public AnimatedText withAnimation() {
        return new AnimatedText(this.key).alignment(this.alignment).color(this.color).scale(this.scale).shadow(this.shadow);
    }
}

