/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.holoui;

import com.cleanroommc.modularui.utils.GuiUtils;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@ApiStatus.Experimental
public class Plane3D {
    private float w = 480.0f;
    private float h = 270.0f;
    private float scale = 1.0f;
    private float aX = 0.5f;
    private float aY = 0.5f;
    private float nX = 0.0f;
    private float nY = 0.0f;
    private float nZ = 1.0f;

    public void transformRectangle() {
        GlStateManager.translate((float)(-this.w * this.aX), (float)(-this.h * this.aY), (float)0.0f);
        GlStateManager.translate((float)(this.w / 2.0f), (float)(this.h / 2.0f), (float)0.0f);
        GlStateManager.scale((double)(0.0625 * (double)this.scale), (double)(0.0625 * (double)this.scale), (double)(0.0625 * (double)this.scale));
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (this.nX != 0.0f || this.nY != 0.0f || this.nZ != 1.0f) {
            Matrix4f rotation = new Matrix4f();
            rotation.m00(-this.nZ + this.nY * this.nY * (1.0f + this.nZ) / (this.nX * this.nX + this.nY * this.nY));
            rotation.m10(-(this.nX * this.nY * (1.0f + this.nZ)) / (this.nX * this.nX + this.nY * this.nY));
            rotation.m20(this.nX);
            rotation.m01(-(this.nX * this.nY * (1.0f + this.nZ)) / (this.nX * this.nX + this.nY * this.nY));
            rotation.m11(-this.nZ + this.nX * this.nX * (1.0f + this.nZ) / (this.nX * this.nX + this.nY * this.nY));
            rotation.m21(this.nY);
            rotation.m02(-this.nX);
            rotation.m12(-this.nY);
            rotation.m22(-this.nZ);
            GuiUtils.applyTransformationMatrix(rotation);
        }
        GlStateManager.translate((float)(-(this.w / 2.0f)), (float)(-(this.h / 2.0f)), (float)0.0f);
    }

    public void setSize(float w, float h) {
        this.w = w;
        this.h = h;
    }

    public void setWidthWithProp(float w) {
        float factor = w / this.w;
        this.w = w;
        this.h *= factor;
    }

    public void setHeightWithProp(float h) {
        float factor = h / this.h;
        this.w *= factor;
        this.h = h;
    }

    public void setNormal(float x, float y, float z) {
        float square = x * x + y * y + z * z;
        if (square != 1.0f) {
            float factor = (float)Math.sqrt(square);
            x /= factor;
            y /= factor;
            z /= factor;
        }
        this.nX = x;
        this.nY = y;
        this.nZ = z;
    }

    public void setAnchor(float x, float y) {
        this.aX = x;
        this.aY = y;
    }

    public float getWidth() {
        return this.w;
    }

    public float getHeight() {
        return this.h;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }
}

