/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.GuiErrorHandler;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.IMuiScreen;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.UpOrDown;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiAccessor;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiContainerAccessor;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiScreenAccessor;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.Stencil;
import com.cleanroommc.modularui.overlay.OverlayManager;
import com.cleanroommc.modularui.overlay.OverlayStack;
import com.cleanroommc.modularui.screen.IClickableGuiContainer;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.NEAAnimationHandler;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.FpsCounter;
import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.RichTextWidget;
import com.cleanroommc.modularui.widgets.slot.ItemSlot;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import com.cleanroommc.neverenoughanimations.animations.OpeningAnimation;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@ApiStatus.Internal
public class ClientScreenHandler {
    private static final GuiContext defaultContext = new GuiContext();
    private static ModularScreen currentScreen = null;
    private static Character lastChar = null;
    private static final FpsCounter fpsCounter = new FpsCounter();
    private static long ticks = 0L;
    private static IMuiScreen lastMui;
    private static final ObjectArrayList<IMuiScreen> muiStack;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiChange(GuiOpenEvent event) {
        ClientScreenHandler.onGuiChanged(ClientScreenHandler.getMCScreen(), event.getGui());
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        defaultContext.updateScreenArea(event.getGui().width, event.getGui().height);
        if (ClientScreenHandler.validateGui(event.getGui())) {
            currentScreen.onResize(event.getGui().width, event.getGui().height);
        }
        OverlayStack.foreach(ms -> ms.onResize(event.getGui().width, event.getGui().height), false);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGuiInputHigh(GuiScreenEvent.KeyboardInputEvent.Pre event) throws IOException {
        defaultContext.updateEventState();
        ClientScreenHandler.inputEvent(event, InputPhase.EARLY);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onGuiInputLow(GuiScreenEvent.KeyboardInputEvent.Pre event) throws IOException {
        ClientScreenHandler.inputEvent(event, InputPhase.LATE);
    }

    private static void inputEvent(GuiScreenEvent.KeyboardInputEvent.Pre event, InputPhase phase) throws IOException {
        if (ClientScreenHandler.validateGui(event.getGui())) {
            currentScreen.getContext().updateEventState();
        }
        if (ClientScreenHandler.handleKeyboardInput(currentScreen, event.getGui(), phase)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGuiInputHigh(GuiScreenEvent.MouseInputEvent.Pre event) throws IOException {
        defaultContext.updateEventState();
        if (ClientScreenHandler.validateGui(event.getGui())) {
            currentScreen.getContext().updateEventState();
        }
        if (ClientScreenHandler.handleMouseInput(Mouse.getEventButton(), currentScreen, event.getGui())) {
            Platform.unFocusRecipeViewer();
            event.setCanceled(true);
            return;
        }
        int w = Mouse.getEventDWheel();
        if (w == 0) {
            return;
        }
        UpOrDown upOrDown = w > 0 ? UpOrDown.UP : UpOrDown.DOWN;
        ClientScreenHandler.validateGui(event.getGui());
        if (ClientScreenHandler.doAction(currentScreen, ms -> ms.onMouseScroll(upOrDown, Math.abs(w)))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Pre event) {
        int mx = event.getMouseX();
        int my = event.getMouseY();
        float pt = event.getRenderPartialTicks();
        defaultContext.updateState(mx, my, pt);
        defaultContext.reset();
        if (ClientScreenHandler.validateGui(event.getGui())) {
            currentScreen.getContext().updateState(mx, my, pt);
            ClientScreenHandler.drawScreen(currentScreen, currentScreen.getScreenWrapper().getGuiScreen(), mx, my, pt);
            event.setCanceled(true);
        }
        Platform.setupDrawTex();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Post event) {
        OverlayStack.draw(event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks());
        Platform.setupDrawTex();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            OverlayStack.onTick();
            defaultContext.tick();
            if (ClientScreenHandler.validateGui()) {
                currentScreen.onUpdate();
            }
            ++ticks;
        }
    }

    @SubscribeEvent
    public void preDraw(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            GL11.glEnable((int)2960);
        }
        Stencil.reset();
    }

    public static long getTicks() {
        return ticks;
    }

    public static void onFrameUpdate() {
        OverlayStack.foreach(ModularScreen::onFrameUpdate, true);
        if (currentScreen != null) {
            currentScreen.onFrameUpdate();
        }
    }

    private static void onGuiChanged(GuiScreen oldScreen, GuiScreen newScreen) {
        if (oldScreen == newScreen) {
            return;
        }
        defaultContext.reset();
        fpsCounter.reset();
        GuiErrorHandler.INSTANCE.clear();
        IMuiScreen lastLastMui = lastMui;
        if (lastMui != null) {
            ClientScreenHandler.invalidateCurrentScreen();
        }
        if (newScreen instanceof IMuiScreen) {
            GuiScreen lastParent;
            IMuiScreen muiScreen;
            lastMui = muiScreen = (IMuiScreen)newScreen;
            currentScreen = muiScreen.getScreen();
            muiStack.remove((Object)muiScreen);
            muiStack.add((Object)muiScreen);
            GuiScreen guiScreen = lastParent = lastLastMui != null ? lastLastMui.getScreen().getContext().getParentScreen() : null;
            if (lastParent != muiScreen) {
                currentScreen.getContext().setParentScreen(oldScreen);
            } else {
                muiStack.remove((Object)lastLastMui);
                lastLastMui.getScreen().getPanelManager().dispose();
            }
        } else if (newScreen == null) {
            ClientScreenHandler.invalidateMuiStack();
        }
        OverlayManager.onGuiOpen(newScreen);
    }

    private static void invalidateCurrentScreen() {
        if (lastMui != null) {
            ((GuiScreenAccessor)lastMui.getGuiScreen()).setEventButton(-1);
            ((GuiScreenAccessor)lastMui.getGuiScreen()).setLastMouseEvent(-1L);
            lastMui.getScreen().getPanelManager().closeAll();
            lastMui = null;
        }
        currentScreen = null;
        lastChar = null;
    }

    private static void invalidateMuiStack() {
        muiStack.forEach(muiScreen -> muiScreen.getScreen().getPanelManager().dispose());
        muiStack.clear();
    }

    private static boolean doAction(@Nullable ModularScreen muiScreen, Predicate<ModularScreen> action) {
        return OverlayStack.interact(action, true) || muiScreen != null && action.test(muiScreen);
    }

    private static boolean handleMouseInput(int button, @Nullable ModularScreen muiScreen, GuiScreen mcScreen) throws IOException {
        GameSettings gameSettings = Minecraft.getMinecraft().gameSettings;
        GuiScreenAccessor acc = (GuiScreenAccessor)mcScreen;
        if (Mouse.getEventButtonState()) {
            int val;
            if (gameSettings.touchscreen && (val = acc.getTouchValue()) > 0) {
                acc.setTouchValue(val + 1);
                return true;
            }
            acc.setEventButton(button);
            acc.setLastMouseEvent(Minecraft.getSystemTime());
            if (muiScreen != null && muiScreen.onMouseInputPre(button, true)) {
                return true;
            }
            return ClientScreenHandler.doAction(muiScreen, ms -> ms.onMousePressed(button));
        }
        if (button != -1) {
            int val;
            if (gameSettings.touchscreen && (val = acc.getTouchValue()) - 1 > 0) {
                acc.setTouchValue(val - 1);
                return true;
            }
            acc.setEventButton(-1);
            if (muiScreen != null && muiScreen.onMouseInputPre(button, false)) {
                return true;
            }
            return ClientScreenHandler.doAction(muiScreen, ms -> ms.onMouseRelease(button));
        }
        if (acc.getEventButton() != -1 && acc.getLastMouseEvent() > 0L) {
            long l = Minecraft.getSystemTime() - acc.getLastMouseEvent();
            return ClientScreenHandler.doAction(muiScreen, ms -> ms.onMouseDrag(acc.getEventButton(), l));
        }
        return false;
    }

    private static boolean handleKeyboardInput(@Nullable ModularScreen muiScreen, GuiScreen mcScreen, InputPhase inputPhase) throws IOException {
        char c0 = Keyboard.getEventCharacter();
        int key = Keyboard.getEventKey();
        boolean state = Keyboard.getEventKeyState();
        if (state) {
            lastChar = Character.valueOf(c0);
            return inputPhase.isEarly() ? ClientScreenHandler.doAction(muiScreen, ms -> ms.onKeyPressed(c0, key)) : ClientScreenHandler.keyTyped(mcScreen, c0, key);
        }
        if (lastChar == null) {
            return false;
        }
        if (inputPhase.isEarly() && ClientScreenHandler.doAction(muiScreen, ms -> ms.onKeyRelease(lastChar.charValue(), key))) {
            return true;
        }
        if (inputPhase.isLate() && key == 0 && c0 >= ' ') {
            return ClientScreenHandler.keyTyped(mcScreen, c0, key);
        }
        return false;
    }

    private static boolean keyTyped(GuiScreen screen, char typedChar, int keyCode) throws IOException {
        if (currentScreen == null) {
            return false;
        }
        if (keyCode == 46 && GuiScreen.isCtrlKeyDown() && GuiScreen.isShiftKeyDown() && GuiScreen.isAltKeyDown()) {
            ModularUIConfig.guiDebugMode = !ModularUIConfig.guiDebugMode;
            return true;
        }
        if (keyCode == 1 || Minecraft.getMinecraft().gameSettings.keyBindInventory.isActiveAndMatches(keyCode)) {
            if (currentScreen.getContext().hasDraggable()) {
                currentScreen.getContext().dropDraggable();
            } else {
                currentScreen.getPanelManager().closeTopPanel();
            }
            return true;
        }
        return false;
    }

    public static void dragSlot(long timeSinceLastClick) {
        GuiScreen guiScreen;
        if (ClientScreenHandler.hasScreen() && (guiScreen = ClientScreenHandler.getMCScreen()) instanceof GuiScreenAccessor) {
            GuiScreenAccessor container = (GuiScreenAccessor)guiScreen;
            ModularGuiContext ctx = currentScreen.getContext();
            container.invokeMouseClickMove(ctx.getAbsMouseX(), ctx.getAbsMouseY(), ctx.getMouseButton(), timeSinceLastClick);
        }
    }

    public static void clickSlot(ModularScreen ms, Slot slot) {
        GuiScreen screen = ms.getScreenWrapper().getGuiScreen();
        if (screen instanceof GuiScreenAccessor) {
            GuiScreenAccessor acc = (GuiScreenAccessor)screen;
            if (screen instanceof IClickableGuiContainer) {
                IClickableGuiContainer clickableGuiContainer = (IClickableGuiContainer)screen;
                if (ClientScreenHandler.validateGui(screen)) {
                    ModularGuiContext ctx = ms.getContext();
                    List<GuiButton> buttonList = acc.getButtonList();
                    try {
                        acc.setButtonList(Collections.emptyList());
                        clickableGuiContainer.modularUI$setClickedSlot(slot);
                        acc.invokeMouseClicked(ctx.getAbsMouseX(), ctx.getAbsMouseY(), ctx.getMouseButton());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        clickableGuiContainer.modularUI$setClickedSlot(null);
                        acc.setButtonList(buttonList);
                    }
                }
            }
        }
    }

    public static void releaseSlot() {
        GuiScreen guiScreen;
        if (ClientScreenHandler.hasScreen() && (guiScreen = ClientScreenHandler.getMCScreen()) instanceof GuiScreenAccessor) {
            GuiScreenAccessor screen = (GuiScreenAccessor)guiScreen;
            ModularGuiContext ctx = currentScreen.getContext();
            screen.invokeMouseReleased(ctx.getAbsMouseX(), ctx.getAbsMouseY(), ctx.getMouseButton());
        }
    }

    public static boolean shouldDrawWorldBackground() {
        return ModularUI.Mods.BLUR.isLoaded() || Minecraft.getMinecraft().world == null;
    }

    public static void drawDarkBackground(GuiScreen screen, int tint) {
        if (ClientScreenHandler.hasScreen()) {
            float alpha = ModularUI.Mods.NEA.isLoaded() ? OpeningAnimation.getValue((GuiScreen)screen) : 1.0f;
            int color = 0x101010;
            int start = (int)(192.0f * alpha);
            int end = (int)(208.0f * alpha);
            start = Color.withAlpha(color, start);
            end = Color.withAlpha(color, end);
            GuiDraw.drawVerticalGradientRect(0.0f, 0.0f, screen.width, screen.height, start, end);
        }
    }

    public static void drawScreen(ModularScreen muiScreen, GuiScreen mcScreen, int mouseX, int mouseY, float partialTicks) {
        if (mcScreen instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)mcScreen;
            ClientScreenHandler.drawContainer(muiScreen, container, mouseX, mouseY, partialTicks);
        } else {
            ClientScreenHandler.drawScreenInternal(muiScreen, mcScreen, mouseX, mouseY, partialTicks);
        }
    }

    public static void drawScreenInternal(ModularScreen muiScreen, GuiScreen mcScreen, int mouseX, int mouseY, float partialTicks) {
        GlStateManager.pushMatrix();
        Stencil.reset();
        Stencil.apply(muiScreen.getScreenArea(), null);
        Platform.setupDrawTex();
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
        GlStateManager.enableRescaleNormal();
        RenderHelper.enableStandardItemLighting();
        ClientScreenHandler.handleAnimationScale(mcScreen);
        muiScreen.drawScreen();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        ClientScreenHandler.drawVanillaElements(mcScreen, mouseX, mouseY, partialTicks);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        RenderHelper.disableStandardItemLighting();
        muiScreen.drawForeground();
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
        GlStateManager.enableRescaleNormal();
        RenderHelper.enableStandardItemLighting();
        Stencil.remove();
        GlStateManager.popMatrix();
    }

    public static void drawContainer(ModularScreen muiScreen, GuiContainer mcScreen, int mouseX, int mouseY, float partialTicks) {
        IVanillaSlot vanillaSlot;
        GuiContainerAccessor acc = (GuiContainerAccessor)mcScreen;
        Stencil.reset();
        Stencil.apply(muiScreen.getScreenArea(), null);
        Platform.setupDrawTex();
        mcScreen.drawDefaultBackground();
        int x = mcScreen.getGuiLeft();
        int y = mcScreen.getGuiTop();
        acc.invokeDrawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        muiScreen.drawScreen();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        ClientScreenHandler.drawVanillaElements((GuiScreen)mcScreen, mouseX, mouseY, partialTicks);
        acc.setHoveredSlot(null);
        GlStateManager.pushMatrix();
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.disableStandardItemLighting();
        acc.invokeDrawGuiContainerForegroundLayer(mouseX, mouseY);
        muiScreen.drawForeground();
        acc.setHoveredSlot(null);
        IWidget hovered = muiScreen.getContext().getTopHovered();
        if (hovered instanceof IVanillaSlot && (vanillaSlot = (IVanillaSlot)((Object)hovered)).handleAsVanillaSlot()) {
            acc.setHoveredSlot(vanillaSlot.getVanillaSlot());
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)x, (float)y, (float)0.0f);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground(mcScreen, mouseX, mouseY));
        GlStateManager.popMatrix();
        InventoryPlayer inventoryplayer = Platform.getClientPlayer().inventory;
        ItemStack itemstack = acc.getDraggedStack().isEmpty() ? inventoryplayer.getItemStack() : acc.getDraggedStack();
        GlStateManager.translate((float)x, (float)y, (float)0.0f);
        if (!itemstack.isEmpty()) {
            int k2 = acc.getDraggedStack().isEmpty() ? 8 : 16;
            String s = null;
            if (!acc.getDraggedStack().isEmpty() && acc.getIsRightMouseClick()) {
                itemstack = itemstack.copy();
                itemstack.setCount(MathUtils.ceil((float)itemstack.getCount() / 2.0f));
            } else if (acc.getDragSplitting() && acc.getDragSplittingSlots().size() > 1) {
                itemstack = itemstack.copy();
                itemstack.setCount(acc.getDragSplittingRemnant());
                if (itemstack.isEmpty()) {
                    s = TextFormatting.YELLOW + "0";
                }
            }
            ClientScreenHandler.drawItemStack(mcScreen, NEAAnimationHandler.injectVirtualCursorStack(mcScreen, itemstack), mouseX - x - 8, mouseY - y - k2, s);
        }
        if (!acc.getReturningStack().isEmpty()) {
            float f = (float)(Minecraft.getSystemTime() - acc.getReturningStackTime()) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                acc.setReturningStack(ItemStack.EMPTY);
            }
            int l2 = acc.getReturningStackDestSlot().xPos - acc.getTouchUpX();
            int i3 = acc.getReturningStackDestSlot().yPos - acc.getTouchUpY();
            int l1 = acc.getTouchUpX() + (int)((float)l2 * f);
            int i2 = acc.getTouchUpY() + (int)((float)i3 * f);
            ClientScreenHandler.drawItemStack(mcScreen, acc.getReturningStack(), l1, i2, null);
        }
        NEAAnimationHandler.drawItemAnimation(mcScreen);
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
        GlStateManager.enableRescaleNormal();
        RenderHelper.enableStandardItemLighting();
        Stencil.remove();
    }

    private static void drawItemStack(GuiContainer mcScreen, ItemStack stack, int x, int y, String altText) {
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)32.0f);
        ((GuiAccessor)mcScreen).setZLevel(200.0f);
        ((GuiScreenAccessor)mcScreen).getItemRender().zLevel = 200.0f;
        FontRenderer font = stack.getItem().getFontRenderer(stack);
        if (font == null) {
            font = ((GuiScreenAccessor)mcScreen).getFontRenderer();
        }
        Platform.setupDrawItem();
        ((GuiScreenAccessor)mcScreen).getItemRender().renderItemAndEffectIntoGUI(stack, x, y);
        ((GuiScreenAccessor)mcScreen).getItemRender().renderItemOverlayIntoGUI(font, stack, x, y - (((GuiContainerAccessor)mcScreen).getDraggedStack().isEmpty() ? 0 : 8), altText);
        GlStateManager.disableDepth();
        ((GuiAccessor)mcScreen).setZLevel(0.0f);
        ((GuiScreenAccessor)mcScreen).getItemRender().zLevel = 0.0f;
    }

    private static void drawVanillaElements(GuiScreen mcScreen, int mouseX, int mouseY, float partialTicks) {
        for (GuiButton guiButton : ((GuiScreenAccessor)mcScreen).getButtonList()) {
            guiButton.drawButton(Minecraft.getMinecraft(), mouseX, mouseY, partialTicks);
        }
        for (GuiLabel guiLabel : ((GuiScreenAccessor)mcScreen).getLabelList()) {
            guiLabel.drawLabel(Minecraft.getMinecraft(), mouseX, mouseY);
        }
    }

    public static void drawDebugScreen(@Nullable ModularScreen muiScreen, @Nullable ModularScreen fallback) {
        fpsCounter.onDraw();
        if (!ModularUIConfig.guiDebugMode) {
            return;
        }
        if (muiScreen == null) {
            if (ClientScreenHandler.validateGui()) {
                muiScreen = currentScreen;
            } else {
                if (fallback == null) {
                    return;
                }
                muiScreen = fallback;
            }
        }
        GlStateManager.disableDepth();
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        ModularGuiContext context = muiScreen.getContext();
        int mouseX = context.getAbsMouseX();
        int mouseY = context.getAbsMouseY();
        int screenH = muiScreen.getScreenArea().height;
        int color = Color.argb(180, 40, 115, 220);
        float scale = 0.8f;
        int shift = (int)(11.0f * scale + 0.5f);
        int lineY = screenH - shift - 2;
        GuiDraw.drawText("Mouse Pos: " + mouseX + ", " + mouseY, 5.0f, lineY, scale, color, true);
        GuiDraw.drawText("FPS: " + fpsCounter.getFps(), 5.0f, lineY -= shift, scale, color, true);
        GuiDraw.drawText("Theme ID: " + context.getTheme().getId(), 5.0f, lineY -= shift, scale, color, true);
        LocatedWidget locatedHovered = muiScreen.getPanelManager().getTopWidgetLocated(true);
        if (locatedHovered != null) {
            ClientScreenHandler.drawSegmentLine(lineY -= 4, scale, color);
            lineY -= 10;
            IWidget hovered = (IWidget)locatedHovered.getElement();
            locatedHovered.applyMatrix(context);
            GlStateManager.pushMatrix();
            context.applyToOpenGl();
            Area area = hovered.getArea();
            IWidget parent = hovered.getParent();
            GuiDraw.drawBorder(0.0f, 0.0f, area.width, area.height, color, scale);
            if (hovered.hasParent()) {
                GuiDraw.drawBorder(-area.rx, -area.ry, parent.getArea().width, parent.getArea().height, Color.withAlpha(color, 0.3f), scale);
            }
            GlStateManager.popMatrix();
            locatedHovered.unapplyMatrix(context);
            GuiDraw.drawText("Widget Theme: " + hovered.getWidgetTheme(muiScreen.getCurrentTheme()).getKey().getFullName(), 5.0f, lineY, scale, color, true);
            GuiDraw.drawText("Size: " + area.width + ", " + area.height, 5.0f, lineY -= shift, scale, color, true);
            GuiDraw.drawText("Pos: " + area.x + ", " + area.y + "  Rel: " + area.rx + ", " + area.ry, 5.0f, lineY -= shift, scale, color, true);
            GuiDraw.drawText("Class: " + hovered, 5.0f, lineY -= shift, scale, color, true);
            if (hovered.hasParent()) {
                ClientScreenHandler.drawSegmentLine(lineY -= 4, scale, color);
                GuiDraw.drawText("Widget Theme: " + parent.getWidgetTheme(muiScreen.getCurrentTheme()).getKey().getFullName(), 5.0f, lineY -= 10, scale, color, true);
                area = parent.getArea();
                GuiDraw.drawText("Parent size: " + area.width + ", " + area.height, 5.0f, lineY -= shift, scale, color, true);
                GuiDraw.drawText("Parent: " + parent, 5.0f, lineY -= shift, scale, color, true);
            }
            if (hovered instanceof ItemSlot) {
                ItemSlot slotWidget = (ItemSlot)hovered;
                ClientScreenHandler.drawSegmentLine(lineY -= 4, scale, color);
                ModularSlot slot = slotWidget.getSlot();
                GuiDraw.drawText("Slot Index: " + slot.getSlotIndex(), 5.0f, lineY -= 10, scale, color, false);
                GuiDraw.drawText("Slot Number: " + slot.slotNumber, 5.0f, lineY -= shift, scale, color, false);
                lineY -= shift;
                if (slotWidget.isSynced()) {
                    SlotGroup slotGroup = slot.getSlotGroup();
                    boolean allowShiftTransfer = slotGroup != null && slotGroup.allowShiftTransfer();
                    GuiDraw.drawText("Shift-Click Priority: " + (allowShiftTransfer ? Integer.valueOf(slotGroup.getShiftClickPriority()) : "DISABLED"), 5.0f, lineY, scale, color, true);
                }
            } else if (hovered instanceof RichTextWidget) {
                RichTextWidget richTextWidget = (RichTextWidget)hovered;
                ClientScreenHandler.drawSegmentLine(lineY -= 4, scale, color);
                locatedHovered.applyMatrix(context);
                Object hoveredElement = richTextWidget.getHoveredElement();
                locatedHovered.unapplyMatrix(context);
                GuiDraw.drawText("Hovered: " + hoveredElement, 5.0f, lineY -= 10, scale, color, true);
            }
        }
        GuiDraw.drawRect(mouseX, mouseY, 1.0f, 1.0f, Color.withAlpha(Color.GREEN.main, 0.8f));
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawSegmentLine(int y, float scale, int color) {
        GuiDraw.drawRect(5.0f, y, 140.0f * scale, 1.0f * scale, color);
    }

    public static void updateGuiArea(GuiContainer container, Rectangle area) {
        GuiContainerAccessor acc = (GuiContainerAccessor)container;
        acc.setGuiLeft(area.x);
        acc.setGuiTop(area.y);
        acc.setXSize(area.width);
        acc.setYSize(area.height);
    }

    public static boolean hasScreen() {
        return currentScreen != null;
    }

    @Nullable
    public static GuiScreen getMCScreen() {
        return MCHelper.getCurrentScreen();
    }

    @Nullable
    public static ModularScreen getMuiScreen() {
        return currentScreen;
    }

    public static @UnmodifiableView List<IMuiScreen> getMuiStack() {
        return Collections.unmodifiableList(muiStack);
    }

    private static boolean validateGui() {
        return MCHelper.hasMc() && ClientScreenHandler.validateGui(Minecraft.getMinecraft().currentScreen);
    }

    private static boolean validateGui(GuiScreen screen) {
        if (!MCHelper.hasMc() || currentScreen == null || !(screen instanceof IMuiScreen)) {
            return false;
        }
        IMuiScreen muiScreen = (IMuiScreen)screen;
        if (screen != Minecraft.getMinecraft().currentScreen || muiScreen.getScreen() != currentScreen) {
            defaultContext.reset();
            ClientScreenHandler.invalidateCurrentScreen();
            if (MCHelper.getCurrentScreen() == null) {
                ClientScreenHandler.invalidateMuiStack();
            }
            return false;
        }
        return true;
    }

    public static GuiContext getDefaultContext() {
        return defaultContext;
    }

    public static GuiContext getBestContext() {
        if (ClientScreenHandler.validateGui()) {
            return currentScreen.getContext();
        }
        return defaultContext;
    }

    public static void handleAnimationScale(GuiScreen screen) {
        if (ModularUI.Mods.NEA.isLoaded()) {
            OpeningAnimation.handleScale((GuiScreen)screen, (boolean)true);
        }
    }

    static {
        muiStack = new ObjectArrayList(8);
    }

    private static enum InputPhase {
        EARLY,
        LATE;


        public boolean isEarly() {
            return this == EARLY;
        }

        public boolean isLate() {
            return this == LATE;
        }
    }
}

