/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.bogosorter.api.IPosSetter;
import com.cleanroommc.bogosorter.api.ISortableContainer;
import com.cleanroommc.bogosorter.api.ISortingContextBuilder;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.core.mixins.early.minecraft.ContainerAccessor;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.NEAAnimationHandler;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.value.sync.ModularSyncManager;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(modid="bogosorter", iface="com.cleanroommc.bogosorter.api.ISortableContainer")
public class ModularContainer
extends Container
implements ISortableContainer {
    private static final int DROP_TO_WORLD = -999;
    private static final int LEFT_MOUSE = 0;
    private static final int RIGHT_MOUSE = 1;
    private EntityPlayer player;
    private ModularSyncManager syncManager;
    private boolean init = true;
    private final List<ModularSlot> phantomSlots = new ArrayList<ModularSlot>();
    private final List<ModularSlot> shiftClickSlots = new ArrayList<ModularSlot>();
    private GuiData guiData;
    private UISettings settings;
    @SideOnly(value=Side.CLIENT)
    private ModularScreen optionalScreen;

    public static ModularContainer getCurrent(EntityPlayer player) {
        Container container = player.openContainer;
        if (container instanceof ModularContainer) {
            ModularContainer container2 = (ModularContainer)container;
            return container2;
        }
        return null;
    }

    @ApiStatus.Internal
    public void construct(EntityPlayer player, PanelSyncManager panelSyncManager, UISettings settings, String mainPanelName, GuiData guiData) {
        this.player = player;
        this.syncManager = new ModularSyncManager(this);
        this.syncManager.construct(mainPanelName, panelSyncManager);
        this.settings = settings;
        this.guiData = guiData;
        this.sortShiftClickSlots();
    }

    @SideOnly(value=Side.CLIENT)
    void initializeClient(ModularScreen screen) {
        this.optionalScreen = screen;
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public void constructClientOnly() {
        this.player = Platform.getClientPlayer();
        this.syncManager = null;
    }

    public boolean isInitialized() {
        return this.player != null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModularScreen getScreen() {
        if (this.optionalScreen == null) {
            throw new NullPointerException("ModularScreen is not yet initialised!");
        }
        return this.optionalScreen;
    }

    public ContainerAccessor acc() {
        return (ContainerAccessor)((Object)this);
    }

    @MustBeInvokedByOverriders
    public void onContainerClosed(@NotNull EntityPlayer playerIn) {
        super.onContainerClosed(playerIn);
        if (this.syncManager != null) {
            this.syncManager.onClose();
        }
    }

    @MustBeInvokedByOverriders
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.syncManager != null) {
            this.syncManager.detectAndSendChanges(this.init);
        }
        this.init = false;
    }

    @ApiStatus.Internal
    public void onUpdate() {
        if (this.syncManager != null) {
            this.syncManager.onUpdate();
        }
    }

    private void sortShiftClickSlots() {
        this.shiftClickSlots.sort(Comparator.comparingInt(slot -> Objects.requireNonNull(slot.getSlotGroup()).getShiftClickPriority()));
    }

    public void setAll(@NotNull List<ItemStack> items) {
        if (this.inventorySlots.size() != items.size()) {
            ModularUI.LOGGER.error("Here are {} slots, but expected {}", (Object)this.inventorySlots.size(), (Object)items.size());
        }
        for (int i = 0; i < Math.min(this.inventorySlots.size(), items.size()); ++i) {
            this.getSlot(i).putStack(items.get(i));
        }
    }

    @ApiStatus.Internal
    public void registerSlot(String panelName, ModularSlot slot) {
        SlotGroup slotGroup;
        if (slot.isPhantom()) {
            if (this.phantomSlots.contains((Object)slot)) {
                throw new IllegalArgumentException("Tried to register slot which already exists!");
            }
            this.phantomSlots.add(slot);
        } else {
            if (this.inventorySlots.contains((Object)slot)) {
                throw new IllegalArgumentException("Tried to register slot which already exists!");
            }
            this.addSlotToContainer((Slot)slot);
        }
        if (slot.getSlotGroupName() != null) {
            slotGroup = this.getSyncManager().getSlotGroup(panelName, slot.getSlotGroupName());
            if (slotGroup == null) {
                ModularUI.LOGGER.throwing((Throwable)new IllegalArgumentException("SlotGroup '" + slot.getSlotGroupName() + "' is not registered!"));
                return;
            }
            slot.slotGroup(slotGroup);
        }
        if (slot.getSlotGroup() != null && (slotGroup = slot.getSlotGroup()).allowShiftTransfer()) {
            this.shiftClickSlots.add(slot);
            if (!this.init) {
                this.sortShiftClickSlots();
            }
        }
    }

    @Contract(value="_, null, null -> fail")
    @NotNull
    @ApiStatus.Internal
    public SlotGroup validateSlotGroup(String panelName, @Nullable String slotGroupName, @Nullable SlotGroup slotGroup) {
        if (slotGroup != null) {
            if (this.getSyncManager().getSlotGroup(panelName, slotGroup.getName()) == null) {
                throw new IllegalArgumentException("Slot group is not registered in the GUI.");
            }
            return slotGroup;
        }
        if (slotGroupName != null) {
            slotGroup = this.getSyncManager().getSlotGroup(panelName, slotGroupName);
            if (slotGroup == null) {
                throw new IllegalArgumentException("Can't find slot group for name " + slotGroupName);
            }
            return slotGroup;
        }
        throw new IllegalArgumentException("Either the slot group or the name must not be null!");
    }

    public ModularSyncManager getSyncManager() {
        if (this.syncManager == null) {
            throw new IllegalStateException("GuiSyncManager is not available for client only GUI's.");
        }
        return this.syncManager;
    }

    public boolean isClient() {
        return this.syncManager == null || NetworkUtils.isClient(this.player);
    }

    public boolean isClientOnly() {
        return this.syncManager == null;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public GuiData getGuiData() {
        return this.guiData;
    }

    public ModularSlot getModularSlot(int index) {
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot instanceof ModularSlot) {
            ModularSlot modularSlot = (ModularSlot)slot;
            return modularSlot;
        }
        throw new IllegalStateException("A non-ModularSlot was found, but all slots in a ModularContainer must extend ModularSlot.");
    }

    public List<ModularSlot> getShiftClickSlots() {
        return Collections.unmodifiableList(this.shiftClickSlots);
    }

    public void onSlotChanged(ModularSlot slot, ItemStack stack, boolean onlyAmountChanged) {
    }

    public boolean canInteractWith(@NotNull EntityPlayer playerIn) {
        return this.settings.canPlayerInteractWithUI(playerIn);
    }

    @NotNull
    public ItemStack slotClick(int slotId, int mouseButton, @NotNull ClickType clickTypeIn, @NotNull EntityPlayer player) {
        ItemStack returnable = Platform.EMPTY_STACK;
        InventoryPlayer inventoryplayer = player.inventory;
        if (clickTypeIn == ClickType.QUICK_CRAFT || this.acc().getDragEvent() != 0) {
            return this.superSlotClick(slotId, mouseButton, clickTypeIn, player);
        }
        if (!(clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || mouseButton != 0 && mouseButton != 1)) {
            if (slotId == -999) {
                return this.superSlotClick(slotId, mouseButton, clickTypeIn, player);
            }
            if (slotId < 0) {
                return Platform.EMPTY_STACK;
            }
            if (clickTypeIn == ClickType.QUICK_MOVE) {
                Slot fromSlot = this.getSlot(slotId);
                if (!fromSlot.canTakeStack(player)) {
                    return Platform.EMPTY_STACK;
                }
                returnable = NEAAnimationHandler.shouldHandleNEA(this) ? NEAAnimationHandler.injectQuickMove(this, player, slotId, fromSlot) : this.handleQuickMove(player, slotId, fromSlot);
            } else {
                Slot clickedSlot = this.getSlot(slotId);
                ItemStack slotStack = clickedSlot.getStack();
                ItemStack heldStack = inventoryplayer.getItemStack();
                if (slotStack.isEmpty()) {
                    if (!heldStack.isEmpty() && clickedSlot.isItemValid(heldStack)) {
                        int stackCount;
                        int n = stackCount = mouseButton == 0 ? heldStack.getCount() : 1;
                        if (stackCount > clickedSlot.getItemStackLimit(heldStack)) {
                            stackCount = clickedSlot.getItemStackLimit(heldStack);
                        }
                        clickedSlot.putStack(heldStack.splitStack(stackCount));
                    }
                } else if (clickedSlot.canTakeStack(player)) {
                    int stackCount;
                    if (heldStack.isEmpty() && !slotStack.isEmpty()) {
                        int s = Math.min(slotStack.getCount(), slotStack.getMaxStackSize());
                        int toRemove = mouseButton == 0 ? s : (s + 1) / 2;
                        inventoryplayer.setItemStack(slotStack.splitStack(toRemove));
                        clickedSlot.putStack(slotStack);
                        clickedSlot.onTake(player, inventoryplayer.getItemStack());
                    } else if (clickedSlot.isItemValid(heldStack)) {
                        if (slotStack.getItem() == heldStack.getItem() && slotStack.getMetadata() == heldStack.getMetadata() && ItemStack.areItemStackTagsEqual((ItemStack)slotStack, (ItemStack)heldStack)) {
                            int stackCount2;
                            int n = stackCount2 = mouseButton == 0 ? heldStack.getCount() : 1;
                            if (stackCount2 > clickedSlot.getItemStackLimit(heldStack) - slotStack.getCount()) {
                                stackCount2 = clickedSlot.getItemStackLimit(heldStack) - slotStack.getCount();
                            }
                            heldStack.shrink(stackCount2);
                            slotStack.grow(stackCount2);
                            clickedSlot.putStack(slotStack);
                        } else if (heldStack.getCount() <= clickedSlot.getItemStackLimit(heldStack)) {
                            clickedSlot.putStack(heldStack);
                            inventoryplayer.setItemStack(slotStack);
                        }
                    } else if (!(slotStack.getItem() != heldStack.getItem() || heldStack.getMaxStackSize() <= 1 || slotStack.getHasSubtypes() && slotStack.getMetadata() != heldStack.getMetadata() || !ItemStack.areItemStackTagsEqual((ItemStack)slotStack, (ItemStack)heldStack) || slotStack.isEmpty() || (stackCount = slotStack.getCount()) + heldStack.getCount() > heldStack.getMaxStackSize())) {
                        heldStack.grow(stackCount);
                        slotStack = clickedSlot.decrStackSize(stackCount);
                        if (slotStack.isEmpty()) {
                            clickedSlot.putStack(Platform.EMPTY_STACK);
                        }
                        clickedSlot.onTake(player, inventoryplayer.getItemStack());
                    }
                }
                clickedSlot.onSlotChanged();
            }
            this.detectAndSendChanges();
            return returnable;
        }
        return this.superSlotClick(slotId, mouseButton, clickTypeIn, player);
    }

    @NotNull
    protected final ItemStack superSlotClick(int slotId, int mouseButton, @NotNull ClickType clickTypeIn, @NotNull EntityPlayer player) {
        return super.slotClick(slotId, mouseButton, clickTypeIn, player);
    }

    public final ItemStack handleQuickMove(EntityPlayer player, int slotId, Slot fromSlot) {
        ItemStack returnable;
        ItemStack remainder;
        do {
            remainder = this.transferStackInSlot(player, slotId);
            returnable = Platform.copyStack(remainder);
        } while (!Platform.isStackEmpty(remainder) && ItemHandlerHelper.canItemStacksStack((ItemStack)fromSlot.getStack(), (ItemStack)remainder));
        return returnable;
    }

    @NotNull
    public ItemStack transferStackInSlot(@NotNull EntityPlayer playerIn, int index) {
        ItemStack stack;
        ModularSlot slot = this.getModularSlot(index);
        if (!slot.isPhantom() && !(stack = slot.getStack()).isEmpty()) {
            ItemStack remainder;
            ItemStack copy = stack.copy();
            stack = stack.copy();
            int base = 0;
            if (stack.getCount() > stack.getMaxStackSize()) {
                base = stack.getCount() - stack.getMaxStackSize();
                stack.setCount(stack.getMaxStackSize());
            }
            if (ItemStack.areItemStacksEqual((ItemStack)(remainder = this.transferItem(slot, stack.copy())), (ItemStack)stack)) {
                return Platform.EMPTY_STACK;
            }
            if (base == 0 && remainder.isEmpty()) {
                stack = Platform.EMPTY_STACK;
            } else {
                stack.setCount(base + remainder.getCount());
            }
            slot.putStack(stack);
            slot.onSlotChange(remainder, copy);
            slot.onTake(playerIn, remainder);
            slot.onCraftShiftClick(playerIn, remainder);
            return copy;
        }
        return Platform.EMPTY_STACK;
    }

    protected ItemStack transferItem(ModularSlot fromSlot, ItemStack fromStack) {
        @Nullable SlotGroup fromSlotGroup = fromSlot.getSlotGroup();
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            int maxSize;
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.isEnabled() || !toSlot.isItemValid(fromStack)) continue;
            ItemStack toStack = toSlot.getStack().copy();
            if (fromSlot.isPhantom() || !ItemHandlerHelper.canItemStacksStack((ItemStack)fromStack, (ItemStack)toStack)) continue;
            int j = toStack.getCount() + fromStack.getCount();
            if (j <= (maxSize = toSlot.getItemStackLimit(fromStack))) {
                fromStack.setCount(0);
                toStack.setCount(j);
                toSlot.putStack(toStack);
            } else if (toStack.getCount() < maxSize) {
                fromStack.shrink(maxSize - toStack.getCount());
                toStack.setCount(maxSize);
                toSlot.putStack(toStack);
            }
            if (!fromStack.isEmpty()) continue;
            return fromStack;
        }
        boolean hasNonEmptyPhantom = false;
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            ItemStack itemstack = toSlot.getStack();
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.isEnabled() || !toSlot.isItemValid(fromStack)) continue;
            if (toSlot.isPhantom()) {
                if (!itemstack.isEmpty()) {
                    hasNonEmptyPhantom = true;
                    continue;
                }
                toSlot.putStack(fromStack.copy());
                return fromStack;
            }
            if (!itemstack.isEmpty()) continue;
            if (fromStack.getCount() > toSlot.getItemStackLimit(fromStack)) {
                toSlot.putStack(fromStack.splitStack(toSlot.getItemStackLimit(fromStack)));
            } else {
                toSlot.putStack(fromStack.splitStack(fromStack.getCount()));
            }
            if (fromStack.getCount() >= 1) continue;
            break;
        }
        if (!hasNonEmptyPhantom) {
            return fromStack;
        }
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.isPhantom() || !toSlot.isEnabled() || !toSlot.isItemValid(fromStack)) continue;
            toSlot.putStack(fromStack.copy());
            return fromStack;
        }
        return fromStack;
    }

    public void buildSortingContext(ISortingContextBuilder builder) {
        if (this.syncManager != null) {
            this.syncManager.buildSortingContext(builder);
        }
    }

    public IPosSetter getPlayerButtonPosSetter() {
        return null;
    }
}

