/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiAccessor;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiScreenAccessor;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.neverenoughanimations.NEA;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import com.cleanroommc.neverenoughanimations.animations.ItemHoverAnimation;
import com.cleanroommc.neverenoughanimations.animations.ItemMoveAnimation;
import com.cleanroommc.neverenoughanimations.animations.ItemMovePacket;
import com.cleanroommc.neverenoughanimations.animations.ItemPickupThrowAnimation;
import com.cleanroommc.neverenoughanimations.api.IItemLocation;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class NEAAnimationHandler {
    public static boolean shouldHandleNEA(ModularContainer container) {
        return ModularUI.Mods.NEA.isLoaded() && NetworkUtils.isClient(container.getPlayer());
    }

    public static ItemStack injectQuickMove(ModularContainer container, EntityPlayer player, int slotId, Slot slot) {
        if (slot == null || !slot.getHasStack()) {
            return ItemStack.EMPTY;
        }
        ItemStack oldStack = slot.getStack().copy();
        Pair candidates = ItemMoveAnimation.getCandidates((Slot)slot, (List)container.inventorySlots);
        ItemStack returnable = container.handleQuickMove(player, slotId, slot);
        if (candidates != null) {
            ItemMoveAnimation.handleMove((Slot)slot, (ItemStack)oldStack, (Pair)candidates);
        }
        return returnable;
    }

    public static ItemStack pickupAllPre(ModularContainer container) {
        if (NEAAnimationHandler.shouldHandleNEA(container) && NEAConfig.moveAnimationTime > 0) {
            return container.getPlayer().inventory.getItemStack().copy();
        }
        return null;
    }

    public static void pickupAllMid(ModularContainer container, ItemStack instance, int quantity, Int2ObjectArrayMap<Object> packets, Slot slot) {
        if (NEAAnimationHandler.shouldHandleNEA(container) && NEAConfig.moveAnimationTime > 0) {
            IItemLocation source = IItemLocation.of((Slot)slot);
            ItemStack movingStack = instance.copy();
            movingStack.setCount(quantity);
            packets.put(source.nea$getSlotNumber(), (Object)new ItemMovePacket(NEA.time(), source, IItemLocation.CURSOR, movingStack));
        }
        instance.grow(quantity);
    }

    public static void pickupAllPost(ModularContainer container, Int2ObjectArrayMap<Object> packets, ItemStack cursor) {
        if (NEAAnimationHandler.shouldHandleNEA(container) && NEAConfig.moveAnimationTime > 0 && !packets.isEmpty()) {
            ObjectIterator iterator = packets.int2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Int2ObjectMap.Entry e = (Int2ObjectMap.Entry)iterator.next();
                ItemMoveAnimation.queueAnimation((int)e.getIntKey(), (ItemMovePacket)((ItemMovePacket)e.getValue()));
                ItemMoveAnimation.updateVirtualStack((int)-1, (ItemStack)cursor, (int)1);
            }
        }
    }

    public static ItemStack injectVirtualStack(ItemStack original, GuiContainer guiContainer, ModularSlot slot) {
        ItemStack virtual;
        if (!slot.isPhantom() && ModularUI.Mods.NEA.isLoaded() && NEAConfig.moveAnimationTime > 0 && (virtual = ItemMoveAnimation.getVirtualStack((GuiContainer)guiContainer, (Slot)slot)) != null) {
            return virtual;
        }
        return original;
    }

    public static float injectHoverScale(GuiContainer guiContainer, ModularSlot slot) {
        if (ModularUI.Mods.NEA.isLoaded() && NEAConfig.hoverAnimationTime > 0) {
            GlStateManager.pushMatrix();
            float scale = ItemHoverAnimation.getRenderScale((GuiContainer)guiContainer, (Slot)slot);
            if (scale > 1.0f) {
                int x = 8;
                int y = 8;
                GlStateManager.translate((float)x, (float)y, (float)0.0f);
                GlStateManager.scale((float)scale, (float)scale, (float)1.0f);
                GlStateManager.translate((float)(-x), (float)(-y), (float)0.0f);
                return scale;
            }
        }
        return 1.0f;
    }

    public static void endHoverScale() {
        if (ModularUI.Mods.NEA.isLoaded() && NEAConfig.hoverAnimationTime > 0) {
            GlStateManager.popMatrix();
        }
    }

    public static void drawItemAnimation(GuiContainer container) {
        if (ModularUI.Mods.NEA.isLoaded()) {
            RenderItem itemRender = ((GuiScreenAccessor)container).getItemRender();
            FontRenderer fontRenderer = ((GuiScreenAccessor)container).getFontRenderer();
            ((GuiAccessor)container).setZLevel(200.0f);
            itemRender.zLevel = 200.0f;
            ItemPickupThrowAnimation.drawIndependentAnimations((GuiContainer)container, (RenderItem)itemRender, (FontRenderer)fontRenderer);
            ItemMoveAnimation.drawAnimations((RenderItem)itemRender, (FontRenderer)fontRenderer);
            itemRender.zLevel = 0.0f;
            ((GuiAccessor)container).setZLevel(0.0f);
        }
    }

    public static ItemStack injectVirtualCursorStack(GuiContainer container, ItemStack stack) {
        if (ModularUI.Mods.NEA.isLoaded() && NEAConfig.moveAnimationTime > 0) {
            ItemStack virtual = ItemMoveAnimation.getVirtualStack((GuiContainer)container, (IItemLocation)IItemLocation.CURSOR);
            return virtual == null ? stack : virtual;
        }
        return stack;
    }
}

