/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.api.RecipeViewerSettings;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.integration.jei.GhostIngredientTarget;
import com.cleanroommc.modularui.integration.recipeviewer.RecipeViewerGhostIngredientSlot;
import com.cleanroommc.modularui.integration.recipeviewer.RecipeViewerState;
import com.cleanroommc.modularui.screen.ModularScreen;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

@SideOnly(value=Side.CLIENT)
public class RecipeViewerSettingsImpl
implements RecipeViewerSettings {
    private RecipeViewerState recipeViewerState = RecipeViewerState.DEFAULT;
    private final List<IWidget> recipeViewerExclusionWidgets = new ArrayList<IWidget>();
    private final List<Rectangle> recipeViewerExclusionAreas = new ArrayList<Rectangle>();
    private final List<RecipeViewerGhostIngredientSlot<?>> recipeViewerGhostIngredientSlots = new ArrayList();

    @Override
    public void enable() {
        this.recipeViewerState = RecipeViewerState.ENABLED;
    }

    @Override
    public void disable() {
        this.recipeViewerState = RecipeViewerState.DISABLED;
    }

    @Override
    public void defaultState() {
        this.recipeViewerState = RecipeViewerState.DEFAULT;
    }

    @Override
    public boolean isEnabled(ModularScreen screen) {
        return this.recipeViewerState.test(screen);
    }

    @Override
    public void addExclusionArea(Rectangle area) {
        if (!this.recipeViewerExclusionAreas.contains(area)) {
            this.recipeViewerExclusionAreas.add(area);
        }
    }

    @Override
    public void removeExclusionArea(Rectangle area) {
        this.recipeViewerExclusionAreas.remove(area);
    }

    @Override
    public void addExclusionArea(IWidget area) {
        if (!this.recipeViewerExclusionWidgets.contains(area)) {
            this.recipeViewerExclusionWidgets.add(area);
        }
    }

    @Override
    public void removeExclusionArea(IWidget area) {
        this.recipeViewerExclusionWidgets.remove(area);
    }

    @Override
    public <W extends IWidget & RecipeViewerGhostIngredientSlot<?>> void addGhostIngredientSlot(W slot) {
        if (!this.recipeViewerGhostIngredientSlots.contains(slot)) {
            this.recipeViewerGhostIngredientSlots.add(slot);
        }
    }

    @Override
    public <W extends IWidget & RecipeViewerGhostIngredientSlot<?>> void removeGhostIngredientSlot(W slot) {
        this.recipeViewerGhostIngredientSlots.remove(slot);
    }

    public @UnmodifiableView List<Rectangle> getRecipeViewerExclusionAreas() {
        return Collections.unmodifiableList(this.recipeViewerExclusionAreas);
    }

    public @UnmodifiableView List<IWidget> getRecipeViewerExclusionWidgets() {
        return Collections.unmodifiableList(this.recipeViewerExclusionWidgets);
    }

    public @UnmodifiableView List<RecipeViewerGhostIngredientSlot<?>> getRecipeViewerGhostIngredientSlots() {
        return Collections.unmodifiableList(this.recipeViewerGhostIngredientSlots);
    }

    @ApiStatus.Internal
    public List<Rectangle> getAllRecipeViewerExclusionAreas() {
        ArrayList<Rectangle> areas = new ArrayList<Rectangle>(this.recipeViewerExclusionAreas);
        Iterator<IWidget> iterator = this.recipeViewerExclusionWidgets.iterator();
        while (iterator.hasNext()) {
            IWidget widget = iterator.next();
            if (!widget.isValid()) {
                iterator.remove();
                continue;
            }
            if (!widget.isEnabled() || !widget.getPanel().isOpen()) continue;
            areas.add(widget.getArea());
        }
        return areas;
    }

    @Optional.Method(modid="jei")
    @ApiStatus.Internal
    public <I> List<IGhostIngredientHandler.Target<I>> getAllGhostIngredientTargets(@NotNull I ingredient) {
        ArrayList<IGhostIngredientHandler.Target<I>> ghostHandlerTargets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        Iterator<RecipeViewerGhostIngredientSlot<?>> iterator = this.recipeViewerGhostIngredientSlots.iterator();
        while (iterator.hasNext()) {
            RecipeViewerGhostIngredientSlot<?> slot = iterator.next();
            IWidget widget = (IWidget)((Object)slot);
            if (!widget.isValid()) {
                iterator.remove();
                continue;
            }
            if (!widget.isEnabled() || slot.castGhostIngredientIfValid(ingredient) == null) continue;
            RecipeViewerGhostIngredientSlot<?> slotWithType = slot;
            ghostHandlerTargets.add(new GhostIngredientTarget(widget, slotWithType));
        }
        return ghostHandlerTargets;
    }
}

