/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.theme;

import com.cleanroommc.modularui.theme.AbstractTheme;
import com.cleanroommc.modularui.theme.ThemeAPI;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.theme.WidgetThemeKey;
import com.cleanroommc.modularui.theme.WidgetThemeMap;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.UnmodifiableView;

public class DefaultTheme
extends AbstractTheme {
    public static final DefaultTheme INSTANCE = new DefaultTheme();
    private final WidgetThemeMap widgetThemes = new WidgetThemeMap();
    private boolean initialized = false;

    private DefaultTheme() {
        super("DEFAULT", null);
    }

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            for (WidgetThemeKey<?> key1 : ThemeAPI.INSTANCE.getWidgetThemeKeys()) {
                this.widgetThemes.put(key1, DefaultTheme.entryOfKey(key1));
            }
        }
    }

    @Override
    public @UnmodifiableView Collection<WidgetThemeEntry<?>> getWidgetThemes() {
        this.initialize();
        return Collections.unmodifiableCollection(this.widgetThemes.values());
    }

    @Override
    public <T extends WidgetTheme> WidgetThemeEntry<T> getWidgetTheme(WidgetThemeKey<T> key) {
        this.initialize();
        WidgetThemeEntry<T> widgetTheme = this.widgetThemes.getTheme(key);
        while (widgetTheme == null && key.isSubWidgetTheme()) {
            widgetTheme = this.widgetThemes.getTheme(key.getParent());
        }
        return widgetTheme;
    }

    private static <T extends WidgetTheme> WidgetThemeEntry<T> entryOfKey(WidgetThemeKey<T> key) {
        return new WidgetThemeEntry<T>(key, key.getDefaultValue(), key.getDefaultHoverValue());
    }
}

