/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.theme;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.DrawableSerialization;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeBuilder;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.JsonBuilder;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;

public class SelectableTheme
extends WidgetTheme {
    private final WidgetTheme selected;

    public static SelectableTheme darkTextNoShadow(int defaultWidth, int defaultHeight, @Nullable IDrawable background, @Nullable IDrawable selectedBackground) {
        return new SelectableTheme(defaultWidth, defaultHeight, background, Color.WHITE.main, -12566464, false, Color.WHITE.main, selectedBackground, Color.WHITE.main, -12566464, false, Color.WHITE.main);
    }

    public static SelectableTheme whiteTextShadow(int defaultWidth, int defaultHeight, @Nullable IDrawable background, @Nullable IDrawable selectedBackground) {
        return new SelectableTheme(defaultWidth, defaultHeight, background, Color.WHITE.main, Color.WHITE.main, true, Color.WHITE.main, selectedBackground, Color.WHITE.main, Color.WHITE.main, true, Color.WHITE.main);
    }

    public SelectableTheme(int defaultWidth, int defaultHeight, @Nullable IDrawable background, int color, int textColor, boolean textShadow, int iconColor, @Nullable IDrawable selectedBackground, int selectedColor, int selectedTextColor, boolean selectedTextShadow, int selectedIconColor) {
        super(defaultWidth, defaultHeight, background, color, textColor, textShadow, iconColor);
        this.selected = new WidgetTheme(defaultWidth, defaultHeight, selectedBackground, selectedColor, selectedTextColor, selectedTextShadow, selectedIconColor);
    }

    public SelectableTheme(SelectableTheme parent, JsonObject json, JsonObject fallback) {
        super(parent, json, fallback);
        IDrawable selectedBackground = JsonHelper.deserializeWithFallback(json, fallback, IDrawable.class, parent.getSelected().getBackground(), "selectedBackground");
        int selectedColor = JsonHelper.getColorWithFallback(json, fallback, parent.getSelected().getColor(), "selectedColor");
        int selectedTextColor = JsonHelper.getColorWithFallback(json, fallback, parent.getSelected().getTextColor(), "selectedTextColor");
        boolean selectedTextShadow = JsonHelper.getBoolWithFallback(json, fallback, parent.getSelected().getTextShadow(), "selectedTextShadow");
        int selectedIconColor = JsonHelper.getColorWithFallback(json, fallback, parent.getSelected().getTextColor(), "selectedIconColor");
        this.selected = new WidgetTheme(this.getDefaultWidth(), this.getDefaultHeight(), selectedBackground, selectedColor, selectedTextColor, selectedTextShadow, selectedIconColor);
    }

    public WidgetTheme getSelected() {
        return this.selected;
    }

    @Override
    public SelectableTheme withNoHoverBackground() {
        return new SelectableTheme(this.getDefaultWidth(), this.getDefaultHeight(), IDrawable.NONE, this.getColor(), this.getTextColor(), this.getTextShadow(), this.getIconColor(), IDrawable.NONE, this.selected.getColor(), this.selected.getTextColor(), this.selected.getTextShadow(), this.selected.getIconColor());
    }

    public static class Builder<T extends SelectableTheme, B extends Builder<T, B>>
    extends WidgetThemeBuilder<T, B> {
        public B selectedColor(int color) {
            this.add("selectedColor", color);
            return (B)((Builder)this.getThis());
        }

        public B selectedTextColor(int color) {
            this.add("selectedTextColor", color);
            return (B)((Builder)this.getThis());
        }

        public B selectedTextShadow(int shadow) {
            this.add("selectedTextShadow", shadow);
            return (B)((Builder)this.getThis());
        }

        public B selectedIconColor(int color) {
            this.add("selectedIconColor", color);
            return (B)((Builder)this.getThis());
        }

        public B selectedBackground(JsonBuilder builder) {
            this.add("selectedBackground", builder);
            return (B)((Builder)this.getThis());
        }

        public B selectedBackground(IDrawable drawable) {
            this.add("selectedBackground", DrawableSerialization.serialize(drawable));
            return (B)((Builder)this.getThis());
        }

        public B selectedBackground(String textureId) {
            return (B)((Builder)this.background(new JsonBuilder().add("type", "texture").add("id", textureId)));
        }
    }
}

