/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.google.common.base.Optional;
import java.util.NoSuchElementException;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class GameObjectHelper {
    private static final String EQUALS = "=";

    public static IBlockState getBlockState(String s) {
        String[] parts = s.split(":");
        String state = null;
        if (parts.length == 1) {
            throw new IllegalArgumentException();
        }
        String mod = parts[0];
        String path = parts[1];
        if (parts.length > 2) {
            state = parts[2];
        }
        if (parts.length > 3) {
            throw new IllegalArgumentException();
        }
        return GameObjectHelper.getBlockState(mod, path, state);
    }

    public static IBlockState getBlockState(String mod, String path) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(mod, path));
        if (block == null) {
            throw new NoSuchElementException();
        }
        return block.getDefaultState();
    }

    public static IBlockState getBlockState(String mod, String path, int meta) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(mod, path));
        if (block == null) {
            throw new NoSuchElementException();
        }
        return block.getStateFromMeta(meta);
    }

    public static IBlockState getBlockState(String mod, String path, @Nullable String state) {
        if (state != null) {
            try {
                return GameObjectHelper.getBlockState(mod, path, Integer.parseInt(state));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Block block = GameObjectHelper.getBlock(mod, path);
        IBlockState blockState = block.getDefaultState();
        return state == null ? blockState : GameObjectHelper.parseBlockStates(blockState, state.split(","));
    }

    public static Block getBlock(String mod, String path) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(mod, path));
        if (block == null) {
            throw new NoSuchElementException();
        }
        return block;
    }

    private static IBlockState parseBlockStates(IBlockState defaultState, String[] properties) {
        for (String propertyName : properties) {
            String[] prop = propertyName.split(EQUALS, 2);
            IProperty property = defaultState.getBlock().getBlockState().getProperty(prop[0]);
            if (property == null) {
                throw new IllegalArgumentException(String.format("Invalid property name '%s' for block '%s'", prop[0], defaultState.getBlock().getRegistryName()));
            }
            Optional value = property.parseValue(prop[1]);
            if (!value.isPresent()) {
                throw new IllegalArgumentException(String.format("Invalid property value '%s' for block '%s'", prop[1], defaultState.getBlock().getRegistryName()));
            }
            defaultState = defaultState.withProperty(property, (Comparable)value.get());
        }
        return defaultState;
    }

    public static ItemStack getItemStack(String mod, String path) {
        return GameObjectHelper.getItemStack(mod, path, 0);
    }

    public static ItemStack getItemStack(String mod, String path, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mod, path));
        if (item == null) {
            throw new NoSuchElementException("Item '" + mod + ":" + path + "' was not found!");
        }
        return new ItemStack(item, 1, meta);
    }
}

