/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.utils.SIPrefix;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class NumberFormat {
    public static final Params DEFAULT = NumberFormat.paramsBuilder().roundingMode(RoundingMode.HALF_UP).maxLength(4).considerMinusForLength(false).considerDecimalSeparatorForLength(false).considerOnlyDecimalsForLength(false).considerSuffixForLength(true).spaceAfterNumber(false).build();
    public static final Params DECIMALS_3 = DEFAULT.copyToBuilder().considerSuffixForLength(false).considerOnlyDecimalsForLength(true).maxLength(3).build();
    public static final Params AMOUNT_TEXT = DEFAULT.copyToBuilder().roundingMode(RoundingMode.DOWN).build();

    public static Params params(DecimalFormat format, int maxLength, boolean considerOnlyDecimalsForLength, boolean considerDecimalSeparatorForLength, boolean considerMinusForLength, boolean considerSuffixForLength, boolean spaceAfterNumber) {
        return new Params(format, maxLength, considerOnlyDecimalsForLength, considerDecimalSeparatorForLength, considerMinusForLength, considerSuffixForLength, spaceAfterNumber);
    }

    public static ParamsBuilder paramsBuilder() {
        return new ParamsBuilder();
    }

    public static String format(double number, Params params) {
        boolean negative = number < 0.0;
        int maxLength = params.maxLength;
        if (negative) {
            number = -number;
            if (params.considerMinusForLength) {
                --maxLength;
            }
        }
        String formattedNumber = NumberFormat.formatInternal(number, maxLength, params);
        if (negative) {
            formattedNumber = "-" + formattedNumber;
        }
        return formattedNumber;
    }

    public static String formatFromUnit(double number, SIPrefix unit, Params params) {
        return NumberFormat.format(number * unit.factor, params);
    }

    public static SIPrefix findBestPrefix(double number) {
        SIPrefix prefix;
        if (number >= 1.0 && number < 10000.0) {
            return SIPrefix.One;
        }
        SIPrefix[] high = SIPrefix.HIGH;
        SIPrefix[] low = SIPrefix.LOW;
        int n = high.length - 1;
        if (number >= 10000.0) {
            int index;
            for (index = 0; index < n && !(number < high[index + 1].factor); ++index) {
            }
            prefix = high[index];
        } else {
            int index;
            for (index = 0; index < n && !(number >= low[index].factor); ++index) {
            }
            prefix = low[index];
        }
        return prefix;
    }

    private static String formatInternal(double number, int maxLength, Params params) {
        SIPrefix prefix = NumberFormat.findBestPrefix(number);
        return NumberFormat.formatToString(number * prefix.oneOverFactor, prefix.symbol, maxLength, params);
    }

    private static String formatToString(double value, char prefix, int maxLength, Params params) {
        if (params.considerSuffixForLength && prefix != '\u0000') {
            --maxLength;
            if (params.spaceAfterNumber) {
                --maxLength;
            }
        }
        if (params.considerDecimalSeparatorForLength) {
            --maxLength;
        }
        if (!params.considerOnlyDecimalsForLength && value % 1.0 > 0.0) {
            int intDigits = (int)(Math.log10(Math.floor(value)) + 1.0);
            maxLength -= intDigits;
        }
        int m1 = params.format.getMaximumFractionDigits();
        int m2 = params.format.getMinimumFractionDigits();
        params.format.setMaximumFractionDigits(maxLength);
        String s = params.format.format(value);
        params.format.setMaximumFractionDigits(m1);
        params.format.setMinimumFractionDigits(m2);
        if (prefix != '\u0000') {
            s = params.spaceAfterNumber ? s + (32 + prefix) : s + prefix;
        }
        return s;
    }

    public static String formatNanos(long nanos) {
        return DECIMALS_3.format((double)nanos * SIPrefix.Nano.factor);
    }

    public static class Params {
        public final DecimalFormat format;
        public final int maxLength;
        public final boolean considerOnlyDecimalsForLength;
        public final boolean considerDecimalSeparatorForLength;
        public final boolean considerMinusForLength;
        public final boolean considerSuffixForLength;
        public final boolean spaceAfterNumber;

        public Params(DecimalFormat format, int maxLength, boolean considerOnlyDecimalsForLength, boolean considerDecimalSeparatorForLength, boolean considerMinusForLength, boolean considerSuffixForLength, boolean spaceAfterNumber) {
            this.format = format;
            this.maxLength = maxLength;
            this.considerOnlyDecimalsForLength = considerOnlyDecimalsForLength;
            this.considerDecimalSeparatorForLength = considerDecimalSeparatorForLength;
            this.considerMinusForLength = considerMinusForLength;
            this.considerSuffixForLength = considerSuffixForLength;
            this.spaceAfterNumber = spaceAfterNumber;
            if (!this.considerOnlyDecimalsForLength && this.maxLength < 4) {
                throw new IllegalArgumentException("Max length must be at least 4 characters");
            }
        }

        public ParamsBuilder copyToBuilder() {
            DecimalFormat format = (DecimalFormat)this.format.clone();
            format.setMinimumFractionDigits(this.format.getMinimumFractionDigits());
            format.setMaximumFractionDigits(this.format.getMaximumFractionDigits());
            format.setMinimumIntegerDigits(this.format.getMinimumIntegerDigits());
            format.setMaximumIntegerDigits(this.format.getMaximumIntegerDigits());
            format.setRoundingMode(this.format.getRoundingMode());
            format.setGroupingSize(this.format.getGroupingSize());
            format.setGroupingUsed(this.format.isGroupingUsed());
            return new ParamsBuilder().format(format).maxLength(this.maxLength).considerOnlyDecimalsForLength(this.considerOnlyDecimalsForLength).considerDecimalSeparatorForLength(this.considerDecimalSeparatorForLength).considerMinusForLength(this.considerMinusForLength).considerSuffixForLength(this.considerSuffixForLength).spaceAfterNumber(this.spaceAfterNumber);
        }

        public String format(double number) {
            return NumberFormat.format(number, this);
        }
    }

    public static class ParamsBuilder {
        private DecimalFormat format;
        private int maxLength;
        private boolean considerOnlyDecimalsForLength;
        private boolean considerDecimalSeparatorForLength;
        private boolean considerMinusForLength;
        private boolean considerSuffixForLength;
        private boolean spaceAfterNumber;

        private DecimalFormat checkFormat() {
            if (this.format == null) {
                this.format = new DecimalFormat("0.###");
            }
            return this.format;
        }

        public ParamsBuilder format(DecimalFormat format) {
            this.format = format;
            return this;
        }

        public ParamsBuilder roundingMode(RoundingMode roundingMode) {
            this.checkFormat().setRoundingMode(roundingMode);
            return this;
        }

        public ParamsBuilder decimalFormatSymbols(DecimalFormatSymbols symbols) {
            this.checkFormat().setDecimalFormatSymbols(symbols);
            return this;
        }

        public ParamsBuilder decimalSeparator(char c) {
            DecimalFormatSymbols symbols = this.checkFormat().getDecimalFormatSymbols();
            symbols.setDecimalSeparator(c);
            this.checkFormat().setDecimalFormatSymbols(symbols);
            return this;
        }

        public ParamsBuilder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public ParamsBuilder considerOnlyDecimalsForLength(boolean considerOnlyDecimalsForLength) {
            this.considerOnlyDecimalsForLength = considerOnlyDecimalsForLength;
            return this;
        }

        public ParamsBuilder considerDecimalSeparatorForLength(boolean considerDecimalSeparatorForLength) {
            this.considerDecimalSeparatorForLength = considerDecimalSeparatorForLength;
            return this;
        }

        public ParamsBuilder considerMinusForLength(boolean considerMinusForLength) {
            this.considerMinusForLength = considerMinusForLength;
            return this;
        }

        public ParamsBuilder considerSuffixForLength(boolean considerSuffixForLength) {
            this.considerSuffixForLength = considerSuffixForLength;
            return this;
        }

        public ParamsBuilder spaceAfterNumber(boolean spaceAfterNumber) {
            this.spaceAfterNumber = spaceAfterNumber;
            return this;
        }

        public Params build() {
            return new Params(this.checkFormat(), this.maxLength, this.considerOnlyDecimalsForLength, this.considerDecimalSeparatorForLength, this.considerMinusForLength, this.considerSuffixForLength, this.spaceAfterNumber);
        }
    }
}

