/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.integration.jei.ModularUIJeiPlugin;
import java.util.function.Consumer;
import mezz.jei.gui.overlay.IngredientListOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class Platform {
    public static final ItemStack EMPTY_STACK = ItemStack.EMPTY;

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public static EntityPlayerSP getClientPlayer() {
        return Minecraft.getMinecraft().player;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getKeyDisplay(KeyBinding keyBinding) {
        return keyBinding.getKeyDescription();
    }

    public static boolean isStackEmpty(ItemStack stack) {
        return stack == null || stack.isEmpty();
    }

    public static ItemStack copyStack(ItemStack stack) {
        return Platform.isStackEmpty(stack) ? EMPTY_STACK : stack.copy();
    }

    public static void unFocusRecipeViewer() {
        if (ModularUI.Mods.JEI.isLoaded()) {
            ((IngredientListOverlay)ModularUIJeiPlugin.getRuntime().getIngredientListOverlay()).setKeyboardFocus(false);
        }
    }

    public static void startDrawing(DrawMode drawMode, VertexFormat format, Consumer<BufferBuilder> bufferBuilder) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(drawMode.mode, format.format);
        bufferBuilder.accept(buffer);
        tessellator.draw();
    }

    public static void setupDrawColor() {
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.disableAlpha();
    }

    public static void setupDrawTex(ResourceLocation texture) {
        Platform.setupDrawTex(texture, false);
    }

    public static void setupDrawTex(ResourceLocation texture, boolean withBlend) {
        Platform.setupDrawTex(withBlend);
        Minecraft.getMinecraft().renderEngine.bindTexture(texture);
    }

    public static void setupDrawTex(int textureId) {
        Platform.setupDrawTex();
        GlStateManager.bindTexture((int)textureId);
    }

    public static void setupDrawTex() {
        Platform.setupDrawTex(false);
    }

    public static void setupDrawTex(boolean withBlend) {
        GlStateManager.enableTexture2D();
        GlStateManager.enableAlpha();
        if (withBlend) {
            GlStateManager.enableBlend();
        } else {
            GlStateManager.disableBlend();
        }
    }

    public static void setupDrawGradient() {
        Platform.setupDrawGradient(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }

    public static void setupDrawGradient(GlStateManager.SourceFactor srcFactor, GlStateManager.DestFactor destFactor, GlStateManager.SourceFactor srcFactorAlpha, GlStateManager.DestFactor destFactorAlpha) {
        GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)srcFactor, (GlStateManager.DestFactor)destFactor, (GlStateManager.SourceFactor)srcFactorAlpha, (GlStateManager.DestFactor)destFactorAlpha);
        GlStateManager.shadeModel((int)7425);
    }

    public static void endDrawGradient() {
        GlStateManager.shadeModel((int)7424);
    }

    public static void setupDrawItem() {
        Platform.setupDrawTex();
        GlStateManager.enableRescaleNormal();
        RenderHelper.enableGUIStandardItemLighting();
        GlStateManager.enableDepth();
    }

    public static void endDrawItem() {
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableDepth();
    }

    public static void setupDrawFont() {
        Platform.setupDrawTex();
    }

    public static void setupDrawEntity(Entity entity, float x, float y, float w, float h, float z) {
        float scale;
        float size;
        if (h / entity.height < w / entity.width) {
            size = entity.height;
            scale = h / size;
        } else {
            size = entity.width;
            scale = w / size;
        }
        GlStateManager.enableColorMaterial();
        GlStateManager.enableDepth();
        GlStateManager.translate((float)(x + w / 2.0f), (float)(y + h / 2.0f), (float)(z + 50.0f));
        GlStateManager.scale((float)(-scale), (float)scale, (float)scale);
        GlStateManager.translate((float)0.0f, (float)(size / 2.0f), (float)0.0f);
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotate((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GlStateManager.rotate((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public static void endDrawEntity() {
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableRescaleNormal();
        GlStateManager.setActiveTexture((int)OpenGlHelper.lightmapTexUnit);
        GlStateManager.disableTexture2D();
        GlStateManager.setActiveTexture((int)OpenGlHelper.defaultTexUnit);
        GlStateManager.disableDepth();
    }

    public static enum DrawMode {
        QUADS(7),
        POINTS(0),
        LINES(1),
        LINE_STRIP(3),
        LINE_LOOP(2),
        TRIANGLES(4),
        TRIANGLE_STRIP(5),
        TRIANGLE_FAN(6);

        public final int mode;

        private DrawMode(int mode) {
            this.mode = mode;
        }
    }

    public static enum VertexFormat {
        POS(DefaultVertexFormats.POSITION),
        POS_TEX(DefaultVertexFormats.POSITION_TEX),
        POS_COLOR(DefaultVertexFormats.POSITION_COLOR),
        POS_TEX_COLOR(DefaultVertexFormats.POSITION_TEX_COLOR),
        POS_NORMAL(DefaultVertexFormats.POSITION_NORMAL),
        POS_TEX_NORMAL(DefaultVertexFormats.POSITION_TEX_NORMAL),
        POS_TEX_COLOR_NORMAL(DefaultVertexFormats.POSITION_TEX_COLOR_NORMAL),
        POS_TEX_LMAP_COLOR(DefaultVertexFormats.POSITION_TEX_LMAP_COLOR);

        public final net.minecraft.client.renderer.vertex.VertexFormat format;

        private VertexFormat(net.minecraft.client.renderer.vertex.VertexFormat format) {
            this.format = format;
        }
    }
}

