/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.GuiUtils;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.utils.VectorUtil;
import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import com.cleanroommc.modularui.utils.fakeworld.Camera;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import com.cleanroommc.modularui.utils.fakeworld.RenderWorld;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.SchemaWidget;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class BaseSchemaRenderer
implements IDrawable {
    protected static final FloatBuffer PIXEL_DEPTH_BUFFER = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final Framebuffer FBO = new Framebuffer(1080, 1080, true);
    private final ISchema schema;
    private final IBlockAccess renderWorld;
    private final Framebuffer framebuffer;
    private final Camera camera = new Camera();
    private RayTraceResult lastRayTrace = null;
    private final int[] viewport = new int[4];

    public BaseSchemaRenderer(ISchema schema, Framebuffer framebuffer) {
        this.schema = schema;
        this.framebuffer = framebuffer;
        this.renderWorld = new RenderWorld(schema);
    }

    public BaseSchemaRenderer(ISchema schema) {
        this(schema, FBO);
    }

    @Nullable
    public RayTraceResult getLastRayTrace() {
        return this.lastRayTrace;
    }

    public ISchema getSchema() {
        return this.schema;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public SchemaWidget asWidget() {
        return new SchemaWidget(this);
    }

    @Override
    public Icon asIcon() {
        return IDrawable.super.asIcon().size(50);
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        this.render(context, x, y, width, height);
    }

    protected void render(GuiContext context, int x, int y, int width, int height) {
        int mx = context.getMouseX();
        int my = context.getMouseY();
        this.onSetupCamera();
        int lastFbo = this.bindFBO();
        this.setupCamera(this.framebuffer.framebufferWidth, this.framebuffer.framebufferHeight);
        this.renderWorld();
        if (this.doRayTrace()) {
            RayTraceResult result = null;
            if (Area.isInside(x, y, width, height, mx, my)) {
                result = this.rayTrace(mx, my, width, height);
            }
            if (result == null) {
                if (this.lastRayTrace != null) {
                    this.onRayTraceFailed();
                }
            } else {
                this.onSuccessfulRayTrace(result);
            }
            this.lastRayTrace = result;
        }
        this.onRendered();
        Platform.setupDrawTex();
        this.resetCamera();
        this.unbindFBO(lastFbo);
        GlStateManager.enableTexture2D();
        GlStateManager.disableLighting();
        lastFbo = GL11.glGetInteger((int)3553);
        GlStateManager.bindTexture((int)this.framebuffer.framebufferTexture);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_TEX, bufferBuilder -> {
            bufferBuilder.pos((double)(x + width), (double)(y + height), 0.0).tex(1.0, 0.0).endVertex();
            bufferBuilder.pos((double)(x + width), (double)y, 0.0).tex(1.0, 1.0).endVertex();
            bufferBuilder.pos((double)x, (double)y, 0.0).tex(0.0, 1.0).endVertex();
            bufferBuilder.pos((double)x, (double)(y + height), 0.0).tex(0.0, 0.0).endVertex();
        });
        GlStateManager.bindTexture((int)lastFbo);
    }

    protected RayTraceResult rayTrace(int mouseX, int mouseY, int width, int height) {
        Vector3f levelMouse = this.screenToWorldPos((float)mouseX / (float)width, (float)mouseY / (float)height);
        Vector3f target = this.camera.getLookVec().mul(20.0f).add(levelMouse);
        return this.schema.getWorld().rayTraceBlocks(VectorUtil.toVec3d(levelMouse), VectorUtil.toVec3d(target), true);
    }

    protected Vector3f screenToWorldPos(float x, float y) {
        Matrix4f transform = GuiUtils.getProjectionMatrix().mul(GuiUtils.getTransformationMatrix());
        int wx = (int)(x * (float)this.viewport[2]);
        int wy = (int)(y * (float)this.viewport[3]);
        wy = this.viewport[3] - wy;
        GL11.glReadPixels((int)wx, (int)wy, (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)PIXEL_DEPTH_BUFFER);
        PIXEL_DEPTH_BUFFER.rewind();
        float depth = PIXEL_DEPTH_BUFFER.get();
        PIXEL_DEPTH_BUFFER.rewind();
        return transform.unproject((float)wx, (float)wy, depth, this.viewport, new Vector3f());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderWorld() {
        Minecraft mc = Minecraft.getMinecraft();
        Platform.setupDrawTex();
        GlStateManager.enableCull();
        GlStateManager.enableRescaleNormal();
        RenderHelper.disableStandardItemLighting();
        mc.entityRenderer.disableLightmap();
        mc.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        GlStateManager.disableLighting();
        Platform.setupDrawGradient();
        List<TileEntity> tesr = null;
        try {
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (layer.ordinal() == 0 && this.isTesrEnabled()) {
                    tesr = this.renderBlocksInLayer(mc, layer, true);
                    continue;
                }
                this.renderBlocksInLayer(mc, layer, false);
            }
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        }
        RenderHelper.enableStandardItemLighting();
        GlStateManager.enableLighting();
        try {
            if (tesr != null && !tesr.isEmpty()) {
                BaseSchemaRenderer.renderTesr(tesr, 0);
                if (!tesr.isEmpty()) {
                    BaseSchemaRenderer.renderTesr(tesr, 1);
                    BaseSchemaRenderer.renderTesr(tesr, 2);
                }
            }
        }
        finally {
            ForgeHooksClient.setRenderPass((int)-1);
        }
        Platform.endDrawGradient();
        GlStateManager.enableDepth();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
    }

    private List<TileEntity> renderBlocksInLayer(Minecraft mc, BlockRenderLayer layer, boolean collectTesr) {
        ArrayList<TileEntity> tesr = collectTesr ? new ArrayList<TileEntity>() : null;
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
        int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
        BaseSchemaRenderer.setDefaultPassRenderState(pass);
        BufferBuilder buffer = Tessellator.getInstance().getBuffer();
        buffer.begin(7, DefaultVertexFormats.BLOCK);
        BlockRendererDispatcher blockrendererdispatcher = mc.getBlockRendererDispatcher();
        this.schema.forEach(pair -> {
            TileEntity te;
            BlockPos pos = (BlockPos)pair.getKey();
            IBlockState state = ((BlockInfo)pair.getValue()).getBlockState();
            if (state.getBlock().isAir(state, this.renderWorld, pos)) {
                return;
            }
            if (collectTesr && (te = ((BlockInfo)pair.getValue()).getTileEntity()) != null && !te.isInvalid()) {
                if (!te.getPos().equals((Object)pos)) {
                    te.setPos(pos.toImmutable());
                }
                if (TileEntityRendererDispatcher.instance.getRenderer(te.getClass()) != null) {
                    tesr.add(te);
                }
            }
            if (state.getBlock().canRenderInLayer(state, layer)) {
                blockrendererdispatcher.renderBlock(state, pos, this.renderWorld, buffer);
            }
        });
        Tessellator.getInstance().draw();
        Tessellator.getInstance().getBuffer().setTranslation(0.0, 0.0, 0.0);
        return tesr;
    }

    private static void renderTesr(List<TileEntity> tileEntities, int pass) {
        ForgeHooksClient.setRenderPass((int)pass);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BaseSchemaRenderer.setDefaultPassRenderState(pass);
        Iterator<TileEntity> iterator = tileEntities.iterator();
        while (iterator.hasNext()) {
            TileEntity tile = iterator.next();
            if (tile == null || tile.isInvalid()) continue;
            if (!(pass != 0 || tile.shouldRenderInPass(1) && tile.shouldRenderInPass(2))) {
                iterator.remove();
            }
            if (!tile.shouldRenderInPass(pass)) continue;
            BlockPos pos = tile.getPos();
            TileEntityRendererDispatcher.instance.render(tile, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0f);
        }
    }

    private static void setDefaultPassRenderState(int pass) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pass == 0) {
            GlStateManager.enableDepth();
            GlStateManager.disableBlend();
            GlStateManager.depthMask((boolean)true);
        } else {
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.depthMask((boolean)false);
        }
    }

    protected final void setupCamera(int width, int height) {
        Minecraft.getMinecraft().entityRenderer.disableLightmap();
        GlStateManager.disableLighting();
        GlStateManager.enableDepth();
        GlStateManager.enableBlend();
        GlStateManager.viewport((int)0, (int)0, (int)width, (int)height);
        Color.setGlColor(this.getClearColor());
        GlStateManager.clear((int)16640);
        GlStateManager.matrixMode((int)5889);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        float near = this.isIsometric() ? 1.0f : 0.1f;
        float far = 10000.0f;
        float fovY = 60.0f;
        float aspect = (float)width / (float)height;
        float top = near * (float)Math.tan(Math.toRadians(fovY) / 2.0);
        float bottom = -top;
        float left = aspect * bottom;
        float right = aspect * top;
        if (this.isIsometric()) {
            GL11.glOrtho((double)left, (double)right, (double)bottom, (double)top, (double)near, (double)far);
        } else {
            GL11.glFrustum((double)left, (double)right, (double)bottom, (double)top, (double)near, (double)far);
        }
        GlStateManager.matrixMode((int)5888);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        if (this.isIsometric()) {
            GlStateManager.scale((double)0.1, (double)0.1, (double)0.1);
        }
        Vector3f c = this.camera.getPos();
        Vector3f lookAt = this.camera.getLookAt();
        GLU.gluLookAt((float)c.x, (float)c.y, (float)c.z, (float)lookAt.x, (float)lookAt.y, (float)lookAt.z, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected final void resetCamera() {
        Minecraft minecraft = Minecraft.getMinecraft();
        GlStateManager.viewport((int)0, (int)0, (int)minecraft.displayWidth, (int)minecraft.displayHeight);
        GlStateManager.matrixMode((int)5889);
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.popMatrix();
        GlStateManager.disableBlend();
        GlStateManager.disableDepth();
    }

    private int bindFBO() {
        int lastID = GL11.glGetInteger((int)36006);
        this.framebuffer.setFramebufferColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.framebuffer.framebufferClear();
        this.framebuffer.bindFramebuffer(true);
        this.viewport[0] = 0;
        this.viewport[1] = 0;
        this.viewport[2] = this.framebuffer.framebufferWidth;
        this.viewport[3] = this.framebuffer.framebufferHeight;
        GlStateManager.pushMatrix();
        return lastID;
    }

    private void unbindFBO(int lastID) {
        GlStateManager.popMatrix();
        this.framebuffer.unbindFramebufferTexture();
        OpenGlHelper.glBindFramebuffer((int)OpenGlHelper.GL_FRAMEBUFFER, (int)lastID);
    }

    @ApiStatus.OverrideOnly
    protected void onSetupCamera() {
    }

    @ApiStatus.OverrideOnly
    protected void onRendered() {
    }

    @ApiStatus.OverrideOnly
    protected void onSuccessfulRayTrace(@NotNull RayTraceResult result) {
    }

    @ApiStatus.OverrideOnly
    protected void onRayTraceFailed() {
    }

    public boolean doRayTrace() {
        return false;
    }

    public int getClearColor() {
        return Color.withAlpha(0, 0.5f);
    }

    public boolean isIsometric() {
        return false;
    }

    public boolean isTesrEnabled() {
        return true;
    }
}

