/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockInfo {
    public static final BlockInfo EMPTY = new BlockInfo(Blocks.AIR);
    public static final BlockInfo INVALID = new BlockInfo(Blocks.AIR);
    private IBlockState blockState;
    private TileEntity tileEntity;

    public static BlockInfo of(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.getBlockState(pos);
        if (blockState.getBlock().isAir(blockState, world, pos)) {
            return EMPTY;
        }
        TileEntity tile = null;
        if (blockState.getBlock().hasTileEntity(blockState)) {
            TileEntity realTile = world.getTileEntity(pos);
            tile = BlockInfo.fixRealTileWorldCorrupting(realTile, blockState);
        }
        return new BlockInfo(blockState, tile);
    }

    @Nullable
    private static TileEntity fixRealTileWorldCorrupting(TileEntity realTile, IBlockState blockState) {
        TileEntity fakeTile = null;
        if (realTile != null && (fakeTile = blockState.getBlock().createTileEntity(null, blockState)) != null) {
            fakeTile.deserializeNBT(realTile.serializeNBT());
        }
        return fakeTile;
    }

    public BlockInfo(@NotNull Block block) {
        this(block.getDefaultState());
    }

    public BlockInfo(@NotNull IBlockState blockState) {
        this(blockState, null);
    }

    public BlockInfo(@NotNull IBlockState blockState, @Nullable TileEntity tileEntity) {
        this.set(blockState, tileEntity);
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public void apply(World world, BlockPos pos) {
        world.setBlockState(pos, this.blockState);
        if (this.tileEntity != null) {
            world.setTileEntity(pos, this.tileEntity);
        } else {
            this.tileEntity = world.getTileEntity(pos);
        }
    }

    BlockInfo set(IBlockState state, TileEntity tile) {
        Preconditions.checkNotNull((Object)state, (Object)"Block state must not be null!");
        Preconditions.checkArgument((tile == null || state.getBlock().hasTileEntity(state) ? 1 : 0) != 0, (Object)"Cannot create block info with tile entity for block not having it!");
        this.blockState = state;
        this.tileEntity = tile;
        return this;
    }

    public boolean isMutable() {
        return false;
    }

    public Mut toMutable() {
        return new Mut(this.blockState, this.tileEntity);
    }

    public BlockInfo toImmutable() {
        return this;
    }

    public BlockInfo copy() {
        return new BlockInfo(this.blockState, this.tileEntity);
    }

    public static class Mut
    extends BlockInfo {
        public static final Mut SHARED = new Mut();

        public Mut() {
            this(Blocks.AIR);
        }

        public Mut(@NotNull Block block) {
            super(block);
        }

        public Mut(@NotNull IBlockState blockState) {
            super(blockState);
        }

        public Mut(@NotNull IBlockState blockState, @Nullable TileEntity tileEntity) {
            super(blockState, tileEntity);
        }

        @Override
        public Mut set(IBlockState state, TileEntity tile) {
            return (Mut)super.set(state, tile);
        }

        public Mut set(IBlockAccess world, BlockPos pos) {
            IBlockState blockState = world.getBlockState(pos);
            TileEntity tile = null;
            if (blockState.getBlock().hasTileEntity(blockState)) {
                tile = world.getTileEntity(pos);
            }
            return this.set(blockState, tile);
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public Mut toMutable() {
            return this;
        }

        @Override
        public BlockInfo toImmutable() {
            return new BlockInfo(this.getBlockState(), this.getTileEntity());
        }

        @Override
        public Mut copy() {
            return new Mut(this.getBlockState(), this.getTileEntity());
        }
    }
}

