/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyChunkProvider
implements IChunkProvider {
    private final World world;
    private final LongObjectMap<Chunk> loadedChunks = new LongObjectHashMap();

    public DummyChunkProvider(World world) {
        this.world = world;
    }

    @Nullable
    public Chunk getLoadedChunk(int x, int z) {
        return (Chunk)this.loadedChunks.get(ChunkPos.asLong((int)x, (int)z));
    }

    @NotNull
    public Chunk provideChunk(int x, int z) {
        long chunkKey = ChunkPos.asLong((int)x, (int)z);
        if (this.loadedChunks.containsKey(chunkKey)) {
            return (Chunk)this.loadedChunks.get(chunkKey);
        }
        Chunk chunk = new Chunk(this.world, x, z);
        this.loadedChunks.put(chunkKey, (Object)chunk);
        return chunk;
    }

    public boolean tick() {
        for (Chunk chunk : this.loadedChunks.values()) {
            chunk.onTick(false);
        }
        return !this.loadedChunks.isEmpty();
    }

    @NotNull
    public String makeString() {
        return "Dummy";
    }

    public boolean isChunkGeneratedAt(int x, int z) {
        return true;
    }
}

