/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value;

import com.cleanroommc.modularui.api.value.IDoubleValue;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.utils.FloatConsumer;
import com.cleanroommc.modularui.utils.FloatSupplier;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;

public class DoubleValue
implements IDoubleValue<Double> {
    private double value;

    public static Dynamic wrap(IDoubleValue<?> val) {
        return new Dynamic(val::getDoubleValue, val::setDoubleValue);
    }

    public static Dynamic wrapAtomic(AtomicDouble val) {
        return new Dynamic(() -> ((AtomicDouble)val).get(), arg_0 -> ((AtomicDouble)val).set(arg_0));
    }

    public DoubleValue(double value) {
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.getDoubleValue();
    }

    @Override
    public void setValue(Double value) {
        this.setDoubleValue(value);
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public void setDoubleValue(double val) {
        this.value = val;
    }

    public static class Dynamic
    implements IDoubleValue<Double>,
    IStringValue<Double> {
        private final DoubleSupplier getter;
        private final DoubleConsumer setter;

        public static Dynamic ofFloat(FloatSupplier getter, FloatConsumer setter) {
            return new Dynamic(getter, setter);
        }

        public Dynamic(DoubleSupplier getter, DoubleConsumer setter) {
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public double getDoubleValue() {
            return this.getter.getAsDouble();
        }

        @Override
        public void setDoubleValue(double val) {
            this.setter.accept(val);
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.getDoubleValue());
        }

        @Override
        public void setStringValue(String val) {
            this.setDoubleValue(Double.parseDouble(val));
        }

        @Override
        public Double getValue() {
            return this.getDoubleValue();
        }

        @Override
        public void setValue(Double value) {
            this.setDoubleValue(value);
        }
    }
}

