/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.api.IPacketWriter;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.WidgetTree;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DynamicSyncHandler
extends SyncHandler {
    private IWidgetProvider widgetProvider;
    private Consumer<IWidget> onWidgetUpdate;
    private IPacketWriter lastRejectedPacket;
    private IWidget lastRejectedWidget;

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            this.updateWidget(this.parseWidget(buf));
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            this.parseWidget(buf);
        }
    }

    @Override
    public void init(String key, PanelSyncManager syncManager) {
        super.init(key, syncManager);
        if (this.lastRejectedPacket != null) {
            this.notifyUpdate(this.lastRejectedPacket);
            this.lastRejectedPacket = null;
        }
    }

    private IWidget parseWidget(PacketBuffer buf) {
        this.getSyncManager().allowTemporarySyncHandlerRegistration(true);
        IWidget widget = this.widgetProvider.createWidget(this.getSyncManager(), buf);
        this.getSyncManager().allowTemporarySyncHandlerRegistration(false);
        int unregistered = WidgetTree.countUnregisteredSyncHandlers(this.getSyncManager(), widget);
        if (unregistered > 0) {
            throw new IllegalStateException("Widgets created by DynamicSyncHandler can't have implicitly registered sync handlers. Allsync handlers must be registered with a variant of 'PanelSyncManager#getOrCreateSyncHandler(...)'.");
        }
        return widget;
    }

    private void updateWidget(IWidget widget) {
        if (this.onWidgetUpdate == null) {
            this.lastRejectedWidget = widget;
        } else {
            this.onWidgetUpdate.accept(widget);
        }
    }

    public void notifyUpdate(IPacketWriter packetWriter) {
        if (!this.isValid()) {
            this.lastRejectedPacket = packetWriter;
            return;
        }
        IWidget widget = this.parseWidget(packetWriter.toPacket());
        if (this.getSyncManager().isClient()) {
            this.updateWidget(widget);
        }
        this.sync(0, packetWriter);
    }

    public DynamicSyncHandler widgetProvider(IWidgetProvider widgetProvider) {
        this.widgetProvider = widgetProvider;
        return this;
    }

    @ApiStatus.Internal
    public void attachDynamicWidgetListener(Consumer<IWidget> onWidgetUpdate) {
        this.onWidgetUpdate = onWidgetUpdate;
        if (this.onWidgetUpdate != null && this.lastRejectedWidget != null) {
            this.onWidgetUpdate.accept(this.lastRejectedWidget);
            this.lastRejectedWidget = null;
        }
    }

    public static interface IWidgetProvider {
        @Nullable
        public IWidget createWidget(PanelSyncManager var1, PacketBuffer var2);
    }
}

