/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.ISynced;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.utils.NumberFormat;
import com.cleanroommc.modularui.utils.ObjectList;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.InternalWidgetTree;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class WidgetTree {
    public static boolean logResizeTime = false;
    public static final WidgetInfo INFO_AREA = (root, widget, builder) -> builder.append("Area xywh:").append(widget.getArea().x - root.getArea().x).append(", ").append(widget.getArea().y - root.getArea().y).append(", ").append(widget.getArea().width).append(", ").append(widget.getArea().height);
    public static final WidgetInfo INFO_ENABLED = (root, widget, builder) -> builder.append("Enabled: ").append(widget.isEnabled());
    public static final WidgetInfo INFO_FULLY_RESIZED = (root, widget, builder) -> builder.append("Fully resized: ").append(widget.resizer().isFullyCalculated(widget.hasParent() && widget.getParent() instanceof ILayoutWidget));
    public static final WidgetInfo INFO_RESIZED_DETAILED = (root, widget, builder) -> builder.append("Self resized: ").append(widget.resizer().isSelfFullyCalculated(widget.hasParent() && widget.getParent() instanceof ILayoutWidget)).append(", Is pos final: ").append(!widget.resizer().canRelayout(widget.hasParent() && widget.getParent() instanceof ILayoutWidget)).append(", Children resized: ").append(widget.resizer().areChildrenCalculated()).append(", Layout done: ").append(widget.resizer().isLayoutDone());
    public static final WidgetInfo INFO_RESIZED_COLLAPSED = (root, widget, builder) -> {
        if (widget.resizer().isFullyCalculated(widget.hasParent() && widget.getParent() instanceof ILayoutWidget)) {
            INFO_FULLY_RESIZED.addInfo(root, widget, builder);
        } else {
            INFO_RESIZED_DETAILED.addInfo(root, widget, builder);
        }
    };
    public static final WidgetInfo INFO_WIDGET_THEME = (root, widget, builder) -> builder.append("Widget theme: ").append(widget.getWidgetTheme(widget.getContext().getTheme()).getKey().getFullName());

    private WidgetTree() {
    }

    public static List<IWidget> getAllChildrenByLayer(IWidget parent) {
        return WidgetTree.getAllChildrenByLayer(parent, false);
    }

    public static List<IWidget> getAllChildrenByLayer(IWidget parent, boolean includeSelf) {
        ArrayList<IWidget> children = new ArrayList<IWidget>();
        if (includeSelf) {
            children.add(parent);
        }
        ObjectList.ObjectArrayList parents = ObjectList.create();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.removeFirst()).getChildren()) {
                if (!child.getChildren().isEmpty()) {
                    parents.add(child);
                }
                children.add(child);
            }
        }
        return children;
    }

    public static boolean foreachChildBFS(IWidget parent, Predicate<IWidget> consumer) {
        return WidgetTree.foreachChildBFS(parent, consumer, false);
    }

    public static boolean foreachChildBFS(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        ObjectList.ObjectArrayList parents = ObjectList.create();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.removeFirst()).getChildren()) {
                if (child.hasChildren()) {
                    parents.addLast(child);
                }
                if (consumer.test(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean foreachChild(IWidget parent, Predicate<IWidget> consumer) {
        return WidgetTree.foreachChild(parent, consumer, false);
    }

    public static boolean foreachChild(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        if (!parent.hasChildren()) {
            return true;
        }
        for (IWidget widget : parent.getChildren()) {
            if (!consumer.test(widget)) {
                return false;
            }
            if (!widget.hasChildren() || WidgetTree.foreachChild(widget, consumer, false)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T> T foreachChildWithResult(IWidget parent, Function<IWidget, T> consumer, boolean includeSelf) {
        T t;
        if (includeSelf && (t = consumer.apply(parent)) != null) {
            return t;
        }
        if (!parent.hasChildren()) {
            return null;
        }
        for (IWidget widget : parent.getChildren()) {
            T t2 = consumer.apply(widget);
            if (t2 != null) {
                return t2;
            }
            if (!widget.hasChildren() || (t2 = WidgetTree.foreachChildWithResult(widget, consumer, false)) == null) continue;
            return t2;
        }
        return null;
    }

    public static boolean foreachChildReverse(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (parent.getChildren().isEmpty()) {
            return !includeSelf || consumer.test(parent);
        }
        for (IWidget widget : parent.getChildren()) {
            if (!widget.getChildren().isEmpty() && WidgetTree.foreachChildReverse(widget, consumer, false)) {
                return false;
            }
            if (consumer.test(widget)) continue;
            return false;
        }
        return !includeSelf || consumer.test(parent);
    }

    public static Stream<IWidget> stream(IWidget parent) {
        if (!parent.hasChildren()) {
            return Stream.of(parent);
        }
        return Streams.stream(WidgetTree.iteratorBFS(parent));
    }

    public static @UnmodifiableView Iterable<IWidget> iterableBFS(IWidget parent) {
        return () -> WidgetTree.iteratorBFS(parent);
    }

    public static @UnmodifiableView Iterator<IWidget> iteratorBFS(final IWidget parent) {
        return new AbstractIterator<IWidget>(){
            private final ObjectList<IWidget> queue = ObjectList.create();
            private Iterator<IWidget> currentIt;

            protected IWidget computeNext() {
                if (this.currentIt == null) {
                    this.currentIt = parent.getChildren().iterator();
                    return parent;
                }
                if (this.currentIt.hasNext()) {
                    return this.handleWidget(this.currentIt.next());
                }
                while (!this.queue.isEmpty()) {
                    this.currentIt = this.queue.removeFirst().getChildren().iterator();
                    if (!this.currentIt.hasNext()) continue;
                    return this.handleWidget(this.currentIt.next());
                }
                return (IWidget)this.endOfData();
            }

            private IWidget handleWidget(IWidget widget) {
                if (widget.hasChildren()) {
                    this.queue.addLast(widget);
                }
                return widget;
            }
        };
    }

    public static List<IWidget> collectWidgets(IWidget parent, Predicate<IWidget> test) {
        ArrayList<IWidget> widgets = new ArrayList<IWidget>();
        WidgetTree.foreachChild(parent, w -> {
            if (test.test((IWidget)w)) {
                widgets.add((IWidget)w);
            }
            return true;
        }, true);
        return widgets;
    }

    public static <T extends IWidget> List<T> collectWidgetsByType(IWidget parent, Class<T> type) {
        return WidgetTree.collectWidgetsByType(parent, type, null);
    }

    public static <T extends IWidget> List<T> collectWidgetsByType(IWidget parent, Class<T> type, @Nullable Predicate<T> test) {
        ArrayList widgets = new ArrayList();
        WidgetTree.foreachChild(parent, w -> {
            if (w.isType(type)) {
                IWidget t = w;
                if (test == null || test.test(t)) {
                    widgets.add(t);
                }
            }
            return true;
        }, true);
        return widgets;
    }

    public static IWidget findFirst(IWidget parent, @NotNull Predicate<IWidget> test) {
        return WidgetTree.foreachChildWithResult(parent, w -> {
            if (test.test((IWidget)w)) {
                return w;
            }
            return null;
        }, true);
    }

    public static <T extends IWidget> T findFirst(IWidget parent, Class<T> type, @Nullable Predicate<T> test) {
        return (T)WidgetTree.foreachChildWithResult(parent, w -> {
            if (w.isType(type)) {
                IWidget t = w;
                if (test == null || test.test(t)) {
                    return t;
                }
            }
            return null;
        }, true);
    }

    @Nullable
    public static IWidget findFirstWithNameNullable(IWidget parent, String name) {
        return WidgetTree.foreachChildWithResult(parent, w -> w.isName(name) ? w : null, true);
    }

    @NotNull
    public static IWidget findFirstWithName(IWidget parent, String name) {
        IWidget w = WidgetTree.findFirstWithNameNullable(parent, name);
        if (w == null) {
            throw new NoSuchElementException("Expected to find widget with name '" + name + "' in sub widget tree of '" + parent + "', but non was found.");
        }
        return w;
    }

    @Nullable
    public static <T extends IWidget> T findFirstWithNameNullable(IWidget parent, String name, Class<T> type) {
        return (T)WidgetTree.foreachChildWithResult(parent, w -> w.isNameAndType(name, type) ? w : null, true);
    }

    @NotNull
    public static <T extends IWidget> T findFirstWithName(IWidget parent, String name, Class<T> type) {
        T w = WidgetTree.findFirstWithNameNullable(parent, name, type);
        if (w == null) {
            throw new NoSuchElementException("Expected to find widget with name '" + name + "' and type '" + type.getName() + "' in sub widget tree of '" + parent + "', but non was found.");
        }
        return w;
    }

    @Nullable
    public static IWidget findChildAtNullable(IWidget parent, String ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Path to child must not be empty!");
        }
        return InternalWidgetTree.findChildAt(parent, IWidget.class, path, 0, true);
    }

    @NotNull
    public static IWidget findChildAt(IWidget parent, String ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Path to child must not be empty!");
        }
        return InternalWidgetTree.findChildAt(parent, IWidget.class, path, 0, false);
    }

    @Nullable
    public static <T extends IWidget> T findChildAtNullable(IWidget parent, Class<T> type, String ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Path to child must not be empty!");
        }
        return InternalWidgetTree.findChildAt(parent, type, path, 0, true);
    }

    @NotNull
    public static <T extends IWidget> T findChildAt(IWidget parent, Class<T> type, String ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Path to child must not be empty!");
        }
        return InternalWidgetTree.findChildAt(parent, type, path, 0, false);
    }

    public static void applyPos(IWidget parent) {
        WidgetTree.foreachChildBFS(parent, child -> {
            child.resizer().applyPos((IGuiElement)child);
            return true;
        }, true);
    }

    public static IWidget findParent(IWidget parent, Predicate<IWidget> filter) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (filter.test(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return filter.test(parent) ? parent : null;
    }

    public static <T extends IWidget> T findParent(IWidget parent, Class<T> type) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (type.isAssignableFrom(parent.getClass())) {
                return (T)parent;
            }
            parent = parent.getParent();
        }
        return (T)(type.isAssignableFrom(parent.getClass()) ? parent : null);
    }

    public static boolean hasSyncedValues(ModularPanel panel) {
        return !WidgetTree.foreachChild(panel, widget -> {
            ISynced synced;
            return !(widget instanceof ISynced) || !(synced = (ISynced)((Object)widget)).isSynced();
        }, true);
    }

    @ApiStatus.Internal
    public static void collectSyncValues(PanelSyncManager syncManager, ModularPanel panel) {
        WidgetTree.collectSyncValues(syncManager, panel, true);
    }

    @ApiStatus.Internal
    public static void collectSyncValues(PanelSyncManager syncManager, ModularPanel panel, boolean includePanel) {
        WidgetTree.collectSyncValues(syncManager, panel.getName(), panel, includePanel);
    }

    @ApiStatus.Internal
    public static void collectSyncValues(PanelSyncManager syncManager, String panelName, IWidget panel, boolean includePanel) {
        MutableInt id = new MutableInt(0);
        String syncKey = "auto_sync:" + panelName;
        WidgetTree.foreachChildBFS(panel, widget -> {
            ISynced synced;
            if (widget instanceof ISynced && (synced = (ISynced)((Object)widget)).isSynced() && !syncManager.hasSyncHandler(synced.getSyncHandler())) {
                syncManager.syncValue(syncKey, id.getAndIncrement(), synced.getSyncHandler());
            }
            return true;
        }, includePanel);
    }

    public static int countUnregisteredSyncHandlers(PanelSyncManager syncManager, IWidget parent) {
        MutableInt count = new MutableInt();
        WidgetTree.foreachChildBFS(parent, widget -> {
            ISynced synced;
            if (widget instanceof ISynced && (synced = (ISynced)((Object)widget)).isSynced() && !syncManager.hasSyncHandler(synced.getSyncHandler())) {
                count.increment();
            }
            return true;
        });
        return count.intValue();
    }

    public static void drawTree(IWidget parent, ModularGuiContext context) {
        WidgetTree.drawTree(parent, context, false, true);
    }

    public static void drawTree(IWidget parent, ModularGuiContext context, boolean ignoreEnabled, boolean drawBackground) {
        InternalWidgetTree.drawTree(parent, context, ignoreEnabled, drawBackground);
    }

    public static void drawTreeForeground(IWidget parent, ModularGuiContext context) {
        InternalWidgetTree.drawTreeForeground(parent, context);
    }

    @ApiStatus.Internal
    public static void onUpdate(IWidget parent) {
        WidgetTree.foreachChildBFS(parent, widget -> {
            widget.onUpdate();
            return true;
        }, true);
    }

    @Deprecated
    public static void resize(IWidget parent) {
        parent.scheduleResize();
    }

    @ApiStatus.Internal
    public static void resizeInternal(IWidget parent, boolean onOpen) {
        long fullTime = System.nanoTime();
        while (!(parent instanceof ModularPanel) && (parent.getParent() instanceof ILayoutWidget || parent.getParent().flex().dependsOnChildren())) {
            parent = parent.getParent();
        }
        long rawTime = System.nanoTime();
        if (!InternalWidgetTree.resizeWidget(parent, true, onOpen, false) && !InternalWidgetTree.resizeWidget(parent, false, onOpen, false)) {
            if (MCHelper.getPlayer() != null) {
                MCHelper.getPlayer().sendMessage((ITextComponent)new TextComponentString(IKey.RED + "ModularUI: Failed to resize sub tree of widget '" + parent + "' of screen '" + parent.getScreen().toString() + "'. See log for more info."));
            }
            ModularUI.LOGGER.error("Failed to resize widget. Affected widget tree:");
            WidgetTree.printTree(parent, INFO_RESIZED_COLLAPSED);
        }
        rawTime = System.nanoTime() - rawTime;
        WidgetTree.applyPos(parent);
        WidgetTree.foreachChildBFS(parent, child -> {
            child.postResize();
            return true;
        }, true);
        if (logResizeTime) {
            fullTime = System.nanoTime() - fullTime;
            ModularUI.LOGGER.info("Resized widget tree in {}s and {}s for full resize.", (Object)NumberFormat.formatNanos(rawTime), (Object)NumberFormat.formatNanos(fullTime));
        }
    }

    public static void printTree(IWidget parent) {
        WidgetTree.printTree(parent, w -> true, null);
    }

    public static void printTree(IWidget parent, WidgetInfo additionalInfo) {
        WidgetTree.printTree(parent, w -> true, additionalInfo);
    }

    public static void printTree(IWidget parent, Predicate<IWidget> test) {
        WidgetTree.printTree(parent, test, null);
    }

    public static void printTree(IWidget parent, Predicate<IWidget> test, WidgetInfo additionalInfo) {
        StringBuilder builder = new StringBuilder("Widget tree of ").append(parent).append('\n');
        ModularUI.LOGGER.info((CharSequence)WidgetTree.widgetTreeToString(builder, parent, test, additionalInfo));
    }

    public static String widgetTreeToString(IWidget parent) {
        return WidgetTree.widgetTreeToString(parent, w -> true, null);
    }

    public static String widgetTreeToString(IWidget parent, WidgetInfo additionalInfo) {
        return WidgetTree.widgetTreeToString(parent, w -> true, additionalInfo);
    }

    public static String widgetTreeToString(IWidget parent, Predicate<IWidget> test) {
        return WidgetTree.widgetTreeToString(parent, test, null);
    }

    public static String widgetTreeToString(IWidget parent, Predicate<IWidget> test, WidgetInfo additionalInfo) {
        return WidgetTree.widgetTreeToString(null, parent, test, additionalInfo).toString();
    }

    public static StringBuilder widgetTreeToString(StringBuilder builder, IWidget parent, Predicate<IWidget> test, WidgetInfo additionalInfo) {
        if (builder == null) {
            builder = new StringBuilder();
        }
        InternalWidgetTree.getTree(parent, parent, test, builder, additionalInfo, "", false);
        return builder;
    }

    public static interface WidgetInfo {
        public void addInfo(IWidget var1, IWidget var2, StringBuilder var3);

        default public WidgetInfo combine(WidgetInfo other, String joiner) {
            return (root, widget, builder) -> {
                this.addInfo(root, widget, builder);
                builder.append(joiner);
                other.addInfo(root, widget, builder);
            };
        }

        default public WidgetInfo combine(WidgetInfo other) {
            return this.combine(other, " | ");
        }

        public static WidgetInfo of(String joiner, WidgetInfo ... infos) {
            return (root, widget, builder) -> {
                for (int i = 0; i < infos.length; ++i) {
                    WidgetInfo info = infos[i];
                    info.addInfo(root, widget, builder);
                    if (i >= infos.length - 1) continue;
                    builder.append(joiner);
                }
            };
        }

        public static WidgetInfo of(WidgetInfo ... infos) {
            return WidgetInfo.of(" | ", infos);
        }
    }
}

