/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.scroll;

import com.cleanroommc.modularui.animation.Animator;
import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.Scrollbar;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.widget.scroll.HorizontalScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollArea;
import com.cleanroommc.modularui.widget.scroll.VerticalScrollData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public abstract class ScrollData {
    public static final int DEFAULT_THICKNESS = -1;
    private final GuiAxis axis;
    private final boolean axisStart;
    private final int thickness;
    private int fallbackThickness = -1;
    private int scrollSpeed = 30;
    private boolean cancelScrollEdge = true;
    private IDrawable scrollbar;
    private int scrollSize;
    private int scroll;
    protected boolean dragging;
    protected int clickOffset;
    private int animatingTo = 0;
    private final Animator scrollAnimator = new Animator().duration(500).curve(Interpolation.QUAD_OUT);

    public static ScrollData of(GuiAxis axis) {
        return ScrollData.of(axis, false, -1);
    }

    public static ScrollData of(GuiAxis axis, boolean axisStart) {
        return ScrollData.of(axis, axisStart, -1);
    }

    public static ScrollData of(GuiAxis axis, boolean axisStart, int thickness) {
        if (axis.isHorizontal()) {
            return new HorizontalScrollData(axisStart, thickness);
        }
        return new VerticalScrollData(axisStart, thickness);
    }

    protected ScrollData(GuiAxis axis, boolean axisStart, int thickness) {
        this.axis = axis;
        this.axisStart = axisStart;
        this.thickness = thickness > 0 ? Math.max(2, thickness) : -1;
    }

    public GuiAxis getAxis() {
        return this.axis;
    }

    public boolean isOnAxisStart() {
        return this.axisStart;
    }

    public int getThickness() {
        return this.thickness > 0 ? this.thickness : this.fallbackThickness;
    }

    public int getScrollSpeed() {
        return this.scrollSpeed;
    }

    public void setScrollSpeed(int scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    public int getScrollSize() {
        return this.scrollSize;
    }

    public void setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
    }

    public int getScroll() {
        return this.scroll;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isVertical() {
        return this.axis.isVertical();
    }

    public boolean isHorizontal() {
        return this.axis.isHorizontal();
    }

    public final int getMinLength() {
        return this.getThickness() + 1;
    }

    public boolean isCancelScrollEdge() {
        return this.cancelScrollEdge;
    }

    public void setCancelScrollEdge(boolean cancelScrollEdge) {
        this.cancelScrollEdge = cancelScrollEdge;
    }

    protected final int getRawVisibleSize(ScrollArea area) {
        return Math.max(0, this.getRawFullVisibleSize(area) - area.getPadding().getTotal(this.axis) + area.getScrollPadding().getTotalScrollPadding(this.axis));
    }

    protected final int getRawFullVisibleSize(ScrollArea area) {
        return area.getSize(this.axis);
    }

    public final int getFullVisibleSize(ScrollArea area) {
        return this.getFullVisibleSize(area, false);
    }

    public final int getFullVisibleSize(ScrollArea area, boolean isOtherActive) {
        int s = this.getRawFullVisibleSize(area);
        ScrollData data = this.getOtherScrollData(area);
        if (data != null && (isOtherActive || data.isScrollBarActive(area, true))) {
            s -= data.getThickness();
        }
        return s;
    }

    public final int getVisibleSize(ScrollArea area) {
        return this.getVisibleSize(area, false);
    }

    public final int getVisibleSize(ScrollArea area, int fullVisibleSize) {
        return Math.max(0, fullVisibleSize - area.getPadding().getTotal(this.axis));
    }

    public final int getVisibleSize(ScrollArea area, boolean isOtherActive) {
        return this.getVisibleSize(area, this.getFullVisibleSize(area, isOtherActive));
    }

    public float getProgress(ScrollArea area, int mainAxisPos, int crossAxisPos) {
        float fullSize = this.getFullVisibleSize(area);
        return (float)(mainAxisPos - this.clickOffset) / (fullSize - (float)this.getScrollBarLength(area));
    }

    @Nullable
    public abstract ScrollData getOtherScrollData(ScrollArea var1);

    public boolean clamp(ScrollArea area) {
        int size = this.getFullVisibleSize(area);
        int old = this.scroll;
        this.scroll = this.scrollSize <= size ? 0 : MathUtils.clamp(this.scroll, 0, this.scrollSize - size);
        return old != this.scroll;
    }

    public boolean scrollBy(ScrollArea area, int x) {
        this.scroll += x;
        return this.clamp(area);
    }

    public boolean scrollTo(ScrollArea area, int x) {
        this.scroll = x;
        return this.clamp(area);
    }

    public void animateTo(ScrollArea area, int x) {
        this.scrollAnimator.bounds(this.scroll, x).onUpdate(value -> {
            if (this.scrollTo(area, (int)value)) {
                this.scrollAnimator.stop(false);
            }
        });
        this.scrollAnimator.reset();
        this.scrollAnimator.animate();
        this.animatingTo = x;
    }

    public final boolean isScrollBarActive(ScrollArea area) {
        return this.isScrollBarActive(area, false);
    }

    public final boolean isScrollBarActive(ScrollArea area, boolean isOtherActive) {
        int s = this.getRawFullVisibleSize(area);
        if (s < this.scrollSize) {
            return true;
        }
        ScrollData data = this.getOtherScrollData(area);
        if (data == null || s - data.getThickness() >= this.scrollSize) {
            return false;
        }
        if (isOtherActive || data.isScrollBarActive(area, true)) {
            s -= data.getThickness();
        }
        return s < this.scrollSize;
    }

    public final boolean isOtherScrollBarActive(ScrollArea area, boolean isSelfActive) {
        ScrollData data = this.getOtherScrollData(area);
        return data != null && data.isScrollBarActive(area, isSelfActive);
    }

    public int getScrollBarLength(ScrollArea area) {
        float fullSize = this.getFullVisibleSize(area);
        int length = (int)(fullSize * fullSize / (float)this.scrollSize);
        return Math.max(length, this.getMinLength());
    }

    public abstract boolean isInsideScrollbarArea(ScrollArea var1, int var2, int var3);

    public boolean isAnimating() {
        return this.scrollAnimator.isAnimating();
    }

    public int getAnimationDirection() {
        if (!this.isAnimating()) {
            return 0;
        }
        return this.scrollAnimator.getMax() >= this.scrollAnimator.getMin() ? 1 : -1;
    }

    public int getAnimatingTo() {
        return this.animatingTo;
    }

    public int getScrollBarStart(ScrollArea area, int scrollBarLength, int fullVisibleSize) {
        return (fullVisibleSize - scrollBarLength) * this.getScroll() / (this.getScrollSize() - fullVisibleSize);
    }

    public int getScrollBarStart(ScrollArea area, int scrollBarLength, boolean isOtherActive) {
        return this.getScrollBarStart(area, scrollBarLength, this.getFullVisibleSize(area, isOtherActive));
    }

    protected abstract int getFallbackThickness(WidgetTheme var1);

    protected final void applyWidgetTheme(WidgetTheme widgetTheme) {
        this.fallbackThickness = Math.max(2, this.getFallbackThickness(widgetTheme));
    }

    public ScrollData texture(IDrawable drawable) {
        this.scrollbar = drawable;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void drawScrollbar(ScrollArea var1, ModularGuiContext var2, WidgetTheme var3, IDrawable var4);

    @SideOnly(value=Side.CLIENT)
    protected void drawScrollBar(ModularGuiContext context, int x, int y, int w, int h, WidgetTheme widgetTheme, IDrawable texture) {
        IDrawable drawable = this.scrollbar != null ? this.scrollbar : (widgetTheme.getBackground() != null && widgetTheme.getBackground() != IDrawable.NONE ? widgetTheme.getBackground() : texture);
        if (drawable == null) {
            drawable = Scrollbar.DEFAULT;
        }
        drawable.draw(context, x, y, w, h, widgetTheme);
    }

    public boolean onMouseClicked(ScrollArea area, int mainAxisPos, int crossAxisPos, int button) {
        if (this.isOnAxisStart() ? crossAxisPos <= this.getThickness() : crossAxisPos >= area.getSize(this.axis.getOther()) - this.getThickness()) {
            this.dragging = true;
            this.clickOffset = mainAxisPos;
            int scrollBarSize = this.getScrollBarLength(area);
            int start = this.getScrollBarStart(area, scrollBarSize, false);
            boolean clickInsideBar = mainAxisPos >= start && mainAxisPos <= start + scrollBarSize;
            this.clickOffset = clickInsideBar ? mainAxisPos - start : scrollBarSize / 2;
            return true;
        }
        return false;
    }
}

