/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.sizer;

import com.cleanroommc.modularui.GuiError;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.layout.IResizeable;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Box;
import com.cleanroommc.modularui.widget.sizer.Unit;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DimensionSizer {
    private final GuiAxis axis;
    private final Unit p1 = new Unit();
    private final Unit p2 = new Unit();
    private Unit start;
    private Unit end;
    private Unit size;
    private Unit next = this.p1;
    private boolean coverChildren = false;
    private boolean expanded = false;
    private boolean cancelAutoMovement = false;
    private boolean posCalculated = false;
    private boolean sizeCalculated = false;
    private boolean marginPaddingApplied = false;
    private boolean canRelayout = false;

    public DimensionSizer(GuiAxis axis) {
        this.axis = axis;
    }

    public void reset() {
        this.p1.reset();
        this.p2.reset();
        this.start = null;
        this.end = null;
        this.size = null;
        this.next = this.p1;
    }

    public void resetPosition() {
        if (this.start != null) {
            this.start.reset();
            this.start = null;
        }
        if (this.end != null) {
            this.end.reset();
            this.end = null;
        }
        if (this.p1.isUnused()) {
            this.next = this.p1;
        } else if (this.p2.isUnused()) {
            this.next = this.p2;
        }
    }

    public void resetSize() {
        if (this.size != null) {
            this.size.reset();
            this.size = null;
        }
        if (this.p1.isUnused()) {
            this.next = this.p1;
        } else if (this.p2.isUnused()) {
            this.next = this.p2;
        }
    }

    public void setCoverChildren(boolean coverChildren, IGuiElement widget) {
        this.getSize(widget);
        this.coverChildren = coverChildren;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public void setCancelAutoMovement(boolean cancelAutoMovement) {
        this.cancelAutoMovement = cancelAutoMovement;
    }

    public void setUnit(Unit unit, Unit.State pos) {
        switch (pos) {
            case START: {
                this.getStart(null).setFrom(unit);
                break;
            }
            case END: {
                this.getEnd(null).setFrom(unit);
                break;
            }
            case SIZE: {
                this.getSize(null).setFrom(unit);
            }
        }
    }

    public boolean hasStart() {
        return this.start != null;
    }

    public boolean hasEnd() {
        return this.end != null;
    }

    public boolean hasPos() {
        return this.start != null || this.end != null;
    }

    public boolean hasFixedSize() {
        return this.start == null || this.end == null;
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public boolean isFullSize() {
        if (this.hasSize()) {
            return this.size.isRelative() && this.size.getValue() >= 0.99f && this.size.getAbsOffset() < 5;
        }
        if (this.hasStart() && this.hasEnd()) {
            return this.start.isCloseToZero() && this.end.isCloseToZero();
        }
        return false;
    }

    public boolean isSizeCalculated() {
        return this.sizeCalculated;
    }

    public boolean isPosCalculated() {
        return this.posCalculated;
    }

    public boolean canRelayout() {
        return this.canRelayout;
    }

    public boolean dependsOnChildren() {
        return this.coverChildren;
    }

    public boolean dependsOnParent() {
        return !this.coverChildren && (this.end != null || this.start != null && this.start.isRelative() || this.size != null && this.size.isRelative());
    }

    public void setResized(boolean all) {
        this.setResized(all, all);
    }

    public void setResized(boolean pos, boolean size) {
        this.posCalculated = pos;
        this.sizeCalculated = size;
        this.canRelayout &= !pos || !size;
    }

    public boolean isMarginPaddingApplied() {
        return this.marginPaddingApplied;
    }

    public void setMarginPaddingApplied(boolean marginPaddingApplied) {
        this.marginPaddingApplied = marginPaddingApplied;
    }

    private boolean needsSize(Unit unit) {
        return unit.isRelative() && unit.getAnchor() != 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void apply(Area area, IResizeable relativeTo, IntSupplier defaultSize) {
        int p;
        int s;
        if (this.sizeCalculated && this.posCalculated) {
            return;
        }
        int parentSize = relativeTo.getArea().getSize(this.axis);
        boolean calcParent = relativeTo.isSizeCalculated(this.axis);
        Box padding = relativeTo.getArea().getPadding();
        if (this.sizeCalculated && !this.posCalculated) {
            s = area.getSize(this.axis);
            if (this.start != null) {
                p = this.calcPoint(this.start, padding, s, parentSize, calcParent);
            } else {
                if (this.end == null) throw new IllegalStateException();
                p = this.calcPoint(this.end, padding, s, parentSize, calcParent) - s;
            }
        } else if (!this.sizeCalculated && this.posCalculated) {
            p = area.getRelativePoint(this.axis);
            if (this.size != null) {
                s = this.calcSize(this.size, padding, parentSize, calcParent);
            } else {
                s = defaultSize.getAsInt();
                this.sizeCalculated = s > 0;
            }
        } else if (this.start == null && this.end == null) {
            p = 0;
            if (this.size == null) {
                s = defaultSize.getAsInt();
                this.sizeCalculated = s > 0 && !this.expanded && !this.coverChildren;
            } else {
                s = this.calcSize(this.size, padding, parentSize, calcParent);
            }
            this.posCalculated = true;
            this.canRelayout = true;
        } else if (this.size == null) {
            if (this.start != null && this.end != null) {
                p = this.calcPoint(this.start, padding, -1, parentSize, calcParent);
                boolean b = this.posCalculated;
                this.posCalculated = false;
                int p2 = this.calcPoint(this.end, padding, -1, parentSize, calcParent);
                s = Math.abs(p2 - p);
                this.posCalculated &= b;
                this.sizeCalculated |= this.posCalculated;
            } else {
                s = defaultSize.getAsInt();
                boolean bl = this.sizeCalculated = s > 0 && !this.expanded;
                if (this.start == null) {
                    p = this.calcPoint(this.end, padding, s, parentSize, calcParent);
                    p -= s;
                    this.posCalculated &= this.sizeCalculated;
                } else {
                    p = this.calcPoint(this.start, padding, s, parentSize, calcParent);
                    this.posCalculated &= this.sizeCalculated || !this.needsSize(this.start);
                }
            }
        } else if (this.start != null) {
            s = this.calcSize(this.size, padding, parentSize, calcParent);
            p = this.calcPoint(this.start, padding, s, parentSize, calcParent);
            this.posCalculated &= this.sizeCalculated || !this.needsSize(this.start);
        } else {
            s = this.calcSize(this.size, padding, parentSize, calcParent);
            p = this.calcPoint(this.end, padding, s, parentSize, calcParent) - s;
            this.posCalculated &= this.sizeCalculated;
        }
        if (this.sizeCalculated && calcParent && (this.size != null && this.size.isRelative() || this.start != null && this.end != null && (this.start.isRelative() || this.end.isRelative()))) {
            Box margin = area.getMargin();
            s = Math.min(s, parentSize - margin.getTotal(this.axis));
        }
        area.setRelativePoint(this.axis, p);
        area.setPoint(this.axis, p + relativeTo.getArea().x);
        area.setSize(this.axis, s);
    }

    public int postApply(Area area, Area relativeTo, int p0, int p1) {
        int moveAmount = 0;
        int s = p1 - p0;
        area.setSize(this.axis, s);
        this.sizeCalculated = true;
        if (!this.isPosCalculated()) {
            int p;
            if (this.start != null) {
                p = this.calcPoint(this.start, relativeTo.getPadding(), s, relativeTo.getSize(this.axis), true);
            } else if (this.end != null) {
                p = this.calcPoint(this.end, relativeTo.getPadding(), s, relativeTo.getSize(this.axis), true) - s;
            } else {
                p = area.getRelativePoint(this.axis) + p0;
                if (!this.cancelAutoMovement) {
                    moveAmount = -p0;
                }
            }
            area.setRelativePoint(this.axis, p);
            this.posCalculated = true;
        }
        return moveAmount;
    }

    public void coverChildrenForEmpty(Area area, Area relativeTo) {
        int s = 0;
        area.setSize(this.axis, s);
        this.sizeCalculated = true;
        if (!this.isPosCalculated()) {
            int p = this.start != null ? this.calcPoint(this.start, relativeTo.getPadding(), s, relativeTo.getSize(this.axis), true) : (this.end != null ? this.calcPoint(this.end, relativeTo.getPadding(), s, relativeTo.getSize(this.axis), true) - s : area.getRelativePoint(this.axis));
            area.setRelativePoint(this.axis, p);
            this.posCalculated = true;
        }
    }

    public void applyMarginAndPaddingToPos(IGuiElement parent, Area area, Area relativeTo) {
        if (this.isMarginPaddingApplied()) {
            return;
        }
        this.setMarginPaddingApplied(true);
        int left = area.getMargin().getStart(this.axis) + relativeTo.getPadding().getStart(this.axis);
        int right = area.getMargin().getEnd(this.axis) + relativeTo.getPadding().getEnd(this.axis);
        if (!(left <= 0 || (this.start == null || this.start.isRelative()) && (this.end == null || this.end.isRelative() || this.size != null && this.size.isRelative()))) {
            left = 0;
        }
        if (!(right <= 0 || (this.end == null || this.end.isRelative()) && (this.start == null || this.start.isRelative() || this.size != null && this.size.isRelative()))) {
            right = 0;
        }
        if (left == 0 && right == 0) {
            return;
        }
        int parentS = relativeTo.getSize(this.axis);
        int s = area.getSize(this.axis);
        int rp = area.getRelativePoint(this.axis);
        if (left > 0) {
            if (right > 0) {
                if (left + right + s > parentS) {
                    area.setRelativePoint(this.axis, left);
                    GuiError.throwNew(parent, GuiError.Type.SIZING, "Margin/padding is set on both sides on axis " + (Object)((Object)this.axis) + ", but total size exceeds parent size.");
                    return;
                }
                if (right > parentS - s - rp) {
                    area.setRelativePoint(this.axis, parentS - right - s);
                } else if (left > rp) {
                    area.setRelativePoint(this.axis, left);
                }
                return;
            }
            if (left > rp) {
                area.setRelativePoint(this.axis, left);
            }
        } else if (right > 0 && right > parentS - s - rp) {
            area.setRelativePoint(this.axis, parentS - right - s);
        }
    }

    private int calcSize(Unit s, Box padding, int parentSize, boolean parentSizeCalculated) {
        if (this.coverChildren || this.expanded) {
            return 18;
        }
        float val = s.getValue();
        if (s.isRelative()) {
            if (!parentSizeCalculated) {
                return (int)val;
            }
            val *= (float)(parentSize - padding.getTotal(this.axis));
        }
        this.sizeCalculated = true;
        return (int)(val += (float)s.getOffset());
    }

    public int calcPoint(Unit p, Box padding, int width, int parentSize, boolean parentSizeCalculated) {
        float val = p.getValue();
        if (!parentSizeCalculated && (p == this.end || p.isRelative())) {
            return (int)val;
        }
        if (p.isRelative()) {
            val *= (float)(parentSize + padding.getTotal(this.axis));
            float anchor = p.getAnchor();
            if (width > 0 && anchor != 0.0f) {
                val -= (float)width * anchor;
            }
        }
        val += (float)p.getOffset();
        if (p == this.end) {
            val = (float)parentSize - val;
        }
        this.posCalculated = true;
        return (int)val;
    }

    private Unit getNext(IGuiElement widget, Unit.State newState) {
        Unit other;
        Unit ret = this.next;
        Unit unit = other = ret == this.p1 ? this.p2 : this.p1;
        if (ret.state != Unit.State.UNUSED) {
            if (ret.state == newState) {
                return ret;
            }
            if (other.state == newState) {
                return other;
            }
            if (ret == this.start) {
                this.start = null;
            }
            if (ret == this.end) {
                this.end = null;
            }
            if (ret == this.size) {
                this.size = null;
            }
            if (ModularUIConfig.guiDebugMode && NetworkUtils.isClient()) {
                ModularUI.LOGGER.info("unit {} of widget {} was already used and will be overwritten with unit {}", (Object)ret.state.getText(this.axis), (Object)widget, (Object)newState.getText(this.axis));
            }
        }
        ret.reset();
        ret.state = newState;
        this.next = other;
        return ret;
    }

    protected Unit getStart(IGuiElement widget) {
        if (this.start == null) {
            this.start = this.getNext(widget, Unit.State.START);
        }
        return this.start;
    }

    protected Unit getEnd(IGuiElement widget) {
        if (this.end == null) {
            this.end = this.getNext(widget, Unit.State.END);
        }
        return this.end;
    }

    protected Unit getSize(IGuiElement widget) {
        if (this.size == null) {
            this.size = this.getNext(widget, Unit.State.SIZE);
        }
        return this.size;
    }
}

