/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Box;
import java.util.function.IntSupplier;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class TextWidget<W extends TextWidget<W>>
extends Widget<W> {
    private final IKey key;
    private Alignment alignment = Alignment.CenterLeft;
    private IntSupplier color = null;
    private Boolean shadow = null;
    private float scale = 1.0f;
    private int maxWidth = -1;
    private String lastText = null;
    private String textForDefaultSize = null;

    public TextWidget(IKey key) {
        this.key = key;
    }

    public TextWidget(String key) {
        this(IKey.str(key));
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        TextRenderer renderer = TextRenderer.SHARED;
        String text = this.checkString();
        WidgetTheme theme = this.getActiveWidgetTheme(widgetTheme, this.isHovering());
        renderer.setColor(this.color != null ? this.color.getAsInt() : theme.getTextColor());
        renderer.setAlignment(this.alignment, (float)this.getArea().paddedWidth() + this.scale, this.getArea().paddedHeight());
        renderer.setShadow(this.shadow != null ? this.shadow.booleanValue() : theme.getTextShadow());
        renderer.setPos(this.getArea().getPadding().getLeft(), this.getArea().getPadding().getTop());
        renderer.setScale(this.scale);
        renderer.setSimulate(false);
        renderer.draw(text);
    }

    protected String checkString() {
        String text = this.key.getFormatted();
        if (this.lastText != null && !this.lastText.equals(text)) {
            this.onTextChanged(text);
            this.lastText = text;
        }
        return text;
    }

    protected void onTextChanged(String newText) {
        WidgetTree.resizeInternal(this, false);
    }

    private TextRenderer simulate(float maxWidth) {
        Box padding = this.getArea().getPadding();
        TextRenderer renderer = TextRenderer.SHARED;
        renderer.setAlignment(Alignment.TopLeft, maxWidth);
        renderer.setPos(padding.getLeft(), padding.getTop());
        renderer.setScale(this.scale);
        renderer.setSimulate(true);
        renderer.draw(this.getTextForDefaultSize());
        renderer.setSimulate(false);
        return renderer;
    }

    @Override
    public int getDefaultHeight() {
        float maxWidth = this.resizer().isWidthCalculated() ? (float)this.getArea().width + this.scale : (this.maxWidth > 0 ? (float)Math.max(this.maxWidth, 5) : (this.getParent().resizer().isWidthCalculated() ? (float)this.getParent().getArea().width + this.scale : (float)this.getScreen().getScreenArea().width));
        TextRenderer renderer = this.simulate(maxWidth);
        return this.getWidgetHeight(renderer.getLastActualHeight());
    }

    @Override
    public int getDefaultWidth() {
        float maxWidth = this.maxWidth > 0 ? (float)Math.max(this.maxWidth, 5) : (this.getParent().resizer().isWidthCalculated() ? (float)this.getParent().getArea().width : (float)this.getScreen().getScreenArea().width);
        TextRenderer renderer = this.simulate(maxWidth);
        return this.getWidgetWidth(renderer.getLastActualWidth());
    }

    protected int getWidgetWidth(float actualTextWidth) {
        Box padding = this.getArea().getPadding();
        return Math.max(1, (int)Math.ceil(actualTextWidth + (float)padding.horizontal()));
    }

    protected int getWidgetHeight(float actualTextHeight) {
        Box padding = this.getArea().getPadding();
        return Math.max(1, (int)Math.ceil(actualTextHeight + (float)padding.vertical()));
    }

    @Override
    public boolean canHoverThrough() {
        return true;
    }

    protected String getTextForDefaultSize() {
        if (this.textForDefaultSize == null) {
            this.lastText = this.textForDefaultSize = this.key.getFormatted();
        }
        return this.textForDefaultSize;
    }

    @Override
    public void postResize() {
        this.textForDefaultSize = null;
    }

    public IKey getKey() {
        return this.key;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public float getScale() {
        return this.scale;
    }

    @Nullable
    public IntSupplier getColor() {
        return this.color;
    }

    @Nullable
    public Boolean isShadow() {
        return this.shadow;
    }

    public W alignment(Alignment alignment) {
        this.alignment = alignment;
        return (W)((TextWidget)this.getThis());
    }

    public W color(int color) {
        return this.color(() -> color);
    }

    public W color(@Nullable IntSupplier color) {
        this.color = color;
        return (W)((TextWidget)this.getThis());
    }

    public W scale(float scale) {
        this.scale = scale;
        return (W)((TextWidget)this.getThis());
    }

    public W shadow(@Nullable Boolean shadow) {
        this.shadow = shadow;
        return (W)((TextWidget)this.getThis());
    }

    public W style(TextFormatting formatting) {
        this.key.style(formatting);
        return (W)((TextWidget)this.getThis());
    }

    public W maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return (W)((TextWidget)this.getThis());
    }
}

