/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.layout;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.ReversedList;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.sizer.Box;
import com.cleanroommc.modularui.widgets.layout.IExpander;
import java.util.List;
import java.util.function.IntFunction;

public class Flow
extends ParentWidget<Flow>
implements ILayoutWidget,
IExpander {
    private final GuiAxis axis;
    private Alignment.MainAxis maa = Alignment.MainAxis.START;
    private Alignment.CrossAxis caa = Alignment.CrossAxis.CENTER;
    private int spaceBetween = 0;
    private boolean collapseDisabledChild = false;
    private boolean reverseLayout = false;

    public static Flow row() {
        return new Flow(GuiAxis.X);
    }

    public static Flow column() {
        return new Flow(GuiAxis.Y);
    }

    public Flow(GuiAxis axis) {
        this.axis = axis;
        this.sizeRel(1.0f, 1.0f);
    }

    @Override
    public int getDefaultHeight() {
        return this.axis.isHorizontal() ? this.getDefaultCrossAxisSize() : this.getDefaultMainAxisSize();
    }

    @Override
    public int getDefaultWidth() {
        return this.axis.isHorizontal() ? this.getDefaultMainAxisSize() : this.getDefaultCrossAxisSize();
    }

    public int getDefaultMainAxisSize() {
        if (!this.hasChildren()) {
            return 18;
        }
        GuiAxis axis = this.axis;
        int total = this.getArea().getPadding().getTotal(axis);
        for (IWidget widget : this.getChildren()) {
            if (this.shouldIgnoreChildSize(widget) || widget.flex().hasPos(axis)) continue;
            total = widget.flex().isExpanded() || !widget.resizer().isSizeCalculated(axis) ? (total += axis.isHorizontal() ? widget.getDefaultWidth() : widget.getDefaultHeight()) : (total += widget.getArea().getSize(axis));
            total += widget.getArea().getMargin().getTotal(axis);
        }
        return total;
    }

    public int getDefaultCrossAxisSize() {
        if (!this.hasChildren()) {
            return 18;
        }
        GuiAxis axis = this.axis.getOther();
        int max = 0;
        for (IWidget widget : this.getChildren()) {
            if (this.shouldIgnoreChildSize(widget)) continue;
            int s = widget.getArea().getMargin().getTotal(axis);
            s = !widget.resizer().isSizeCalculated(axis) ? (s += axis.isHorizontal() ? widget.getDefaultWidth() : widget.getDefaultHeight()) : (s += widget.getArea().getSize(axis));
            max = Math.max(max, s);
        }
        return max + this.getArea().getPadding().getTotal(axis);
    }

    @Override
    public boolean layoutWidgets() {
        if (!this.hasChildren()) {
            return true;
        }
        boolean hasSize = this.resizer().isSizeCalculated(this.axis);
        Box padding = this.getArea().getPadding();
        int size = this.getArea().getSize(this.axis) - padding.getTotal(this.axis);
        Alignment.MainAxis maa = this.maa;
        if (!hasSize && maa != Alignment.MainAxis.START) {
            if (this.flex().dependsOnChildren(this.axis)) {
                maa = Alignment.MainAxis.START;
            } else {
                return false;
            }
        }
        List<IWidget> childrenList = this.reverseLayout ? new ReversedList<IWidget>(this.getChildren()) : this.getChildren();
        int space = this.spaceBetween;
        int childrenSize = 0;
        int expandedAmount = 0;
        int amount = 0;
        for (IWidget widget : childrenList) {
            if (this.shouldIgnoreChildSize(widget) || widget.flex().hasPos(this.axis)) continue;
            ++amount;
            if (widget.flex().isExpanded()) {
                ++expandedAmount;
                childrenSize += widget.getArea().getMargin().getTotal(this.axis);
                continue;
            }
            if (!widget.resizer().isSizeCalculated(this.axis)) {
                return false;
            }
            childrenSize += widget.getArea().requestedSize(this.axis);
        }
        if (amount <= 1 && (maa == Alignment.MainAxis.SPACE_BETWEEN || maa == Alignment.MainAxis.SPACE_AROUND)) {
            maa = Alignment.MainAxis.CENTER;
        }
        int spaceCount = Math.max(amount - 1, 0);
        if (maa == Alignment.MainAxis.SPACE_BETWEEN || maa == Alignment.MainAxis.SPACE_AROUND) {
            if (expandedAmount > 0) {
                maa = Alignment.MainAxis.START;
            } else {
                space = 0;
            }
        }
        childrenSize += space * spaceCount;
        if (expandedAmount > 0 && hasSize) {
            int newSize = (size - childrenSize) / expandedAmount;
            for (IWidget widget : childrenList) {
                if (this.shouldIgnoreChildSize(widget) || widget.flex().hasPos(this.axis) || !widget.flex().isExpanded()) continue;
                widget.getArea().setSize(this.axis, newSize);
                widget.resizer().setSizeResized(this.axis, true);
            }
        }
        int lastP = padding.getStart(this.axis);
        if (hasSize) {
            if (maa == Alignment.MainAxis.CENTER) {
                lastP += (int)((float)size / 2.0f - (float)childrenSize / 2.0f);
            } else if (maa == Alignment.MainAxis.END) {
                lastP += size - childrenSize;
            }
        }
        for (IWidget widget : childrenList) {
            if (this.shouldIgnoreChildSize(widget)) {
                widget.resizer().updateResized();
                widget.resizer().setMarginPaddingApplied(true);
                continue;
            }
            if (widget.flex().hasPos(this.axis)) {
                widget.resizer().updateResized();
                continue;
            }
            Box margin = widget.getArea().getMargin();
            widget.getArea().setRelativePoint(this.axis, lastP + margin.getStart(this.axis));
            widget.resizer().setPosResized(this.axis, true);
            widget.resizer().setMarginPaddingApplied(this.axis, true);
            lastP += widget.getArea().requestedSize(this.axis) + space;
            if (!hasSize || maa != Alignment.MainAxis.SPACE_BETWEEN) continue;
            lastP += (size - childrenSize) / spaceCount;
        }
        return true;
    }

    @Override
    public boolean postLayoutWidgets() {
        return Flow.layoutCrossAxisListLike(this, this.axis, this.caa);
    }

    public static boolean layoutCrossAxisListLike(IWidget parent, GuiAxis axis, Alignment.CrossAxis caa) {
        if (!parent.hasChildren()) {
            return true;
        }
        GuiAxis other = axis.getOther();
        int width = parent.getArea().getSize(other);
        Box padding = parent.getArea().getPadding();
        boolean hasWidth = parent.resizer().isSizeCalculated(other);
        if (!hasWidth && caa != Alignment.CrossAxis.START) {
            return false;
        }
        List<IWidget> childrenList = parent.getChildren();
        if (parent instanceof Flow) {
            Flow flow = (Flow)parent;
            if (flow.reverseLayout) {
                childrenList = new ReversedList<IWidget>(parent.getChildren());
            }
        }
        for (IWidget widget : childrenList) {
            if (widget.flex().hasPos(axis)) continue;
            Box margin = widget.getArea().getMargin();
            if (!widget.flex().hasPos(other) && widget.resizer().isSizeCalculated(other)) {
                int crossAxisPos = margin.getStart(other) + padding.getStart(other);
                if (hasWidth) {
                    if (caa == Alignment.CrossAxis.CENTER) {
                        crossAxisPos = (int)((float)width / 2.0f - (float)widget.getArea().getSize(other) / 2.0f);
                    } else if (caa == Alignment.CrossAxis.END) {
                        crossAxisPos = width - widget.getArea().getSize(other) - margin.getEnd(other) - padding.getStart(other);
                    }
                }
                widget.getArea().setRelativePoint(other, crossAxisPos);
                widget.getArea().setPoint(other, parent.getArea().getPoint(other) + crossAxisPos);
                widget.resizer().setPosResized(other, true);
                widget.resizer().setMarginPaddingApplied(other, true);
            }
            if (!parent.isValid()) continue;
            widget.flex().applyPos(widget);
        }
        return true;
    }

    @Override
    public boolean canCoverByDefaultSize(GuiAxis axis) {
        return axis.getOther() == this.axis;
    }

    @Override
    public boolean shouldIgnoreChildSize(IWidget child) {
        return this.collapseDisabledChild && !child.isEnabled();
    }

    @Override
    public void onChildChangeEnabled(IWidget child, boolean enabled) {
        if (this.collapseDisabledChild) {
            ILayoutWidget.super.onChildChangeEnabled(child, enabled);
        }
    }

    public Flow children(Iterable<IWidget> widgets) {
        for (IWidget widget : widgets) {
            this.child(widget);
        }
        return (Flow)this.getThis();
    }

    public Flow children(int amount, IntFunction<IWidget> widgetCreator) {
        for (int i = 0; i < amount; ++i) {
            this.child(widgetCreator.apply(i));
        }
        return (Flow)this.getThis();
    }

    public Flow crossAxisAlignment(Alignment.CrossAxis caa) {
        this.caa = caa;
        return this;
    }

    public Flow mainAxisAlignment(Alignment.MainAxis maa) {
        this.maa = maa;
        return this;
    }

    public Flow childPadding(int spaceBetween) {
        this.spaceBetween = spaceBetween;
        return this;
    }

    public Flow collapseDisabledChild() {
        this.collapseDisabledChild = true;
        return this;
    }

    public Flow collapseDisabledChild(boolean collapse) {
        this.collapseDisabledChild = collapse;
        return this;
    }

    public Flow reverseLayout(boolean reverseLayout) {
        this.reverseLayout = reverseLayout;
        return this;
    }

    public GuiAxis getAxis() {
        return this.axis;
    }

    @Override
    public GuiAxis getExpandAxis() {
        return this.axis;
    }

    @Override
    protected String getTypeName() {
        return this.axis.isHorizontal() ? "Row" : "Column";
    }
}

