/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.slot;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiAccessor;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiContainerAccessor;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiScreenAccessor;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.integration.recipeviewer.RecipeViewerIngredientProvider;
import com.cleanroommc.modularui.screen.ClientScreenHandler;
import com.cleanroommc.modularui.screen.NEAAnimationHandler;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.SlotTheme;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.value.sync.ItemSlotSH;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.PhantomItemSlot;
import com.cleanroommc.modularui.widgets.slot.PlayerSlotType;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSlot
extends Widget<ItemSlot>
implements IVanillaSlot,
Interactable,
RecipeViewerIngredientProvider {
    public static final int SIZE = 18;
    private ItemSlotSH syncHandler;

    public static ItemSlot create(boolean phantom) {
        return phantom ? new PhantomItemSlot() : new ItemSlot();
    }

    public ItemSlot() {
        this.tooltip().setAutoUpdate(true);
        this.tooltipBuilder(tooltip -> {
            if (!this.isSynced()) {
                return;
            }
            ItemStack stack = this.getSlot().getStack();
            this.buildTooltip(stack, (RichTooltip)tooltip);
        });
    }

    @Override
    public void onInit() {
        if (this.getScreen().isOverlay()) {
            throw new IllegalStateException("Overlays can't have slots!");
        }
        this.size(18);
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        this.syncHandler = this.castIfTypeElseNull(syncHandler, ItemSlotSH.class);
        return this.syncHandler != null;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        boolean shouldBeEnabled = this.areAncestorsEnabled();
        if (shouldBeEnabled != this.getSlot().isEnabled()) {
            this.syncHandler.setEnabled(shouldBeEnabled, true);
        }
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        if (this.syncHandler == null) {
            return;
        }
        RenderHelper.enableGUIStandardItemLighting();
        this.drawSlot(this.getSlot());
        RenderHelper.enableStandardItemLighting();
        GlStateManager.disableLighting();
        this.drawOverlay();
    }

    protected void drawOverlay() {
        if (this.isHovering() && (!ModularUI.Mods.NEA.isLoaded() || NEAConfig.itemHoverOverlay)) {
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawRect(1.0f, 1.0f, 16.0f, 16.0f, this.getSlotHoverColor());
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        RichTooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.getShowUpTimer())) {
            tooltip.draw(this.getContext(), this.getSlot().getStack());
        }
    }

    public void buildTooltip(ItemStack stack, RichTooltip tooltip) {
        if (stack.isEmpty()) {
            return;
        }
        tooltip.addFromItem(stack);
    }

    @Override
    public WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        WidgetThemeEntry<SlotTheme> widgetThemeEntry;
        PlayerSlotType playerSlotType;
        PlayerSlotType playerSlotType2 = playerSlotType = this.syncHandler != null ? this.syncHandler.getPlayerSlotType() : null;
        if (playerSlotType == null) {
            return theme.getWidgetTheme(IThemeApi.ITEM_SLOT);
        }
        switch (playerSlotType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case HOTBAR: {
                widgetThemeEntry = theme.getWidgetTheme(IThemeApi.ITEM_SLOT_PLAYER_HOTBAR);
                break;
            }
            case MAIN_INVENTORY: {
                widgetThemeEntry = theme.getWidgetTheme(IThemeApi.ITEM_SLOT_PLAYER_MAIN_INV);
                break;
            }
            case OFFHAND: {
                widgetThemeEntry = theme.getWidgetTheme(IThemeApi.ITEM_SLOT_PLAYER_OFFHAND);
                break;
            }
            case ARMOR: {
                widgetThemeEntry = theme.getWidgetTheme(IThemeApi.ITEM_SLOT_PLAYER_ARMOR);
            }
        }
        return widgetThemeEntry;
    }

    public int getSlotHoverColor() {
        WidgetThemeEntry<SlotTheme> theme = this.getWidgetTheme(this.getContext().getTheme(), SlotTheme.class);
        return theme.getTheme().getSlotHoverColor();
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        ClientScreenHandler.clickSlot(this.getScreen(), (Slot)this.getSlot());
        return Interactable.Result.SUCCESS;
    }

    @Override
    public boolean onMouseRelease(int mouseButton) {
        ClientScreenHandler.releaseSlot();
        return true;
    }

    @Override
    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        ClientScreenHandler.dragSlot(timeSinceClick);
    }

    public ModularSlot getSlot() {
        return this.syncHandler.getSlot();
    }

    @Override
    public Slot getVanillaSlot() {
        return this.syncHandler.getSlot();
    }

    @Override
    public boolean handleAsVanillaSlot() {
        return true;
    }

    @Override
    @NotNull
    public ItemSlotSH getSyncHandler() {
        if (this.syncHandler == null) {
            throw new IllegalStateException("Widget is not initialised!");
        }
        return this.syncHandler;
    }

    public ItemSlot slot(ModularSlot slot) {
        return this.syncHandler(new ItemSlotSH(slot));
    }

    public ItemSlot slot(IItemHandlerModifiable itemHandler, int index) {
        return this.slot(new ModularSlot((IItemHandler)itemHandler, index));
    }

    public ItemSlot syncHandler(ItemSlotSH syncHandler) {
        this.syncHandler = syncHandler;
        this.setSyncHandler(this.syncHandler);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void drawSlot(ModularSlot slotIn) {
        GuiScreen guiScreen = this.getScreen().getScreenWrapper().getGuiScreen();
        if (!(guiScreen instanceof GuiContainer)) {
            throw new IllegalStateException("The gui must be an instance of GuiContainer if it contains slots!");
        }
        GuiContainer guiContainer = (GuiContainer)guiScreen;
        GuiContainerAccessor acc = (GuiContainerAccessor)guiScreen;
        RenderItem renderItem = ((GuiScreenAccessor)guiScreen).getItemRender();
        ItemStack itemstack = slotIn.getStack();
        boolean isDragPreview = false;
        boolean flag1 = slotIn == acc.getClickedSlot() && !acc.getDraggedStack().isEmpty() && !acc.getIsRightMouseClick();
        ItemStack itemstack1 = guiScreen.mc.player.inventory.getItemStack();
        int amount = -1;
        String format = null;
        if (!this.getSyncHandler().isPhantom()) {
            if (slotIn == acc.getClickedSlot() && !acc.getDraggedStack().isEmpty() && acc.getIsRightMouseClick() && !itemstack.isEmpty()) {
                itemstack = itemstack.copy();
                itemstack.setCount(itemstack.getCount() / 2);
            } else if (acc.getDragSplitting() && acc.getDragSplittingSlots().contains((Object)slotIn) && !itemstack1.isEmpty()) {
                if (acc.getDragSplittingSlots().size() == 1) {
                    return;
                }
                if (Container.canAddItemToSlot((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && this.getScreen().getContainer().canDragIntoSlot((Slot)slotIn)) {
                    itemstack = itemstack1.copy();
                    isDragPreview = true;
                    Container.computeStackSize(acc.getDragSplittingSlots(), (int)acc.getDragSplittingLimit(), (ItemStack)itemstack, (int)(slotIn.getStack().isEmpty() ? 0 : slotIn.getStack().getCount()));
                    int k = Math.min(itemstack.getMaxStackSize(), slotIn.getItemStackLimit(itemstack));
                    if (itemstack.getCount() > k) {
                        amount = k;
                        format = TextFormatting.YELLOW.toString();
                        itemstack.setCount(k);
                    }
                } else {
                    acc.getDragSplittingSlots().remove((Object)slotIn);
                    acc.invokeUpdateDragSplitting();
                }
            }
        }
        float z = this.getContext().getCurrentDrawingZ() + 100;
        ((GuiAccessor)guiScreen).setZLevel(z);
        renderItem.zLevel = z;
        if (!flag1) {
            if (isDragPreview) {
                GuiDraw.drawRect(1.0f, 1.0f, 16.0f, 16.0f, -2130706433);
            }
            if (!(itemstack = NEAAnimationHandler.injectVirtualStack(itemstack, guiContainer, slotIn)).isEmpty()) {
                Platform.setupDrawItem();
                float itemScale = NEAAnimationHandler.injectHoverScale(guiContainer, slotIn);
                renderItem.renderItemAndEffectIntoGUI((EntityLivingBase)guiScreen.mc.player, itemstack, 1, 1);
                Platform.endDrawItem();
                if (amount < 0) {
                    amount = itemstack.getCount();
                }
                GuiDraw.drawStandardSlotAmountText(amount, format, this.getArea());
                int cachedCount = itemstack.getCount();
                itemstack.setCount(1);
                renderItem.renderItemOverlayIntoGUI(((GuiScreenAccessor)guiScreen).getFontRenderer(), itemstack, 1, 1, null);
                NEAAnimationHandler.endHoverScale();
                itemstack.setCount(cachedCount);
                GlStateManager.disableDepth();
            }
        }
        ((GuiAccessor)guiScreen).setZLevel(0.0f);
        renderItem.zLevel = 0.0f;
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.syncHandler.getSlot().getStack();
    }
}

