/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import java.util.ArrayList;
import java.util.List;
import org.mariuszgromada.math.mxparser.mathcollection.MathConstants;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialValue;

public class SpecialValueTrigonometric {
    public static final double EPSILON = 1.0E-13;
    public static final double SIN_0 = 0.0;
    public static final double COS_0 = 1.0;
    public static final double TAN_0 = 0.0;
    public static final double CTAN_0 = Double.NaN;
    public static final double SEC_0 = 1.0;
    public static final double CSC_0 = Double.NaN;
    public static final double SIN_30 = 0.5;
    public static final double COS_30 = MathConstants.SQRT3BY2;
    public static final double TAN_30 = MathConstants.SQRT3BY3;
    public static final double CTAN_30 = MathConstants.SQRT3;
    public static final double SEC_30 = MathConstants.D2BYSQRT3;
    public static final double CSC_30 = 2.0;
    public static final double SIN_45 = MathConstants.SQRT2BY2;
    public static final double COS_45 = MathConstants.SQRT2BY2;
    public static final double TAN_45 = 1.0;
    public static final double CTAN_45 = 1.0;
    public static final double SEC_45 = MathConstants.SQRT2;
    public static final double CSC_45 = MathConstants.SQRT2;
    public static final double SIN_60 = MathConstants.SQRT3BY2;
    public static final double COS_60 = 0.5;
    public static final double TAN_60 = MathConstants.SQRT3;
    public static final double CTAN_60 = MathConstants.SQRT3BY3;
    public static final double SEC_60 = 2.0;
    public static final double CSC_60 = MathConstants.D2BYSQRT3;
    public static final double SIN_90 = 1.0;
    public static final double COS_90 = 0.0;
    public static final double TAN_90 = Double.NaN;
    public static final double CTAN_90 = 0.0;
    public static final double SEC_90 = Double.NaN;
    public static final double CSC_90 = 1.0;
    public static final double SIN_120 = SIN_60;
    public static final double COS_120 = -0.5;
    public static final double TAN_120 = -TAN_60;
    public static final double CTAN_120 = -CTAN_60;
    public static final double SEC_120 = -2.0;
    public static final double CSC_120 = CSC_60;
    public static final double SIN_135 = SIN_45;
    public static final double COS_135 = -COS_45;
    public static final double TAN_135 = -1.0;
    public static final double CTAN_135 = -1.0;
    public static final double SEC_135 = -SEC_45;
    public static final double CSC_135 = CSC_45;
    public static final double SIN_150 = 0.5;
    public static final double COS_150 = -COS_30;
    public static final double TAN_150 = -TAN_30;
    public static final double CTAN_150 = -CTAN_30;
    public static final double SEC_150 = -SEC_30;
    public static final double CSC_150 = 2.0;
    public static final double SIN_180 = 0.0;
    public static final double COS_180 = -1.0;
    public static final double TAN_180 = 0.0;
    public static final double CTAN_180 = Double.NaN;
    public static final double SEC_180 = -1.0;
    public static final double CSC_180 = Double.NaN;
    public static final double SIN_210 = -0.5;
    public static final double COS_210 = -COS_30;
    public static final double TAN_210 = TAN_30;
    public static final double CTAN_210 = CTAN_30;
    public static final double SEC_210 = -SEC_30;
    public static final double CSC_210 = -2.0;
    public static final double SIN_225 = -SIN_45;
    public static final double COS_225 = -COS_45;
    public static final double TAN_225 = 1.0;
    public static final double CTAN_225 = 1.0;
    public static final double SEC_225 = -SEC_45;
    public static final double CSC_225 = -CSC_45;
    public static final double SIN_240 = -SIN_60;
    public static final double COS_240 = -0.5;
    public static final double TAN_240 = TAN_60;
    public static final double CTAN_240 = CTAN_60;
    public static final double SEC_240 = -2.0;
    public static final double CSC_240 = -CSC_60;
    public static final double SIN_270 = -1.0;
    public static final double COS_270 = 0.0;
    public static final double TAN_270 = Double.NaN;
    public static final double CTAN_270 = 0.0;
    public static final double SEC_270 = Double.NaN;
    public static final double CSC_270 = -1.0;
    public static final double SIN_300 = -SIN_60;
    public static final double COS_300 = 0.5;
    public static final double TAN_300 = -TAN_60;
    public static final double CTAN_300 = -CTAN_60;
    public static final double SEC_300 = 2.0;
    public static final double CSC_300 = -CSC_60;
    public static final double SIN_315 = -SIN_45;
    public static final double COS_315 = COS_45;
    public static final double TAN_315 = -1.0;
    public static final double CTAN_315 = -1.0;
    public static final double SEC_315 = SEC_45;
    public static final double CSC_315 = -CSC_45;
    public static final double SIN_330 = -0.5;
    public static final double COS_330 = COS_30;
    public static final double TAN_330 = -TAN_30;
    public static final double CTAN_330 = -CTAN_30;
    public static final double SEC_330 = SEC_30;
    public static final double CSC_330 = -2.0;
    public static final double SIN_360 = 0.0;
    public static final double COS_360 = 1.0;
    public static final double TAN_360 = 0.0;
    public static final double CTAN_360 = Double.NaN;
    public static final double SEC_360 = 1.0;
    public static final double CSC_360 = Double.NaN;
    public static SpecialValueTrigonometric[] valuesListTrig = new SpecialValueTrigonometric[]{new SpecialValueTrigonometric(0.0, 0.0, 1.0, 0.0, Double.NaN, 1.0, Double.NaN), new SpecialValueTrigonometric(2.0, 0.0, 1.0, 0.0, Double.NaN, 1.0, Double.NaN), new SpecialValueTrigonometric(-2.0, 0.0, 1.0, 0.0, Double.NaN, 1.0, Double.NaN), new SpecialValueTrigonometric(4.0, 0.0, 1.0, 0.0, Double.NaN, 1.0, Double.NaN), new SpecialValueTrigonometric(-4.0, 0.0, 1.0, 0.0, Double.NaN, 1.0, Double.NaN), new SpecialValueTrigonometric(0.16666666666666666, 0.5, COS_30, TAN_30, CTAN_30, SEC_30, 2.0), new SpecialValueTrigonometric(2.1666666666666665, 0.5, COS_30, TAN_30, CTAN_30, SEC_30, 2.0), new SpecialValueTrigonometric(-1.8333333333333333, 0.5, COS_30, TAN_30, CTAN_30, SEC_30, 2.0), new SpecialValueTrigonometric(4.166666666666667, 0.5, COS_30, TAN_30, CTAN_30, SEC_30, 2.0), new SpecialValueTrigonometric(-3.8333333333333335, 0.5, COS_30, TAN_30, CTAN_30, SEC_30, 2.0), new SpecialValueTrigonometric(0.25, SIN_45, COS_45, 1.0, 1.0, SEC_45, CSC_45), new SpecialValueTrigonometric(2.25, SIN_45, COS_45, 1.0, 1.0, SEC_45, CSC_45), new SpecialValueTrigonometric(-1.75, SIN_45, COS_45, 1.0, 1.0, SEC_45, CSC_45), new SpecialValueTrigonometric(4.25, SIN_45, COS_45, 1.0, 1.0, SEC_45, CSC_45), new SpecialValueTrigonometric(-3.75, SIN_45, COS_45, 1.0, 1.0, SEC_45, CSC_45), new SpecialValueTrigonometric(0.3333333333333333, SIN_60, 0.5, TAN_60, CTAN_60, 2.0, CSC_60), new SpecialValueTrigonometric(2.3333333333333335, SIN_60, 0.5, TAN_60, CTAN_60, 2.0, CSC_60), new SpecialValueTrigonometric(-1.6666666666666667, SIN_60, 0.5, TAN_60, CTAN_60, 2.0, CSC_60), new SpecialValueTrigonometric(4.333333333333333, SIN_60, 0.5, TAN_60, CTAN_60, 2.0, CSC_60), new SpecialValueTrigonometric(-3.6666666666666665, SIN_60, 0.5, TAN_60, CTAN_60, 2.0, CSC_60), new SpecialValueTrigonometric(0.5, 1.0, 0.0, Double.NaN, 0.0, Double.NaN, 1.0), new SpecialValueTrigonometric(2.5, 1.0, 0.0, Double.NaN, 0.0, Double.NaN, 1.0), new SpecialValueTrigonometric(-1.5, 1.0, 0.0, Double.NaN, 0.0, Double.NaN, 1.0), new SpecialValueTrigonometric(4.5, 1.0, 0.0, Double.NaN, 0.0, Double.NaN, 1.0), new SpecialValueTrigonometric(-3.5, 1.0, 0.0, Double.NaN, 0.0, Double.NaN, 1.0), new SpecialValueTrigonometric(0.6666666666666666, SIN_120, -0.5, TAN_120, CTAN_120, -2.0, CSC_120), new SpecialValueTrigonometric(2.6666666666666665, SIN_120, -0.5, TAN_120, CTAN_120, -2.0, CSC_120), new SpecialValueTrigonometric(-1.3333333333333333, SIN_120, -0.5, TAN_120, CTAN_120, -2.0, CSC_120), new SpecialValueTrigonometric(4.666666666666667, SIN_120, -0.5, TAN_120, CTAN_120, -2.0, CSC_120), new SpecialValueTrigonometric(-3.3333333333333335, SIN_120, -0.5, TAN_120, CTAN_120, -2.0, CSC_120), new SpecialValueTrigonometric(0.75, SIN_135, COS_135, -1.0, -1.0, SEC_135, CSC_135), new SpecialValueTrigonometric(2.75, SIN_135, COS_135, -1.0, -1.0, SEC_135, CSC_135), new SpecialValueTrigonometric(-1.25, SIN_135, COS_135, -1.0, -1.0, SEC_135, CSC_135), new SpecialValueTrigonometric(4.75, SIN_135, COS_135, -1.0, -1.0, SEC_135, CSC_135), new SpecialValueTrigonometric(-3.25, SIN_135, COS_135, -1.0, -1.0, SEC_135, CSC_135), new SpecialValueTrigonometric(0.8333333333333334, 0.5, COS_150, TAN_150, CTAN_150, SEC_150, 2.0), new SpecialValueTrigonometric(2.8333333333333335, 0.5, COS_150, TAN_150, CTAN_150, SEC_150, 2.0), new SpecialValueTrigonometric(-1.1666666666666667, 0.5, COS_150, TAN_150, CTAN_150, SEC_150, 2.0), new SpecialValueTrigonometric(4.833333333333333, 0.5, COS_150, TAN_150, CTAN_150, SEC_150, 2.0), new SpecialValueTrigonometric(-3.1666666666666665, 0.5, COS_150, TAN_150, CTAN_150, SEC_150, 2.0), new SpecialValueTrigonometric(1.0, 0.0, -1.0, 0.0, Double.NaN, -1.0, Double.NaN), new SpecialValueTrigonometric(3.0, 0.0, -1.0, 0.0, Double.NaN, -1.0, Double.NaN), new SpecialValueTrigonometric(-1.0, 0.0, -1.0, 0.0, Double.NaN, -1.0, Double.NaN), new SpecialValueTrigonometric(5.0, 0.0, -1.0, 0.0, Double.NaN, -1.0, Double.NaN), new SpecialValueTrigonometric(-3.0, 0.0, -1.0, 0.0, Double.NaN, -1.0, Double.NaN), new SpecialValueTrigonometric(1.1666666666666667, -0.5, COS_210, TAN_210, CTAN_210, SEC_210, -2.0), new SpecialValueTrigonometric(3.1666666666666665, -0.5, COS_210, TAN_210, CTAN_210, SEC_210, -2.0), new SpecialValueTrigonometric(-0.8333333333333334, -0.5, COS_210, TAN_210, CTAN_210, SEC_210, -2.0), new SpecialValueTrigonometric(5.166666666666667, -0.5, COS_210, TAN_210, CTAN_210, SEC_210, -2.0), new SpecialValueTrigonometric(-2.8333333333333335, -0.5, COS_210, TAN_210, CTAN_210, SEC_210, -2.0), new SpecialValueTrigonometric(1.25, SIN_225, COS_225, 1.0, 1.0, SEC_225, CSC_225), new SpecialValueTrigonometric(3.25, SIN_225, COS_225, 1.0, 1.0, SEC_225, CSC_225), new SpecialValueTrigonometric(-0.75, SIN_225, COS_225, 1.0, 1.0, SEC_225, CSC_225), new SpecialValueTrigonometric(5.25, SIN_225, COS_225, 1.0, 1.0, SEC_225, CSC_225), new SpecialValueTrigonometric(-2.75, SIN_225, COS_225, 1.0, 1.0, SEC_225, CSC_225), new SpecialValueTrigonometric(1.3333333333333333, SIN_240, -0.5, TAN_240, CTAN_240, -2.0, CSC_240), new SpecialValueTrigonometric(3.3333333333333335, SIN_240, -0.5, TAN_240, CTAN_240, -2.0, CSC_240), new SpecialValueTrigonometric(-0.6666666666666666, SIN_240, -0.5, TAN_240, CTAN_240, -2.0, CSC_240), new SpecialValueTrigonometric(5.333333333333333, SIN_240, -0.5, TAN_240, CTAN_240, -2.0, CSC_240), new SpecialValueTrigonometric(-2.6666666666666665, SIN_240, -0.5, TAN_240, CTAN_240, -2.0, CSC_240), new SpecialValueTrigonometric(1.5, -1.0, 0.0, Double.NaN, 0.0, Double.NaN, -1.0), new SpecialValueTrigonometric(3.5, -1.0, 0.0, Double.NaN, 0.0, Double.NaN, -1.0), new SpecialValueTrigonometric(-0.5, -1.0, 0.0, Double.NaN, 0.0, Double.NaN, -1.0), new SpecialValueTrigonometric(5.5, -1.0, 0.0, Double.NaN, 0.0, Double.NaN, -1.0), new SpecialValueTrigonometric(-2.5, -1.0, 0.0, Double.NaN, 0.0, Double.NaN, -1.0), new SpecialValueTrigonometric(1.6666666666666667, SIN_300, 0.5, TAN_300, CTAN_300, 2.0, CSC_300), new SpecialValueTrigonometric(3.6666666666666665, SIN_300, 0.5, TAN_300, CTAN_300, 2.0, CSC_300), new SpecialValueTrigonometric(-0.3333333333333333, SIN_300, 0.5, TAN_300, CTAN_300, 2.0, CSC_300), new SpecialValueTrigonometric(5.666666666666667, SIN_300, 0.5, TAN_300, CTAN_300, 2.0, CSC_300), new SpecialValueTrigonometric(-2.3333333333333335, SIN_300, 0.5, TAN_300, CTAN_300, 2.0, CSC_300), new SpecialValueTrigonometric(1.75, SIN_315, COS_315, -1.0, -1.0, SEC_315, CSC_315), new SpecialValueTrigonometric(3.75, SIN_315, COS_315, -1.0, -1.0, SEC_315, CSC_315), new SpecialValueTrigonometric(-0.25, SIN_315, COS_315, -1.0, -1.0, SEC_315, CSC_315), new SpecialValueTrigonometric(5.75, SIN_315, COS_315, -1.0, -1.0, SEC_315, CSC_315), new SpecialValueTrigonometric(-2.25, SIN_315, COS_315, -1.0, -1.0, SEC_315, CSC_315), new SpecialValueTrigonometric(1.8333333333333333, -0.5, COS_330, TAN_330, CTAN_330, SEC_330, -2.0), new SpecialValueTrigonometric(3.8333333333333335, -0.5, COS_330, TAN_330, CTAN_330, SEC_330, -2.0), new SpecialValueTrigonometric(-0.16666666666666666, -0.5, COS_330, TAN_330, CTAN_330, SEC_330, -2.0), new SpecialValueTrigonometric(5.833333333333333, -0.5, COS_330, TAN_330, CTAN_330, SEC_330, -2.0), new SpecialValueTrigonometric(-2.1666666666666665, -0.5, COS_330, TAN_330, CTAN_330, SEC_330, -2.0), new SpecialValueTrigonometric(6.0, 0.0, 1.0, 0.0, Double.NaN, 1.0, Double.NaN)};
    public static List<SpecialValue> valuesListAsin;
    public static List<SpecialValue> valuesListAcos;
    public static List<SpecialValue> valuesListAtan;
    public static List<SpecialValue> valuesListActan;
    public static List<SpecialValue> valuesListAsec;
    public static List<SpecialValue> valuesListAcsc;
    public double factor;
    public double xrad;
    public double xdeg;
    public double xradFrom;
    public double xradTo;
    public double sin;
    public double cos;
    public double tan;
    public double ctan;
    public double sec;
    public double csc;

    public SpecialValueTrigonometric(double factor, double sin, double cos, double tan, double ctan, double sec, double csc) {
        this.factor = factor;
        this.xrad = factor * Math.PI;
        this.xdeg = MathFunctions.round(factor * 180.0, 0);
        this.sin = sin;
        this.cos = cos;
        this.tan = tan;
        this.ctan = ctan;
        this.sec = sec;
        this.csc = csc;
        this.xradFrom = this.xrad - 1.0E-13;
        this.xradTo = this.xrad + 1.0E-13;
        if (-1.5707963267949965 <= this.xrad && this.xrad <= 1.5707963267949965) {
            if (valuesListAsin == null) {
                valuesListAsin = new ArrayList<SpecialValue>();
            }
            if (valuesListAtan == null) {
                valuesListAtan = new ArrayList<SpecialValue>();
            }
            if (valuesListAcsc == null) {
                valuesListAcsc = new ArrayList<SpecialValue>();
            }
            valuesListAsin.add(new SpecialValue(sin, this.xrad, this.xdeg));
            valuesListAtan.add(new SpecialValue(tan, this.xrad, this.xdeg));
            valuesListAcsc.add(new SpecialValue(csc, this.xrad, this.xdeg));
        }
        if (-1.0E-13 <= this.xrad && this.xrad <= 3.141592653589893) {
            if (valuesListAcos == null) {
                valuesListAcos = new ArrayList<SpecialValue>();
            }
            if (valuesListActan == null) {
                valuesListActan = new ArrayList<SpecialValue>();
            }
            if (valuesListAsec == null) {
                valuesListAsec = new ArrayList<SpecialValue>();
            }
            valuesListAcos.add(new SpecialValue(cos, this.xrad, this.xdeg));
            valuesListActan.add(new SpecialValue(ctan, this.xrad, this.xdeg));
            valuesListAsec.add(new SpecialValue(sec, this.xrad, this.xdeg));
        }
    }

    public static SpecialValueTrigonometric getSpecialValueTrigonometric(double xrad) {
        if (SpecialValue.specialCasesDisabled) {
            return null;
        }
        if (Double.isNaN(xrad)) {
            return null;
        }
        if (Double.isInfinite(xrad)) {
            return null;
        }
        for (SpecialValueTrigonometric sv : valuesListTrig) {
            if (!(sv.xradFrom <= xrad) || !(xrad <= sv.xradTo)) continue;
            return sv;
        }
        return null;
    }

    public static SpecialValue getSpecialValueAsin(double x) {
        return SpecialValueTrigonometric.getSpecialValue(x, valuesListAsin);
    }

    public static SpecialValue getSpecialValueAcos(double x) {
        return SpecialValueTrigonometric.getSpecialValue(x, valuesListAcos);
    }

    public static SpecialValue getSpecialValueAtan(double x) {
        return SpecialValueTrigonometric.getSpecialValue(x, valuesListAtan);
    }

    public static SpecialValue getSpecialValueActan(double x) {
        return SpecialValueTrigonometric.getSpecialValue(x, valuesListActan);
    }

    public static SpecialValue getSpecialValueAsec(double x) {
        return SpecialValueTrigonometric.getSpecialValue(x, valuesListAsec);
    }

    public static SpecialValue getSpecialValueAcsc(double x) {
        return SpecialValueTrigonometric.getSpecialValue(x, valuesListAcsc);
    }

    private static SpecialValue getSpecialValue(double x, List<SpecialValue> valuesList) {
        if (SpecialValue.specialCasesDisabled) {
            return null;
        }
        if (Double.isNaN(x)) {
            return null;
        }
        if (Double.isInfinite(x)) {
            return null;
        }
        for (SpecialValue sv : valuesList) {
            if (!(sv.xFrom <= x) || !(x <= sv.xTo)) continue;
            return sv;
        }
        return null;
    }
}

