/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;

public final class Statistics {
    public static double avg(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        double sum = 0.0;
        int n = 0;
        if (to >= from && delta > 0.0) {
            double i;
            for (i = from; i < to; i += delta) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                sum += MathFunctions.getFunctionValue(f, index, i);
                ++n;
            }
            if (delta - (i - to) > 0.5 * delta) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                sum += MathFunctions.getFunctionValue(f, index, to);
                ++n;
            }
        } else if (to <= from && delta < 0.0) {
            double i;
            for (i = from; i > to; i += delta) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                sum += MathFunctions.getFunctionValue(f, index, i);
                ++n;
            }
            if (-delta - (to - i) > -0.5 * delta) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                sum += MathFunctions.getFunctionValue(f, index, to);
                ++n;
            }
        } else if (from == to) {
            return MathFunctions.getFunctionValue(f, index, from);
        }
        return sum / (double)n;
    }

    public static double var(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        return Statistics.var(MathFunctions.getFunctionValues(f, index, from, to, delta));
    }

    public static double std(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        return Statistics.std(MathFunctions.getFunctionValues(f, index, from, to, delta));
    }

    public static double avg(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            return numbers[0];
        }
        double sum = 0.0;
        for (double xi : numbers) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            if (Double.isNaN(xi)) {
                return Double.NaN;
            }
            sum += xi;
        }
        return sum / (double)numbers.length;
    }

    public static double var(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            if (Double.isNaN(numbers[0])) {
                return Double.NaN;
            }
            return 0.0;
        }
        double m = Statistics.avg(numbers);
        double sum = 0.0;
        for (double xi : numbers) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            if (Double.isNaN(xi)) {
                return Double.NaN;
            }
            sum += (xi - m) * (xi - m);
        }
        return sum / (double)(numbers.length - 1);
    }

    public static double std(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            if (Double.isNaN(numbers[0])) {
                return Double.NaN;
            }
            return 0.0;
        }
        return MathFunctions.sqrt(Statistics.var(numbers));
    }

    public static double median(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            return numbers[0];
        }
        if (numbers.length == 2) {
            return (numbers[0] + numbers[1]) / 2.0;
        }
        for (double v : numbers) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            if (!Double.isNaN(v)) continue;
            return Double.NaN;
        }
        NumberTheory.sortAsc(numbers);
        if (numbers.length % 2 == 1) {
            int i = (numbers.length - 1) / 2;
            return numbers[i];
        }
        int i = numbers.length / 2 - 1;
        return (numbers[i] + numbers[i + 1]) / 2.0;
    }

    public static double mode(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            return numbers[0];
        }
        for (double v : numbers) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            if (!Double.isNaN(v)) continue;
            return Double.NaN;
        }
        double[][] dist = NumberTheory.getDistValues(numbers, true);
        return dist[0][0];
    }
}

