/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.api.IMuiScreen;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.UpOrDown;
import com.cleanroommc.modularui.api.widget.IGuiAction;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.overlay.ScreenWrapper;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.PanelManager;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.ModularSyncManager;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Area;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public class ModularScreen {
    private final String owner;
    private final String name;
    private final PanelManager panelManager;
    private final ModularGuiContext context = new ModularGuiContext(this);
    private final Map<Class<?>, List<IGuiAction>> guiActionListeners = new Object2ObjectOpenHashMap();
    private final Object2ObjectArrayMap<IWidget, Runnable> frameUpdates = new Object2ObjectArrayMap();
    private boolean pausesGame = false;
    private boolean openParentOnClose = false;
    private ITheme currentTheme;
    private IMuiScreen screenWrapper;
    private boolean overlay = false;

    public static boolean isScreen(@Nullable GuiScreen guiScreen, String owner, String name) {
        if (guiScreen instanceof IMuiScreen) {
            IMuiScreen screenWrapper = (IMuiScreen)guiScreen;
            ModularScreen screen = screenWrapper.getScreen();
            return screen.getOwner().equals(owner) && screen.getName().equals(name);
        }
        return false;
    }

    public static boolean isActive(String owner, String name) {
        return ModularScreen.isScreen(Minecraft.getMinecraft().currentScreen, owner, name);
    }

    @Nullable
    public static ModularScreen getCurrent() {
        GuiScreen guiScreen = MCHelper.getCurrentScreen();
        if (guiScreen instanceof IMuiScreen) {
            IMuiScreen screenWrapper = (IMuiScreen)guiScreen;
            return screenWrapper.getScreen();
        }
        return null;
    }

    public ModularScreen(@NotNull ModularPanel mainPanel) {
        this("modularui", mainPanel);
    }

    public ModularScreen(@NotNull String owner, @NotNull ModularPanel mainPanel) {
        this(owner, (ModularGuiContext context) -> mainPanel);
    }

    public ModularScreen(@NotNull String owner, @NotNull Function<ModularGuiContext, ModularPanel> mainPanelCreator) {
        this(owner, Objects.requireNonNull(mainPanelCreator, "The main panel function must not be null!"), false);
    }

    private ModularScreen(@NotNull String owner, @Nullable Function<ModularGuiContext, ModularPanel> mainPanelCreator, boolean ignored) {
        Objects.requireNonNull(owner, "The owner must not be null!");
        this.owner = owner;
        ModularPanel mainPanel = mainPanelCreator != null ? mainPanelCreator.apply(this.context) : this.buildUI(this.context);
        Objects.requireNonNull(mainPanel, "The main panel must not be null!");
        this.name = mainPanel.getName();
        this.panelManager = new PanelManager(this, mainPanel);
    }

    ModularScreen(@NotNull String owner) {
        this(owner, null, false);
    }

    ModularPanel buildUI(ModularGuiContext context) {
        throw new UnsupportedOperationException();
    }

    @MustBeInvokedByOverriders
    public void construct(IMuiScreen wrapper) {
        if (this.screenWrapper != null) {
            throw new IllegalStateException("ModularScreen is already constructed!");
        }
        if (wrapper == null) {
            throw new NullPointerException("GuiScreenWrapper must not be null!");
        }
        this.screenWrapper = wrapper;
        GuiScreen guiScreen = this.screenWrapper.getGuiScreen();
        if (guiScreen instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)guiScreen;
            ((ModularContainer)container.inventorySlots).initializeClient(this);
        }
        this.screenWrapper.updateGuiArea(this.panelManager.getMainPanel().getArea());
        this.overlay = false;
    }

    @ApiStatus.Internal
    @MustBeInvokedByOverriders
    public void constructOverlay(GuiScreen screen) {
        if (this.screenWrapper != null) {
            throw new IllegalStateException("ModularScreen is already constructed!");
        }
        if (screen == null) {
            throw new NullPointerException("GuiScreenWrapper must not be null!");
        }
        this.screenWrapper = new ScreenWrapper(screen, this);
        this.overlay = true;
    }

    @MustBeInvokedByOverriders
    public void onResize(int width, int height) {
        this.context.updateScreenArea(width, height);
        if (this.panelManager.tryInit()) {
            this.onOpen();
        }
        this.context.pushViewport(null, this.context.getScreenArea());
        for (ModularPanel panel : this.panelManager.getReverseOpenPanels()) {
            WidgetTree.resizeInternal(panel, true);
        }
        this.context.popViewport(null);
        if (!this.isOverlay()) {
            this.screenWrapper.updateGuiArea(this.panelManager.getMainPanel().getArea());
        }
    }

    @ApiStatus.OverrideOnly
    public void onOpen() {
    }

    @ApiStatus.OverrideOnly
    public void onClose() {
    }

    public void close() {
        this.close(false);
    }

    @ApiStatus.Internal
    public void close(boolean force) {
        if (this.isActive()) {
            if (force) {
                MCHelper.closeScreen();
                return;
            }
            this.getMainPanel().closeIfOpen();
        }
    }

    public boolean isPanelOpen(String name) {
        return this.panelManager.isPanelOpen(name);
    }

    public boolean isPanelOpen(ModularPanel panel) {
        return this.panelManager.hasOpenPanel(panel);
    }

    @MustBeInvokedByOverriders
    public void onUpdate() {
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            WidgetTree.onUpdate(panel);
        }
    }

    @Deprecated
    @MustBeInvokedByOverriders
    public void onFrameUpdate() {
        this.panelManager.checkDirty();
        ObjectIterator iterator = this.frameUpdates.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
            if (!((IWidget)entry.getKey()).isValid()) {
                iterator.remove();
                continue;
            }
            ((Runnable)entry.getValue()).run();
        }
        this.context.onFrameUpdate();
    }

    public void drawScreen() {
        GlStateManager.disableRescaleNormal();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        GlStateManager.disableAlpha();
        this.context.reset();
        this.context.pushViewport(null, this.context.getScreenArea());
        for (ModularPanel panel : this.panelManager.getReverseOpenPanels()) {
            this.context.updateZ(panel.getArea().getPanelLayer() * 20);
            if (panel.disablePanelsBelow()) {
                GuiDraw.drawRect(0.0f, 0.0f, this.context.getScreenArea().w(), this.context.getScreenArea().h(), Color.argb(16, 16, 16, (int)(125.0f * panel.getAlpha())));
            }
            WidgetTree.drawTree(panel, this.context);
        }
        this.context.updateZ(0);
        this.context.popViewport(null);
        this.context.postRenderCallbacks.forEach(element -> element.accept(this.context));
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableLighting();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.enableAlpha();
    }

    public void drawForeground() {
        GlStateManager.disableRescaleNormal();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        GlStateManager.disableAlpha();
        this.context.reset();
        this.context.pushViewport(null, this.context.getScreenArea());
        for (ModularPanel panel : this.panelManager.getReverseOpenPanels()) {
            this.context.updateZ(100 + panel.getArea().getPanelLayer() * 20);
            if (!panel.isEnabled()) continue;
            WidgetTree.drawTreeForeground(panel, this.context);
        }
        this.context.drawDraggable();
        this.context.popViewport(null);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableLighting();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.enableAlpha();
    }

    @ApiStatus.Internal
    public final boolean onMouseInputPre(int button, boolean pressed) {
        if (this.context.hasDraggable()) {
            if (pressed) {
                this.context.onMousePressed(button);
            } else {
                this.context.onMouseReleased(button);
            }
            return true;
        }
        return false;
    }

    public boolean onMousePressed(int mouseButton) {
        for (IGuiAction.MousePressed action : this.getGuiActionListeners(IGuiAction.MousePressed.class)) {
            action.press(mouseButton);
        }
        if (this.context.onMousePressed(mouseButton)) {
            return true;
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMousePressed(mouseButton)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onMouseRelease(int mouseButton) {
        for (IGuiAction.MouseReleased action : this.getGuiActionListeners(IGuiAction.MouseReleased.class)) {
            action.release(mouseButton);
        }
        if (this.context.onMouseReleased(mouseButton)) {
            return true;
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMouseRelease(mouseButton)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onKeyPressed(char typedChar, int keyCode) {
        for (IGuiAction.KeyPressed action : this.getGuiActionListeners(IGuiAction.KeyPressed.class)) {
            action.press(typedChar, keyCode);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onKeyPressed(typedChar, keyCode)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onKeyRelease(char typedChar, int keyCode) {
        for (IGuiAction.KeyReleased action : this.getGuiActionListeners(IGuiAction.KeyReleased.class)) {
            action.release(typedChar, keyCode);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onKeyRelease(typedChar, keyCode)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onMouseScroll(UpOrDown scrollDirection, int amount) {
        for (IGuiAction.MouseScroll action : this.getGuiActionListeners(IGuiAction.MouseScroll.class)) {
            action.scroll(scrollDirection, amount);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMouseScroll(scrollDirection, amount)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onMouseDrag(int mouseButton, long timeSinceClick) {
        for (IGuiAction.MouseDrag action : this.getGuiActionListeners(IGuiAction.MouseDrag.class)) {
            action.drag(mouseButton, timeSinceClick);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMouseDrag(mouseButton, timeSinceClick)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    @ApiStatus.Internal
    public void setFocused(boolean focus) {
        this.screenWrapper.setFocused(focus);
    }

    public boolean isActive() {
        return ModularScreen.getCurrent() == this;
    }

    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.getOwner() + ":" + this.getName();
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.owner, this.name);
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public ModularGuiContext getContext() {
        return this.context;
    }

    public PanelManager getPanelManager() {
        return this.panelManager;
    }

    public ModularSyncManager getSyncManager() {
        return this.getContainer().getSyncManager();
    }

    public ModularPanel getMainPanel() {
        return this.panelManager.getMainPanel();
    }

    public IMuiScreen getScreenWrapper() {
        return this.screenWrapper;
    }

    public Area getScreenArea() {
        return this.context.getScreenArea();
    }

    public boolean isClientOnly() {
        return this.isOverlay() || !this.screenWrapper.isGuiContainer() || this.getContainer().isClientOnly();
    }

    public ModularContainer getContainer() {
        if (this.isOverlay()) {
            throw new IllegalStateException("Can't get ModularContainer for overlay");
        }
        GuiScreen guiScreen = this.screenWrapper.getGuiScreen();
        if (guiScreen instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)guiScreen;
            return (ModularContainer)container.inventorySlots;
        }
        throw new IllegalStateException("Screen does not extend GuiContainer!");
    }

    public boolean doesPauseGame() {
        return this.pausesGame;
    }

    public boolean isOpenParentOnClose() {
        return this.openParentOnClose;
    }

    private <T extends IGuiAction> List<T> getGuiActionListeners(Class<T> clazz) {
        return this.guiActionListeners.getOrDefault(clazz, Collections.emptyList());
    }

    public void registerGuiActionListener(IGuiAction action) {
        List list = this.guiActionListeners.computeIfAbsent(ModularScreen.getGuiActionClass(action), key -> new ArrayList());
        if (!list.contains(action)) {
            list.add(action);
        }
    }

    public void removeGuiActionListener(IGuiAction action) {
        this.guiActionListeners.getOrDefault(ModularScreen.getGuiActionClass(action), Collections.emptyList()).remove(action);
    }

    public void registerFrameUpdateListener(IWidget widget, Runnable runnable) {
        this.registerFrameUpdateListener(widget, runnable, true);
    }

    public void registerFrameUpdateListener(IWidget widget, Runnable runnable, boolean merge) {
        Objects.requireNonNull(runnable);
        if (merge) {
            this.frameUpdates.merge((Object)widget, (Object)runnable, (old, now) -> () -> {
                old.run();
                now.run();
            });
        } else {
            this.frameUpdates.put((Object)widget, (Object)runnable);
        }
    }

    public void removeFrameUpdateListener(IWidget widget) {
        this.frameUpdates.remove((Object)widget);
    }

    private static Class<?> getGuiActionClass(IGuiAction action) {
        Class<?>[] classes;
        for (Class<?> clazz : classes = action.getClass().getInterfaces()) {
            if (!IGuiAction.class.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        throw new IllegalArgumentException();
    }

    public ITheme getCurrentTheme() {
        if (this.currentTheme == null) {
            this.useTheme(null);
        }
        return this.currentTheme;
    }

    public ModularScreen useTheme(String theme) {
        this.currentTheme = IThemeApi.get().getThemeForScreen(this, theme);
        return this;
    }

    public ModularScreen pausesGame(boolean pausesGame) {
        this.pausesGame = pausesGame;
        return this;
    }

    public ModularScreen openParentOnClose(boolean openParentOnClose) {
        this.openParentOnClose = openParentOnClose;
        return this;
    }
}

