/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import java.util.Iterator;
import java.util.function.BiPredicate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PosListSchema
implements ISchema {
    private final World world;
    private final Iterable<? extends BlockPos> posList;
    private BiPredicate<BlockPos, BlockInfo> renderFilter;

    public PosListSchema(World world, Iterable<? extends BlockPos> posList, BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.world = world;
        this.posList = posList;
        this.renderFilter = renderFilter;
    }

    @Override
    public void setRenderFilter(@Nullable BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.renderFilter = renderFilter;
    }

    @Override
    @Nullable
    public BiPredicate<BlockPos, BlockInfo> getRenderFilter() {
        return this.renderFilter;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public Iterator<Pair<BlockPos, BlockInfo>> iterator() {
        return new Iterator<Pair<BlockPos, BlockInfo>>(){
            private final Iterator<? extends BlockPos> posIt;
            private final MutablePair<BlockPos, BlockInfo> pair;
            {
                this.posIt = PosListSchema.this.posList.iterator();
                this.pair = new MutablePair();
            }

            @Override
            public boolean hasNext() {
                return this.posIt.hasNext();
            }

            @Override
            public Pair<BlockPos, BlockInfo> next() {
                BlockPos pos = this.posIt.next();
                this.pair.setLeft((Object)pos);
                BlockInfo.Mut.SHARED.set((IBlockAccess)PosListSchema.this.world, pos);
                if (PosListSchema.this.renderFilter == null || PosListSchema.this.renderFilter.test(pos, BlockInfo.Mut.SHARED)) {
                    this.pair.setRight((Object)BlockInfo.Mut.SHARED);
                } else {
                    this.pair.setRight((Object)BlockInfo.EMPTY);
                }
                return this.pair;
            }
        };
    }
}

