/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.bogosorter.api.ISortingContextBuilder;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.value.sync.CursorSlotSyncHandler;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.ApiStatus;

public class ModularSyncManager {
    public static final String AUTO_SYNC_PREFIX = "auto_sync:";
    protected static final String PLAYER_INVENTORY = "player_inventory";
    private static final String CURSOR_KEY = ModularSyncManager.makeSyncKey("cursor_slot", 255255);
    private final Map<String, PanelSyncManager> panelSyncManagerMap = new Object2ObjectOpenHashMap();
    private final Set<String> panelHistory = new ObjectOpenHashSet();
    private PanelSyncManager mainPSM;
    private final ModularContainer container;
    private final CursorSlotSyncHandler cursorSlotSyncHandler = new CursorSlotSyncHandler();

    public ModularSyncManager(ModularContainer container) {
        this.container = container;
    }

    @ApiStatus.Internal
    public void construct(String mainPanelName, PanelSyncManager mainPSM) {
        this.mainPSM = mainPSM;
        if (this.mainPSM.getSlotGroup(PLAYER_INVENTORY) == null) {
            this.mainPSM.bindPlayerInventory(this.getPlayer());
        }
        mainPSM.syncValue(CURSOR_KEY, (SyncHandler)this.cursorSlotSyncHandler);
        this.open(mainPanelName, mainPSM);
    }

    public PanelSyncManager getMainPSM() {
        return this.mainPSM;
    }

    public void detectAndSendChanges(boolean init) {
        this.panelSyncManagerMap.values().forEach(psm -> psm.detectAndSendChanges(init));
    }

    public void onClose() {
        this.panelSyncManagerMap.values().forEach(PanelSyncManager::onClose);
    }

    public void onOpen() {
        this.panelSyncManagerMap.values().forEach(PanelSyncManager::onOpen);
    }

    public void onUpdate() {
        this.panelSyncManagerMap.values().forEach(PanelSyncManager::onUpdate);
    }

    public PanelSyncManager getPanelSyncManager(String panelName) {
        PanelSyncManager psm = this.panelSyncManagerMap.get(panelName);
        if (psm != null) {
            return psm;
        }
        throw new NullPointerException("No PanelSyncManager found for name '" + panelName + "'!");
    }

    public SyncHandler getSyncHandler(String panelName, String syncKey) {
        return this.getPanelSyncManager(panelName).getSyncHandler(syncKey);
    }

    public SlotGroup getSlotGroup(String panelName, String slotGroupName) {
        return this.getPanelSyncManager(panelName).getSlotGroup(slotGroupName);
    }

    public ItemStack getCursorItem() {
        return this.getPlayer().inventory.getItemStack();
    }

    public void setCursorItem(ItemStack item) {
        this.getPlayer().inventory.setItemStack(item);
        this.cursorSlotSyncHandler.sync();
    }

    public void open(String name, PanelSyncManager syncManager) {
        this.panelSyncManagerMap.put(name, syncManager);
        this.panelHistory.add(name);
        syncManager.initialize(name, this);
    }

    public void close(String name) {
        PanelSyncManager psm = this.panelSyncManagerMap.remove(name);
        if (psm != null) {
            psm.onClose();
        }
    }

    public boolean isOpen(String panelName) {
        return this.panelSyncManagerMap.containsKey(panelName);
    }

    public void receiveWidgetUpdate(String panelName, String mapKey, boolean action, int id, PacketBuffer buf) throws IOException {
        PanelSyncManager psm = this.panelSyncManagerMap.get(panelName);
        if (psm != null) {
            psm.receiveWidgetUpdate(mapKey, action, id, buf);
        } else if (!this.panelHistory.contains(panelName)) {
            ModularUI.LOGGER.throwing((Throwable)new IllegalStateException("A packet was send to panel '" + panelName + "' which was not opened yet!."));
        }
    }

    public EntityPlayer getPlayer() {
        return this.container.getPlayer();
    }

    public ModularContainer getContainer() {
        return this.container;
    }

    public boolean isClient() {
        return this.container.isClient();
    }

    @Optional.Method(modid="bogosorter")
    public void buildSortingContext(ISortingContextBuilder builder) {
        for (PanelSyncManager psm : this.panelSyncManagerMap.values()) {
            for (SlotGroup slotGroup : psm.getSlotGroups()) {
                if (!slotGroup.isAllowSorting() || ModularSyncManager.isPlayerSlot(slotGroup.getSlots().get(0))) continue;
                builder.addSlotGroupOf(slotGroup.getSlots(), slotGroup.getRowSize()).buttonPosSetter(null).priority(slotGroup.getShiftClickPriority());
            }
        }
    }

    private static boolean isPlayerSlot(Slot slot) {
        SlotItemHandler slotItemHandler;
        IItemHandler iItemHandler;
        if (slot == null) {
            return false;
        }
        if (slot.inventory instanceof InventoryPlayer) {
            return slot.getSlotIndex() >= 0 && slot.getSlotIndex() < 36;
        }
        if (slot instanceof SlotItemHandler && ((iItemHandler = (slotItemHandler = (SlotItemHandler)slot).getItemHandler()) instanceof PlayerMainInvWrapper || iItemHandler instanceof PlayerInvWrapper)) {
            return slot.getSlotIndex() >= 0 && slot.getSlotIndex() < 36;
        }
        return false;
    }

    public static String makeSyncKey(String name, int id) {
        return name + ":" + id;
    }
}

