/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.ItemSlotSH;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;

public class PhantomItemSlotSH
extends ItemSlotSH {
    public static final int SYNC_CLICK = 100;
    public static final int SYNC_SCROLL = 101;
    public static final int SYNC_ITEM_SIMPLE = 102;
    private ItemStack lastStoredPhantomItem = ItemStack.EMPTY;

    @ApiStatus.Internal
    public PhantomItemSlotSH(ModularSlot slot) {
        super(slot);
    }

    @Override
    public void init(String key, PanelSyncManager syncHandler) {
        super.init(key, syncHandler);
        if (this.isPhantom() && !this.getSlot().getStack().isEmpty()) {
            this.lastStoredPhantomItem = this.getSlot().getStack().copy();
            this.lastStoredPhantomItem.setCount(1);
        }
    }

    @Override
    protected void onSlotUpdate(ItemStack stack, boolean onlyAmountChanged, boolean client, boolean init) {
        this.getSlot().putStack(stack);
        if (!onlyAmountChanged && !stack.isEmpty()) {
            this.lastStoredPhantomItem = stack.copy();
            this.lastStoredPhantomItem.setCount(1);
        }
        super.onSlotUpdate(stack, onlyAmountChanged, client, init);
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        super.readOnServer(id, buf);
        if (id == 100) {
            this.phantomClick(MouseData.readPacket(buf));
        } else if (id == 101) {
            this.phantomScroll(MouseData.readPacket(buf));
        } else if (id == 102) {
            if (!this.isPhantom()) {
                return;
            }
            this.phantomClick(new MouseData(Side.SERVER, 0, false, false, false), buf.readItemStack());
        }
    }

    public void updateFromClient(ItemStack stack) {
        this.syncToServer(102, buf -> buf.writeItemStack(stack));
    }

    protected void phantomClick(MouseData mouseData) {
        this.phantomClick(mouseData, this.getSyncManager().getCursorItem());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void phantomClick(MouseData mouseData, ItemStack cursorStack) {
        ItemStack slotStack = this.getSlot().getStack();
        if (!(cursorStack.isEmpty() || slotStack.isEmpty() || ItemHandlerHelper.canItemStacksStack((ItemStack)cursorStack, (ItemStack)slotStack))) {
            if (!this.isItemValid(cursorStack)) {
                return;
            }
            ItemStack stackToPut = cursorStack.copy();
            if (mouseData.mouseButton == 1) {
                stackToPut.setCount(1);
            }
            stackToPut.setCount(Math.min(stackToPut.getCount(), this.getSlot().getItemStackLimit(stackToPut)));
            this.getSlot().putStack(stackToPut);
            this.lastStoredPhantomItem = stackToPut.copy();
            return;
        } else if (slotStack.isEmpty()) {
            ItemStack stackToPut;
            if (cursorStack.isEmpty()) {
                if (mouseData.mouseButton != 1 || this.lastStoredPhantomItem.isEmpty()) return;
                stackToPut = this.lastStoredPhantomItem.copy();
            } else {
                if (!this.isItemValid(cursorStack)) {
                    return;
                }
                stackToPut = cursorStack.copy();
            }
            if (mouseData.mouseButton == 1) {
                stackToPut.setCount(1);
            }
            stackToPut.setCount(Math.min(stackToPut.getCount(), this.getSlot().getItemStackLimit(stackToPut)));
            this.getSlot().putStack(stackToPut);
            this.lastStoredPhantomItem = stackToPut.copy();
            return;
        } else if (mouseData.mouseButton == 0) {
            if (mouseData.shift) {
                this.getSlot().putStack(ItemStack.EMPTY);
                return;
            } else {
                this.incrementStackCount(-1);
            }
            return;
        } else {
            if (mouseData.mouseButton != 1) return;
            this.incrementStackCount(1);
        }
    }

    protected void phantomScroll(MouseData mouseData) {
        ItemStack currentItem = this.getSlot().getStack();
        int amount = mouseData.mouseButton;
        if (mouseData.shift) {
            amount *= 4;
        }
        if (mouseData.ctrl) {
            amount *= 16;
        }
        if (mouseData.alt) {
            amount *= 64;
        }
        if (amount > 0 && currentItem.isEmpty() && !this.lastStoredPhantomItem.isEmpty()) {
            ItemStack stackToPut = this.lastStoredPhantomItem.copy();
            stackToPut.setCount(amount);
            this.getSlot().putStack(stackToPut);
        } else {
            this.incrementStackCount(amount);
        }
    }

    public void incrementStackCount(int amount) {
        ItemStack stack = this.getSlot().getStack();
        if (stack.isEmpty()) {
            return;
        }
        int oldAmount = stack.getCount();
        if (amount < 0) {
            amount = Math.max(0, oldAmount + amount);
        } else if (Integer.MAX_VALUE - amount < oldAmount) {
            amount = Integer.MAX_VALUE;
        } else {
            int maxSize = this.getSlot().getSlotStackLimit();
            if (!this.getSlot().isIgnoreMaxStackSize() && stack.getMaxStackSize() < maxSize) {
                maxSize = stack.getMaxStackSize();
            }
            amount = Math.min(oldAmount + amount, maxSize);
        }
        if (oldAmount != amount) {
            stack = stack.copy();
            stack.setCount(amount);
            this.getSlot().putStack(stack);
        }
    }

    @Override
    public boolean isPhantom() {
        return true;
    }
}

