/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.AbstractParentWidget;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widgets.ListWidget;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CategoryList
extends AbstractParentWidget<IWidget, CategoryList>
implements Interactable,
ILayoutWidget {
    private final List<CategoryList> subCategories = new ArrayList<CategoryList>();
    private boolean expanded = false;
    private int totalHeight = 0;
    private IDrawable expandedOverlay;
    private IDrawable collapsedOverlay;

    @Override
    public void drawOverlay(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        super.drawOverlay(context, widgetTheme);
        if (this.expanded) {
            this.expandedOverlay.drawAtZero(context, this.getArea(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        } else {
            this.collapsedOverlay.drawAtZero(context, this.getArea(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }
    }

    @Override
    public void onInit() {
        Root root;
        CategoryList categoryList;
        IWidget iWidget;
        super.onInit();
        if (this.expandedOverlay == null) {
            iWidget = this.getParent();
            if (iWidget instanceof CategoryList) {
                categoryList = (CategoryList)iWidget;
                this.expandedOverlay = categoryList.expandedOverlay;
            } else {
                iWidget = this.getParent();
                if (iWidget instanceof Root) {
                    root = (Root)iWidget;
                    this.expandedOverlay = root.expandedOverlay;
                } else {
                    this.expandedOverlay = IDrawable.EMPTY;
                }
            }
        }
        if (this.collapsedOverlay == null) {
            iWidget = this.getParent();
            if (iWidget instanceof CategoryList) {
                categoryList = (CategoryList)iWidget;
                this.collapsedOverlay = categoryList.collapsedOverlay;
            } else {
                iWidget = this.getParent();
                if (iWidget instanceof Root) {
                    root = (Root)iWidget;
                    this.collapsedOverlay = root.collapsedOverlay;
                } else {
                    this.collapsedOverlay = IDrawable.EMPTY;
                }
            }
        }
    }

    @Override
    public void onChildAdd(IWidget child) {
        if (child instanceof CategoryList) {
            CategoryList categoryList = (CategoryList)child;
            this.subCategories.add(categoryList);
        }
        child.setEnabled(this.expanded);
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        if (mouseButton == 0 || mouseButton == 1) {
            this.expanded(!this.expanded);
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.ACCEPT;
    }

    public void expanded(boolean expanded) {
        if (expanded == this.expanded) {
            return;
        }
        this.expanded = expanded;
        for (IWidget widget : this.getChildren()) {
            widget.setEnabled(expanded);
        }
        this.calculateHeightAndLayout(true);
    }

    /*
     * Unable to fully structure code
     */
    public void calculateHeightAndLayout(boolean calculateParents) {
        block8: {
            block7: {
                if (!this.expanded) break block7;
                y = this.getArea().height;
                for (IWidget widget : this.getChildren()) {
                    widget.getArea().ry = y;
                    widget.resizer().setYResized(true);
                    if (!(widget instanceof CategoryList)) ** GOTO lbl-1000
                    categoryList = (CategoryList)widget;
                    if (categoryList.expanded) {
                        v0 = categoryList.totalHeight;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = widget.getArea().height;
                    }
                    y += v0;
                }
                this.totalHeight = y;
                break block8;
            }
            this.totalHeight = this.getArea().height;
        }
        if (!calculateParents) {
            return;
        }
        var4_5 = this.getParent();
        if (var4_5 instanceof CategoryList) {
            categoryList = (CategoryList)var4_5;
            categoryList.calculateHeightAndLayout(true);
        } else {
            var4_5 = this.getParent();
            if (var4_5 instanceof Root) {
                root = (Root)var4_5;
                Root.access$200(root);
            }
        }
    }

    @Override
    public void layoutWidgets() {
        this.calculateHeightAndLayout(false);
    }

    public CategoryList setCollapsedOverlay(IDrawable collapsedOverlay) {
        this.collapsedOverlay = collapsedOverlay;
        return this;
    }

    public CategoryList setExpandedOverlay(IDrawable expandedOverlay) {
        this.expandedOverlay = expandedOverlay;
        return this;
    }

    public static class Root
    extends ListWidget<IWidget, Root> {
        private final List<CategoryList> categories = new ArrayList<CategoryList>();
        private IDrawable expandedOverlay = GuiTextures.MOVE_DOWN.asIcon().size(16, 8).alignment(Alignment.CenterRight).marginRight(4);
        private IDrawable collapsedOverlay = GuiTextures.MOVE_RIGHT.asIcon().size(8, 16).alignment(Alignment.CenterRight).marginRight(8);

        @Override
        public void onChildAdd(IWidget child) {
            if (child instanceof CategoryList) {
                CategoryList categoryList = (CategoryList)child;
                this.categories.add(categoryList);
            }
        }

        private void updateHeight() {
            this.layoutWidgets();
            WidgetTree.applyPos(this);
        }

        @Override
        public void layoutWidgets() {
            int y = 0;
            for (IWidget widget : this.getChildren()) {
                CategoryList categoryList;
                widget.getArea().ry = y;
                widget.resizer().setYResized(true);
                y += widget instanceof CategoryList && (categoryList = (CategoryList)widget).expanded ? categoryList.totalHeight : widget.getArea().height;
            }
            this.getScrollArea().getScrollY().setScrollSize(y);
        }

        public Root setCollapsedOverlay(IDrawable collapsedOverlay) {
            this.collapsedOverlay = collapsedOverlay;
            return this;
        }

        public Root setExpandedOverlay(IDrawable expandedOverlay) {
            this.expandedOverlay = expandedOverlay;
            return this;
        }

        static /* synthetic */ void access$200(Root x0) {
            x0.updateHeight();
        }
    }
}

