/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api;

import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiContainerAccessor;
import com.cleanroommc.modularui.screen.ClientScreenHandler;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.neverenoughanimations.api.IAnimatedScreen;
import java.awt.Rectangle;
import java.util.function.IntConsumer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Optional.Interface(modid="neverenoughanimations", iface="com.cleanroommc.neverenoughanimations.api.IAnimatedScreen")
@SideOnly(value=Side.CLIENT)
public interface IMuiScreen
extends IAnimatedScreen {
    @NotNull
    public ModularScreen getScreen();

    default public void setFocused(boolean focused) {
        this.getGuiScreen().func_193975_a(focused);
    }

    @ApiStatus.NonExtendable
    default public void handleDrawBackground(int tint, IntConsumer drawFunction) {
        if (ClientScreenHandler.shouldDrawWorldBackground()) {
            drawFunction.accept(tint);
        }
        ClientScreenHandler.drawDarkBackground(this.getGuiScreen(), tint);
        Platform.setupDrawTex();
    }

    default public void updateGuiArea(Rectangle area) {
        GuiScreen guiScreen = this.getGuiScreen();
        if (guiScreen instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)guiScreen;
            ClientScreenHandler.updateGuiArea(container, area);
        }
    }

    @ApiStatus.NonExtendable
    default public boolean isGuiContainer() {
        return this.getGuiScreen() instanceof GuiContainer;
    }

    @ApiStatus.NonExtendable
    default public void setHoveredSlot(Slot slot) {
        GuiScreen guiScreen = this.getGuiScreen();
        if (guiScreen instanceof GuiContainerAccessor) {
            GuiContainerAccessor acc = (GuiContainerAccessor)guiScreen;
            acc.setHoveredSlot(slot);
        }
    }

    default public GuiScreen getGuiScreen() {
        return (GuiScreen)this;
    }

    default public int nea$getX() {
        return this.getScreen().getMainPanel().getArea().x;
    }

    default public int nea$getY() {
        return this.getScreen().getMainPanel().getArea().y;
    }

    default public int nea$getWidth() {
        return this.getScreen().getMainPanel().getArea().width;
    }

    default public int nea$getHeight() {
        return this.getScreen().getMainPanel().getArea().height;
    }
}

