/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.drawable;

import com.cleanroommc.modularui.drawable.DrawableStack;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.sizer.Area;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public interface IDrawable {
    public static final IDrawable EMPTY = (context, x, y, width, height, widgetTheme) -> {};
    public static final IDrawable NONE = (context, x, y, width, height, widgetTheme) -> {};

    public static IDrawable of(IDrawable ... drawables) {
        if (drawables == null || drawables.length == 0) {
            return null;
        }
        if (drawables.length == 1) {
            return drawables[0];
        }
        return new DrawableStack(drawables);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContext var1, int var2, int var3, int var4, int var5, WidgetTheme var6);

    @SideOnly(value=Side.CLIENT)
    default public void drawAtZero(GuiContext context, int width, int height, WidgetTheme widgetTheme) {
        this.draw(context, 0, 0, width, height, widgetTheme);
    }

    @SideOnly(value=Side.CLIENT)
    default public void draw(GuiContext context, Area area, WidgetTheme widgetTheme) {
        this.draw(context, area.x + area.getPadding().getLeft(), area.y + area.getPadding().getTop(), area.paddedWidth(), area.paddedHeight(), widgetTheme);
    }

    @SideOnly(value=Side.CLIENT)
    default public void drawAtZero(GuiContext context, Area area, WidgetTheme widgetTheme) {
        this.draw(context, 0, 0, area.paddedWidth(), area.paddedHeight(), widgetTheme);
    }

    default public boolean canApplyTheme() {
        return false;
    }

    default public void applyColor(int themeColor) {
        if (this.canApplyTheme()) {
            Color.setGlColor(themeColor);
        } else {
            Color.setGlColorOpaque(Color.WHITE.main);
        }
    }

    default public Widget<?> asWidget() {
        return new DrawableWidget(this);
    }

    default public Icon asIcon() {
        return new Icon(this);
    }

    public static boolean isVisible(@Nullable IDrawable drawable) {
        if (drawable == null || drawable == EMPTY || drawable == NONE) {
            return false;
        }
        if (drawable instanceof DrawableStack) {
            DrawableStack array = (DrawableStack)drawable;
            return array.getDrawables().length > 0;
        }
        return true;
    }

    public static class DrawableWidget
    extends Widget<DrawableWidget> {
        private final IDrawable drawable;

        public DrawableWidget(IDrawable drawable) {
            this.drawable = drawable;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
            this.drawable.drawAtZero(context, this.getArea(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }
    }
}

