/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.integration.jei;

import com.cleanroommc.modularui.api.IMuiScreen;
import com.cleanroommc.modularui.widget.sizer.Area;
import java.util.Objects;
import mezz.jei.api.gui.IGuiProperties;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;

public class ModularUIProperties
implements IGuiProperties {
    private final Class<? extends GuiScreen> guiClass;
    private final int guiLeft;
    private final int guiTop;
    private final int guiXSize;
    private final int guiYSize;
    private final int screenWidth;
    private final int screenHeight;

    public ModularUIProperties(IMuiScreen screen) {
        Area mainArea = screen.getScreen().getMainPanel().getArea();
        Area screenArea = screen.getScreen().getScreenArea();
        this.guiClass = screen.getGuiScreen().getClass();
        this.guiLeft = mainArea.x;
        this.guiTop = mainArea.y;
        this.guiXSize = mainArea.width;
        this.guiYSize = mainArea.height;
        this.screenWidth = screenArea.width;
        this.screenHeight = screenArea.height;
    }

    @NotNull
    public Class<? extends GuiScreen> getGuiClass() {
        return this.guiClass;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getGuiXSize() {
        return this.guiXSize;
    }

    public int getGuiYSize() {
        return this.guiYSize;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("x", this.getGuiLeft()).append("y", this.getGuiTop()).append("width", this.getGuiXSize()).append("height", this.getGuiYSize()).append("screenWidth", this.getScreenWidth()).append("screenHeight", this.getScreenHeight()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModularUIProperties that = (ModularUIProperties)o;
        return this.guiLeft == that.guiLeft && this.guiTop == that.guiTop && this.guiXSize == that.guiXSize && this.guiYSize == that.guiYSize && this.screenWidth == that.screenWidth && this.screenHeight == that.screenHeight && Objects.equals(this.guiClass, that.guiClass);
    }

    public int hashCode() {
        return Objects.hash(this.guiClass, this.guiLeft, this.guiTop, this.guiXSize, this.guiYSize, this.screenWidth, this.screenHeight);
    }
}

