/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.api.IPacketWriter;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.WidgetTree;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DynamicSyncHandler
extends SyncHandler {
    private IWidgetProvider widgetProvider;
    private Consumer<IWidget> onWidgetUpdate;

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            this.updateWidgets(buf);
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            this.updateWidgets(buf);
        }
    }

    private void updateWidgets(PacketBuffer buf) {
        this.getSyncManager().allowTemporarySyncHandlerRegistration(true);
        IWidget widget = this.widgetProvider.createWidget(this.getSyncManager(), buf);
        this.getSyncManager().allowTemporarySyncHandlerRegistration(false);
        WidgetTree.collectSyncValues(this.getSyncManager(), this.getSyncManager().getPanelName(), widget, true);
        if (widget != null && this.widgetProvider != null) {
            this.onWidgetUpdate.accept(widget);
        }
    }

    public void notifyUpdate(IPacketWriter packetWriter) {
        this.updateWidgets(packetWriter.toPacket());
        this.sync(0, packetWriter);
    }

    public DynamicSyncHandler widgetProvider(IWidgetProvider widgetProvider) {
        this.widgetProvider = widgetProvider;
        return this;
    }

    @ApiStatus.Internal
    public DynamicSyncHandler onWidgetUpdate(Consumer<IWidget> onWidgetUpdate) {
        this.onWidgetUpdate = onWidgetUpdate;
        return this;
    }

    public static interface IWidgetProvider {
        @Nullable
        public IWidget createWidget(PanelSyncManager var1, PacketBuffer var2);
    }
}

