/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;

public final class MathConstants {
    public static final double PI = Math.PI;
    public static final double PIBY2 = 1.5707963267948966;
    public static final double PIINV = 0.3183098861837907;
    public static final double E = Math.E;
    public static final double EULER_MASCHERONI = 0.5772156649015329;
    public static final double GOLDEN_RATIO = 1.618033988749895;
    public static final double PLASTIC = 1.324717957244746;
    public static final double EMBREE_TREFETHEN = 0.70258;
    public static final double FEIGENBAUM_DELTA = 4.66920160910299;
    public static final double FEIGENBAUM_ALFA = 2.5029078750958926;
    public static final double TWIN_PRIME = 0.6601618158468696;
    public static final double MEISSEL_MERTEENS = 0.26149721284764277;
    public static final double BRAUN_TWIN_PRIME = 1.902160583104;
    public static final double BRAUN_PRIME_QUADR = 0.87058838;
    public static final double BRUIJN_NEWMAN = -2.7E-9;
    public static final double CATALAN = 0.915965594177219;
    public static final double LANDAU_RAMANUJAN = 0.7642236535892206;
    public static final double VISWANATH = 1.13198824;
    public static final double LEGENDRE = 1.0;
    public static final double RAMANUJAN_SOLDNER = 1.451369234883381;
    public static final double ERDOS_BORWEIN = 1.6066951524152917;
    public static final double BERNSTEIN = 0.2801694990238691;
    public static final double GAUSS_KUZMIN_WIRSING = 0.30366300289873266;
    public static final double HAFNER_SARNAK_MCCURLEY = 0.353236371854996;
    public static final double GOLOMB_DICKMAN = 0.6243299885435508;
    public static final double CAHEN = 0.6434105463;
    public static final double LAPLACE_LIMIT = 0.6627434193491816;
    public static final double ALLADI_GRINSTEAD = 0.8093940205;
    public static final double LENGYEL = 1.0986858055;
    public static final double LEVY = 3.2758229187218113;
    public static final double APERY = 1.2020569031595942;
    public static final double MILLS = 1.3063778838630806;
    public static final double BACKHOUSE = 1.4560749485826896;
    public static final double PORTER = 1.4670780794;
    public static final double LIEB_QUARE_ICE = 1.5396007178;
    public static final double NIVEN = 1.7052111401053678;
    public static final double SIERPINSKI = 2.5849817595792532;
    public static final double KHINCHIN = 2.6854520010653062;
    public static final double FRANSEN_ROBINSON = 2.8077702420285195;
    public static final double LANDAU = 0.5432589653429767;
    public static final double PARABOLIC = 2.295587149392638;
    public static final double OMEGA = 0.5671432904097838;
    public static final double MRB = 0.18785964246206713;
    public static final double LI2 = 1.045163780117493;
    public static final double GOMPERTZ = 0.5963473623231941;
    public static final double SQRT2 = Math.sqrt(2.0);
    public static final double SQRTPi = 1.772453850905516;
    public static final double SQRT2Pi = 2.5066282746310007;
    public static final double LNPI = MathFunctions.ln(Math.PI);
    public static final double EXP_MINUS_E = Math.pow(Math.E, -2.718281828459045);
    public static final double EXP_1_OVER_E = Math.pow(Math.E, 0.36787944117144233);
    public static final double EXP_MINUS_1 = 0.36787944117144233;
    public static final double LN_SQRT2 = MathFunctions.ln(SQRT2);
    public static final double SQRT2BY2 = SQRT2 / 2.0;
    public static final double SQRT3 = Math.sqrt(3.0);
    public static final double SQRT3BY2 = SQRT3 / 2.0;
    public static final double D2BYSQRT3 = 2.0 / SQRT3;
    public static final double SQRT3BY3 = SQRT3 / 3.0;
    public static final double SQRT5 = Math.sqrt(5.0);
    public static final double NOT_A_NUMBER = Double.NaN;

    public static double getConstantValue(int constantValueId) {
        switch (constantValueId) {
            case 1: {
                return Math.PI;
            }
            case 2: {
                return Math.E;
            }
            case 3: {
                return 0.5772156649015329;
            }
            case 4: {
                return 1.618033988749895;
            }
            case 5: {
                return 1.324717957244746;
            }
            case 6: {
                return 0.70258;
            }
            case 7: {
                return 4.66920160910299;
            }
            case 8: {
                return 2.5029078750958926;
            }
            case 9: {
                return 0.6601618158468696;
            }
            case 10: {
                return 0.26149721284764277;
            }
            case 11: {
                return 1.902160583104;
            }
            case 12: {
                return 0.87058838;
            }
            case 13: {
                return -2.7E-9;
            }
            case 14: {
                return 0.915965594177219;
            }
            case 15: {
                return 0.7642236535892206;
            }
            case 16: {
                return 1.13198824;
            }
            case 17: {
                return 1.0;
            }
            case 18: {
                return 1.451369234883381;
            }
            case 19: {
                return 1.6066951524152917;
            }
            case 20: {
                return 0.2801694990238691;
            }
            case 21: {
                return 0.30366300289873266;
            }
            case 22: {
                return 0.353236371854996;
            }
            case 23: {
                return 0.6243299885435508;
            }
            case 24: {
                return 0.6434105463;
            }
            case 25: {
                return 0.6627434193491816;
            }
            case 26: {
                return 0.8093940205;
            }
            case 27: {
                return 1.0986858055;
            }
            case 28: {
                return 3.2758229187218113;
            }
            case 29: {
                return 1.2020569031595942;
            }
            case 30: {
                return 1.3063778838630806;
            }
            case 31: {
                return 1.4560749485826896;
            }
            case 32: {
                return 1.4670780794;
            }
            case 33: {
                return 1.5396007178;
            }
            case 34: {
                return 1.7052111401053678;
            }
            case 35: {
                return 2.5849817595792532;
            }
            case 36: {
                return 2.6854520010653062;
            }
            case 37: {
                return 2.8077702420285195;
            }
            case 38: {
                return 0.5432589653429767;
            }
            case 39: {
                return 2.295587149392638;
            }
            case 40: {
                return 0.5671432904097838;
            }
            case 41: {
                return 0.18785964246206713;
            }
            case 42: {
                return 1.045163780117493;
            }
            case 43: {
                return 0.5963473623231941;
            }
            case 101: {
                return 2.99792458E8;
            }
            case 102: {
                return 6.67408E-11;
            }
            case 103: {
                return 9.80665;
            }
            case 104: {
                return 6.62607004E-34;
            }
            case 105: {
                return 1.0545718001391127E-34;
            }
            case 106: {
                return 1.616229E-35;
            }
            case 107: {
                return 2.17647E-8;
            }
            case 108: {
                return 5.39116E-44;
            }
            case 201: {
                return 9.4607304725808E15;
            }
            case 202: {
                return 1.495978707E11;
            }
            case 203: {
                return 3.085677581491362E16;
            }
            case 204: {
                return 3.085677581491362E19;
            }
            case 205: {
                return 6378137.0;
            }
            case 206: {
                return 6356752.3;
            }
            case 207: {
                return 6371008.8;
            }
            case 208: {
                return 5.9722E24;
            }
            case 209: {
                return 1.495980229906324E11;
            }
            case 210: {
                return 1737100.0;
            }
            case 211: {
                return 7.34582809714E22;
            }
            case 212: {
                return 3.84399E8;
            }
            case 213: {
                return 6.957E8;
            }
            case 214: {
                return 1.98842039204614E30;
            }
            case 215: {
                return 2439700.0;
            }
            case 216: {
                return 3.3026266E23;
            }
            case 217: {
                return 5.79090365522286E10;
            }
            case 218: {
                return 6051800.0;
            }
            case 219: {
                return 4.867343E24;
            }
            case 220: {
                return 1.082089270091724E11;
            }
            case 221: {
                return 3389500.0;
            }
            case 222: {
                return 6.390254E23;
            }
            case 223: {
                return 2.279391340303053E11;
            }
            case 224: {
                return 6.9911E7;
            }
            case 225: {
                return 1.8979651600000002E27;
            }
            case 226: {
                return 7.782978821038201E11;
            }
            case 227: {
                return 5.8232E7;
            }
            case 228: {
                return 5.6830857980000005E26;
            }
            case 229: {
                return 1.42939269475143E12;
            }
            case 230: {
                return 2.5362E7;
            }
            case 231: {
                return 8.681189920000001E25;
            }
            case 232: {
                return 2.87503171826088E12;
            }
            case 233: {
                return 2.4622E7;
            }
            case 234: {
                return 1.024053134E26;
            }
            case 235: {
                return 4.504449781152961E12;
            }
            case 301: {
                return 1.0;
            }
            case 302: {
                return 0.0;
            }
            case 999: {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }
}

