/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.animation;

import com.cleanroommc.modularui.animation.AnimatorManager;
import com.cleanroommc.modularui.animation.IAnimator;
import com.cleanroommc.modularui.animation.ParallelAnimator;
import com.cleanroommc.modularui.animation.SequentialAnimator;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAnimator<A extends BaseAnimator<A>>
implements IAnimator {
    private IAnimator parent;
    protected boolean reverseOnFinish = false;
    protected int repeats = 0;
    private byte direction = 0;
    private boolean paused = false;
    private boolean startedReverse = false;
    private int repeated = 0;

    void setParent(IAnimator parent) {
        this.parent = parent;
    }

    public A getThis() {
        return (A)this;
    }

    @Override
    @Nullable
    public final IAnimator getParent() {
        return this.parent;
    }

    @Override
    public void reset(boolean atEnd) {
        this.startedReverse = atEnd;
        this.repeated = 0;
    }

    @Override
    public boolean stop(boolean force) {
        if (this.isAnimating() && !force) {
            if (this.reverseOnFinish && this.startedReverse == this.isAnimatingReverse()) {
                this.onAnimationFinished(false, false);
                this.animate(this.isAnimatingForward());
                return false;
            }
            if (this.repeats != 0 && (this.repeated < this.repeats || this.repeats < 0)) {
                this.onAnimationFinished(true, false);
                boolean reverse = !this.reverseOnFinish == this.isAnimatingReverse();
                this.animate(reverse);
                ++this.repeated;
                return false;
            }
        }
        this.direction = 0;
        return true;
    }

    protected void onAnimationFinished(boolean finishedOneCycle, boolean finishedAllRepeats) {
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume(boolean reverse) {
        this.paused = false;
        this.direction = (byte)(reverse ? -1 : 1);
        if (this.parent == null) {
            AnimatorManager.startAnimation(this);
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isAnimating() {
        return this.direction != 0;
    }

    @Override
    public boolean isAnimatingReverse() {
        return this.direction < 0;
    }

    @Override
    public boolean isAnimatingForward() {
        return this.direction > 0;
    }

    public final byte getDirection() {
        return this.direction;
    }

    public A reverseOnFinish(boolean reverseOnFinish) {
        this.reverseOnFinish = reverseOnFinish;
        return this.getThis();
    }

    public A repeatsOnFinish(int repeats) {
        this.repeats = repeats;
        return this.getThis();
    }

    public SequentialAnimator followedBy(IAnimator animator) {
        return new SequentialAnimator(this, animator);
    }

    public ParallelAnimator inParallelWith(IAnimator animator) {
        return new ParallelAnimator(this, animator);
    }
}

