/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.drawable.IKey;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCHelper {
    public static boolean hasMc() {
        return MCHelper.getMc() != null;
    }

    @Nullable
    public static Minecraft getMc() {
        return Minecraft.getMinecraft();
    }

    @Nullable
    public static EntityPlayer getPlayer() {
        if (MCHelper.hasMc()) {
            return MCHelper.getMc().player;
        }
        return null;
    }

    public static boolean closeScreen() {
        if (!MCHelper.hasMc()) {
            return false;
        }
        EntityPlayer player = MCHelper.getPlayer();
        if (player != null) {
            player.closeScreen();
            return true;
        }
        Minecraft.getMinecraft().displayGuiScreen(null);
        return false;
    }

    public static boolean displayScreen(GuiScreen screen) {
        Minecraft mc = MCHelper.getMc();
        if (mc != null) {
            mc.displayGuiScreen(screen);
            return true;
        }
        return false;
    }

    public static GuiScreen getCurrentScreen() {
        Minecraft mc = MCHelper.getMc();
        return mc != null ? mc.currentScreen : null;
    }

    public static FontRenderer getFontRenderer() {
        if (MCHelper.hasMc()) {
            return MCHelper.getMc().fontRenderer;
        }
        return null;
    }

    @NotNull
    public static List<String> getItemToolTip(@NotNull ItemStack item) {
        if (!MCHelper.hasMc()) {
            return Collections.emptyList();
        }
        if (MCHelper.getMc().currentScreen != null) {
            List tooltips = MCHelper.getMc().currentScreen.getItemToolTip(item);
            if (!ModularUI.Mods.MODNAMETOOLTIP.isLoaded()) {
                tooltips.add(ModularUIConfig.modNameFormat + MCHelper.getItemModName(item) + "\u00a7r");
            }
            return tooltips;
        }
        List tooltips = item.getTooltip(MCHelper.getPlayer(), (ITooltipFlag)(MCHelper.getMc().gameSettings.advancedItemTooltips ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int i = 0; i < tooltips.size(); ++i) {
            if (i == 0) {
                tooltips.set(i, item.getItem().getForgeRarity(item).getColor() + (String)tooltips.get(i));
                continue;
            }
            tooltips.set(i, TextFormatting.GRAY + (String)tooltips.get(i));
        }
        if (!ModularUI.Mods.MODNAMETOOLTIP.isLoaded()) {
            tooltips.add(ModularUIConfig.modNameFormat + MCHelper.getItemModName(item) + "\u00a7r");
        }
        return tooltips;
    }

    @Nullable
    public static String getItemModName(@NotNull ItemStack item) {
        ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(item.getItem().getCreatorModId(item));
        return modContainer == null ? null : modContainer.getName();
    }

    @NotNull
    public static IKey getFluidModNameKey(@NotNull FluidStack fluidStack) {
        return IKey.str(MCHelper.getFluidModName(fluidStack));
    }

    @NotNull
    public static String getFluidModName(@NotNull FluidStack fluid) {
        ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(MCHelper.getFluidModID(fluid.getFluid()));
        if (modContainer == null) {
            throw new IllegalStateException("Tried to get the mod name of a fluid that isn't registered to the Forge FluidRegistry");
        }
        return "\u00a79\u00a7o" + modContainer.getName() + "\u00a7r";
    }

    @NotNull
    public static String getFluidModID(@NotNull Fluid fluid) {
        String fluidModName = FluidRegistry.getDefaultFluidName((Fluid)fluid);
        return fluidModName.substring(0, fluidModName.indexOf(":"));
    }
}

