/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.overlay;

import com.cleanroommc.modularui.overlay.OverlayHandler;
import com.cleanroommc.modularui.overlay.OverlayStack;
import com.cleanroommc.modularui.screen.ModularScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class OverlayManager {
    public static final List<OverlayHandler> overlays = new ArrayList<OverlayHandler>();

    public static void register(OverlayHandler handler) {
        if (!overlays.contains(handler)) {
            overlays.add(handler);
            overlays.sort(OverlayHandler::compareTo);
        }
    }

    public static void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() != Minecraft.getMinecraft().currentScreen) {
            OverlayStack.closeAll();
            if (event.getGui() == null) {
                return;
            }
            for (OverlayHandler handler : overlays) {
                if (!handler.isValidFor(event.getGui())) continue;
                ModularScreen overlay = Objects.requireNonNull(handler.createOverlay(event.getGui()), "Overlays must not be null!");
                overlay.constructOverlay(event.getGui());
                OverlayStack.open(overlay);
            }
        }
    }
}

