/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.drawable.IRichTextBuilder;
import com.cleanroommc.modularui.api.drawable.ITextLine;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.text.RichText;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.integration.jei.ModularUIJeiPlugin;
import com.cleanroommc.modularui.screen.RichTooltipEvent;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.widget.sizer.Area;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class RichTooltip
implements IRichTextBuilder<RichTooltip> {
    private static final Area HOLDER = new Area();
    private final RichText text = new RichText();
    private Consumer<Area> parent;
    private Pos pos = null;
    private Consumer<RichTooltip> tooltipBuilder;
    private int showUpTimer = 0;
    private boolean autoUpdate = false;
    private int titleMargin = 0;
    private boolean appliedMargin = true;
    private int x = 0;
    private int y = 0;
    private int maxWidth = Integer.MAX_VALUE;
    private boolean dirty;

    public RichTooltip() {
        this.parent(Area.ZERO);
    }

    public RichTooltip parent(Consumer<Area> parent) {
        this.parent = parent;
        return this;
    }

    public RichTooltip parent(Supplier<Area> parent) {
        return this.parent((Area area) -> area.set((Rectangle)parent.get()));
    }

    public RichTooltip parent(Area parent) {
        return this.parent((Area area) -> area.set(parent));
    }

    public RichTooltip parent(IWidget parent) {
        return this.parent((Area area) -> {
            area.setPos(0, 0);
            area.setSize(parent.getArea());
        });
    }

    public void buildTooltip() {
        this.dirty = false;
        if (this.tooltipBuilder != null) {
            this.text.clearText();
            this.tooltipBuilder.accept(this);
            this.appliedMargin = false;
        }
    }

    public void draw(GuiContext context) {
        this.draw(context, ItemStack.EMPTY);
    }

    public void draw(GuiContext context, @Nullable ItemStack stack) {
        if (this.autoUpdate) {
            this.markDirty();
        }
        if (this.isEmpty()) {
            return;
        }
        if (this.maxWidth <= 0) {
            this.maxWidth = Integer.MAX_VALUE;
        }
        if (stack == null) {
            stack = ItemStack.EMPTY;
        }
        if (!this.appliedMargin) {
            if (this.titleMargin > 0) {
                this.text.insertTitleMargin(this.titleMargin);
            }
            this.appliedMargin = true;
        }
        Area screen = context.getScreenArea();
        this.maxWidth = Math.min(this.maxWidth, screen.width);
        int mouseX = context.getAbsMouseX();
        int mouseY = context.getAbsMouseY();
        TextRenderer renderer = TextRenderer.SHARED;
        RichText copy = this.text.copy();
        RichTooltipEvent.Pre event = new RichTooltipEvent.Pre(stack, copy.getAsStrings(), mouseX, mouseY, screen.width, screen.height, this.maxWidth, TextRenderer.getFontRenderer(), copy);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        int screenWidth = event.getScreenWidth();
        int screenHeight = event.getScreenHeight();
        this.maxWidth = event.getMaxWidth();
        copy.setupRenderer(renderer, 0, 0, this.maxWidth, -1.0f, Color.WHITE.main, false);
        copy.compileAndDraw(renderer, context, true);
        Rectangle area = this.determineTooltipArea(copy, context, renderer, screenWidth, screenHeight, mouseX, mouseY);
        renderer.setPos(area.x, area.y);
        renderer.setAlignment(copy.getAlignment(), (float)Math.ceil((float)area.width + copy.getScale()), -1.0f);
        List<ITextLine> compiledLines = copy.compileAndDraw(renderer, context, true);
        area.width = (int)renderer.getLastTrimmedWidth();
        area.height = (int)renderer.getLastTrimmedHeight();
        GlStateManager.disableRescaleNormal();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        GlStateManager.disableBlend();
        GuiDraw.drawTooltipBackground(stack, copy.getAsStrings(), area.x, area.y, area.width, area.height, this);
        MinecraftForge.EVENT_BUS.post((Event)new RichTooltipEvent.PostBackground(stack, copy.getAsStrings(), area.x, area.y, TextRenderer.getFontRenderer(), area.width, area.height, copy));
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.setPos(area.x, area.y);
        renderer.setSimulate(false);
        renderer.drawCompiled(context, compiledLines);
        MinecraftForge.EVENT_BUS.post((Event)new RichTooltipEvent.PostText(stack, copy.getAsStrings(), area.x, area.y, TextRenderer.getFontRenderer(), area.width, area.height, copy));
    }

    public Rectangle determineTooltipArea(RichText text, GuiContext context, TextRenderer renderer, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        Pos pos;
        int width = (int)renderer.getLastTrimmedWidth();
        int height = (int)renderer.getLastTrimmedHeight();
        if (width > screenWidth - 14) {
            width = screenWidth - 14;
        }
        if ((pos = this.pos) == null) {
            pos = ModularUIConfig.tooltipPos;
        }
        if (pos == Pos.FIXED) {
            return new Rectangle(this.x, this.y, width, height);
        }
        Area area = HOLDER;
        this.parent.accept(area);
        if (area.x == 0 && area.y == 0 && area.width == 0 && area.height == 0) {
            pos = Pos.NEXT_TO_MOUSE;
        }
        if (pos == Pos.NEXT_TO_MOUSE) {
            int padding = 8;
            int mouseOffset = 12;
            int x = mouseX + 12;
            int y = mouseY - 12;
            if (x < 8) {
                x = 8;
            } else if (x + width + 8 > screenWidth) {
                if (screenWidth - mouseX < mouseX) {
                    if ((x -= 24 + width) < 8) {
                        x = 8;
                    }
                    width = mouseX - 12 - 8;
                } else {
                    width = screenWidth - 8 - x;
                }
                renderer.setPos(x, y);
                renderer.setAlignment(text.getAlignment(), width, -1.0f);
                text.compileAndDraw(renderer, context, true);
                width = (int)renderer.getLastTrimmedWidth();
                height = (int)renderer.getLastTrimmedHeight();
            }
            y = MathUtils.clamp(y, 8, screenHeight - 8 - height);
            return new Rectangle(x, y, width, height);
        }
        if (this.parent == null) {
            throw new IllegalStateException("Tooltip pos is " + pos.name() + ", but no widget parent is set!");
        }
        int minWidth = text.getMinWidth();
        int shiftAmount = 10;
        int padding = 7;
        area.transformAndRectanglerize(context);
        int x = 0;
        int y = 0;
        if (pos.axis.isVertical()) {
            x = area.x + (width < area.width ? shiftAmount : -shiftAmount);
            x = MathUtils.clamp(x, padding, screenWidth - padding - width);
            if (pos == Pos.VERTICAL) {
                int bottomSpace = screenHeight - area.ey();
                Pos pos2 = pos = bottomSpace < height + padding && bottomSpace < area.y ? Pos.ABOVE : Pos.BELOW;
            }
            if (pos == Pos.BELOW) {
                y = area.ey() + padding;
            } else if (pos == Pos.ABOVE) {
                y = area.y - height - padding;
            }
        } else if (pos.axis.isHorizontal()) {
            boolean usedMoreSpaceSide = false;
            Pos oPos = pos;
            if (oPos == Pos.HORIZONTAL) {
                if (area.x > screenWidth - area.ex()) {
                    pos = Pos.LEFT;
                } else {
                    pos = Pos.RIGHT;
                    x = screenWidth - area.ex() + padding;
                }
            }
            if (height < area.height) {
                y = area.y + shiftAmount;
            } else {
                y = area.y - shiftAmount;
                if (y < padding) {
                    y = padding;
                }
            }
            if (x + width > screenWidth - padding) {
                int maxWidth = pos == Pos.LEFT ? Math.max(minWidth, area.x - padding * 2) : Math.max(minWidth, screenWidth - area.ex() - padding * 2);
                usedMoreSpaceSide = true;
                renderer.setAlignment(text.getAlignment(), maxWidth);
                text.compileAndDraw(renderer, context, true);
                width = (int)renderer.getLastTrimmedWidth();
                height = (int)renderer.getLastTrimmedHeight();
            }
            if (oPos == Pos.HORIZONTAL && !usedMoreSpaceSide) {
                int rightSpace = screenWidth - area.ex();
                Pos pos3 = pos = rightSpace < width + padding && rightSpace < area.x ? Pos.LEFT : Pos.RIGHT;
            }
            if (pos == Pos.RIGHT) {
                x = area.ex() + padding;
            } else if (pos == Pos.LEFT && (x = area.x - width - padding) < padding) {
                x = padding;
                width = area.x - x - padding;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    public boolean isEmpty() {
        if (this.dirty) {
            this.buildTooltip();
        }
        return this.text.isEmpty();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public int getShowUpTimer() {
        return this.showUpTimer;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public RichTooltip pos(Pos pos) {
        this.pos = pos;
        return this;
    }

    public RichTooltip pos(int x, int y) {
        this.pos = Pos.FIXED;
        this.x = x;
        this.y = y;
        return this;
    }

    @Override
    public RichTooltip getThis() {
        return this;
    }

    @Override
    public IRichTextBuilder<?> getRichText() {
        return this.text;
    }

    public RichTooltip showUpTimer(int showUpTimer) {
        this.showUpTimer = showUpTimer;
        return this;
    }

    public RichTooltip tooltipBuilder(Consumer<RichTooltip> tooltipBuilder) {
        Consumer<RichTooltip> existingBuilder = this.tooltipBuilder;
        this.tooltipBuilder = existingBuilder != null ? tooltip -> {
            existingBuilder.accept(this);
            tooltipBuilder.accept(this);
        } : tooltipBuilder;
        this.markDirty();
        return this;
    }

    public RichTooltip setAutoUpdate(boolean update) {
        this.autoUpdate = update;
        return this;
    }

    public RichTooltip addFromItem(ItemStack item) {
        List<String> lines = MCHelper.getItemToolTip(item);
        ((RichTooltip)this.add(lines.get(0))).newLine();
        if (lines.size() > 1) {
            this.spaceLine();
            int n = lines.size();
            for (int i = 1; i < n; ++i) {
                ((RichTooltip)this.add(lines.get(i))).newLine();
            }
        }
        return this;
    }

    public RichTooltip titleMargin() {
        return this.titleMargin(0);
    }

    public RichTooltip titleMargin(int margin) {
        this.titleMargin = margin;
        this.appliedMargin = false;
        return this;
    }

    private static void findIngredientArea(Area area, int x, int y) {
        GuiContainer guiContainer;
        Slot slot;
        GuiScreen screen = MCHelper.getCurrentScreen();
        if (screen instanceof GuiContainer && (slot = (guiContainer = (GuiContainer)screen).getSlotUnderMouse()) != null) {
            int sx = slot.xPos + guiContainer.getGuiLeft();
            int sy = slot.yPos + guiContainer.getGuiTop();
            if (sx >= 0 && sy >= 0) {
                area.set(sx - 1, sy - 1, 18, 18);
                return;
            }
        }
        if (ModularUI.Mods.JEI.isLoaded()) {
            IShowsRecipeFocuses overlay = (IShowsRecipeFocuses)ModularUIJeiPlugin.getRuntime().getIngredientListOverlay();
            IClickedIngredient ingredient = overlay.getIngredientUnderMouse(x, y);
            if (ingredient == null || ingredient.getArea() == null) {
                overlay = (IShowsRecipeFocuses)ModularUIJeiPlugin.getRuntime().getBookmarkOverlay();
                ingredient = overlay.getIngredientUnderMouse(x, y);
            }
            if (ingredient != null && ingredient.getArea() != null) {
                Rectangle slot2 = ingredient.getArea();
                area.set(slot2.x - 1, slot2.y - 1, 18, 18);
                return;
            }
        }
        area.set(Area.ZERO);
    }

    @ApiStatus.Internal
    public static void injectRichTooltip(ItemStack stack, List<String> lines, int x, int y) {
        RichTooltip tooltip = new RichTooltip();
        tooltip.parent((Area area) -> RichTooltip.findIngredientArea(area, x, y));
        ((RichTooltip)tooltip.add(lines.get(0))).newLine();
        if (lines.size() > 1) {
            if (!stack.isEmpty()) {
                tooltip.spaceLine();
            }
            int n = lines.size();
            for (int i = 1; i < n; ++i) {
                ((RichTooltip)tooltip.add(lines.get(i))).newLine();
            }
        }
        tooltip.draw(GuiContext.getDefault(), stack);
    }

    public static enum Pos {
        ABOVE(GuiAxis.Y),
        BELOW(GuiAxis.Y),
        LEFT(GuiAxis.X),
        RIGHT(GuiAxis.X),
        VERTICAL(GuiAxis.Y),
        HORIZONTAL(GuiAxis.X),
        NEXT_TO_MOUSE(null),
        FIXED(null);

        public final GuiAxis axis;

        private Pos(GuiAxis axis) {
            this.axis = axis;
        }
    }
}

