/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.test;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.screen.CustomModularScreen;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.value.BoolValue;
import com.cleanroommc.modularui.value.DoubleValue;
import com.cleanroommc.modularui.value.EnumValue;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.CycleButtonWidget;
import com.cleanroommc.modularui.widgets.SliderWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GLTestGui
extends CustomModularScreen {
    private static final ItemStack ITEM = new ItemStack((Block)Blocks.CHEST);
    private static final int COLOR = Color.withAlpha(Color.RED.brighter(0), 0.75f);
    private RenderObject ro1;
    private RenderObject ro2;

    @Override
    @NotNull
    public ModularPanel buildUI(ModularGuiContext context) {
        this.ro1 = new RenderObject();
        this.ro2 = new RenderObject();
        this.ro1.type = Type.ITEM;
        this.ro1.lighting = Lighting.GUI_ITEM;
        this.ro1.texture = true;
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("gl_test").width(250)).height(200)).padding(7)).child((IWidget)((Flow)((Flow)Flow.column().debugName("main col")).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().debugName("config row")).fullWidth()).coverChildrenHeight()).child(this.buildRenderObjectConfig(this.ro1).debugName("config left col"))).child((IWidget)((Widget)((Widget)new Rectangle().setColor(-12566464).asWidget().debugName("separator").width(1)).margin(2, 0)).fullHeight())).child(this.buildRenderObjectConfig(this.ro2).debugName("config right col")))).child(((Widget)((Widget)this.createPreview().expanded()).fullWidth()).debugName("preview")));
    }

    private Flow buildRenderObjectConfig(RenderObject ro) {
        return (Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().expanded()).coverChildrenHeight()).child(((CycleButtonWidget)((CycleButtonWidget)new CycleButtonWidget().value(new EnumValue.Dynamic<Type>(Type.class, () -> ro.type, val -> ro.type = val)).widthRel(1.0f)).height(14)).overlay(IKey.dynamic(() -> "Type: " + ro.type.name().toLowerCase(Locale.ROOT))))).child(((CycleButtonWidget)((CycleButtonWidget)new CycleButtonWidget().value(new EnumValue.Dynamic<Lighting>(Lighting.class, () -> ro.lighting, val -> ro.lighting = val)).widthRel(1.0f)).height(14)).overlay(IKey.dynamic(() -> "Lighting: " + ro.lighting.name().toLowerCase(Locale.ROOT))))).child(((SliderWidget)((SliderWidget)((SliderWidget)new SliderWidget().widthRel(1.0f)).height(14)).overlay(IKey.str("Z-Layer"))).bounds(140.0, 180.0).value(new DoubleValue.Dynamic(() -> ro.zLevel, val -> ro.zLevel = (float)val)))).child((IWidget)((Flow)((Flow)((Flow)((Flow)Flow.row().widthRel(1.0f)).coverChildrenHeight()).margin(0, 1)).mainAxisAlignment(Alignment.MainAxis.SPACE_BETWEEN).child(IKey.str("enableDepth()").asWidget())).child(((ToggleButton)((ToggleButton)new ToggleButton().size(14)).stateBackground(GuiTextures.CHECK_BOX)).value(new BoolValue.Dynamic(() -> ro.depth, val -> ro.depth = val))))).child((IWidget)((Flow)((Flow)((Flow)((Flow)Flow.row().widthRel(1.0f)).coverChildrenHeight()).margin(0, 1)).mainAxisAlignment(Alignment.MainAxis.SPACE_BETWEEN).child(IKey.str("enableBlend()").asWidget())).child(((ToggleButton)((ToggleButton)new ToggleButton().size(14)).stateBackground(GuiTextures.CHECK_BOX)).value(new BoolValue.Dynamic(() -> ro.blend, val -> ro.blend = val))))).child((IWidget)((Flow)((Flow)((Flow)((Flow)Flow.row().widthRel(1.0f)).coverChildrenHeight()).margin(0, 1)).mainAxisAlignment(Alignment.MainAxis.SPACE_BETWEEN).child(IKey.str("enableTexture2D()").asWidget())).child(((ToggleButton)((ToggleButton)new ToggleButton().size(14)).stateBackground(GuiTextures.CHECK_BOX)).value(new BoolValue.Dynamic(() -> ro.texture, val -> ro.texture = val))));
    }

    private Widget<?> createPreview() {
        return ((IDrawable)(context, x, y, width, height, widgetTheme) -> {
            this.ro1.draw(context, x, y, width, height, widgetTheme);
            this.ro2.draw(context, x, y, width, height, widgetTheme);
        }).asIcon().size(100).asWidget();
    }

    private static void drawItem(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        GlStateManager.translate((float)x, (float)y, (float)0.0f);
        GlStateManager.scale((float)((float)width / 16.0f), (float)((float)height / 16.0f), (float)1.0f);
        RenderItem renderItem = Minecraft.getMinecraft().getRenderItem();
        renderItem.zLevel = 0.0f;
        renderItem.renderItemAndEffectIntoGUI((EntityLivingBase)Platform.getClientPlayer(), ITEM, 0, 0);
        renderItem.zLevel = 0.0f;
    }

    private static void drawColor(GuiContext context, int x0, int y0, int w, int h, WidgetTheme widgetTheme) {
        float x1 = x0 + w;
        float y1 = y0 + h;
        float r = Color.getRedF(COLOR);
        float g = Color.getGreenF(COLOR);
        float b = Color.getBlueF(COLOR);
        float a = Color.getAlphaF(COLOR);
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_COLOR, bufferBuilder -> {
            bufferBuilder.pos((double)x0, (double)y0, 0.0).color(r, g, b, a).endVertex();
            bufferBuilder.pos((double)x0, (double)y1, 0.0).color(r, g, b, a).endVertex();
            bufferBuilder.pos((double)x1, (double)y1, 0.0).color(r, g, b, a).endVertex();
            bufferBuilder.pos((double)x1, (double)y0, 0.0).color(r, g, b, a).endVertex();
        });
    }

    private static class RenderObject
    implements IDrawable {
        private Type type = Type.NONE;
        private Lighting lighting = Lighting.NONE;
        private float zLevel = 0.0f;
        private boolean depth = false;
        private boolean blend = false;
        private boolean texture = false;

        private RenderObject() {
        }

        @Override
        public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)this.zLevel);
            if (this.depth) {
                GlStateManager.enableDepth();
            } else {
                GlStateManager.disableDepth();
            }
            if (this.blend) {
                GlStateManager.enableBlend();
            } else {
                GlStateManager.disableBlend();
            }
            if (this.texture) {
                GlStateManager.enableTexture2D();
            } else {
                GlStateManager.disableTexture2D();
            }
            this.lighting.enable.run();
            this.type.render.draw(context, x, y, width, height, widgetTheme);
            this.lighting.disable.run();
            GlStateManager.disableTexture2D();
            GlStateManager.disableBlend();
            GlStateManager.disableDepth();
            GlStateManager.popMatrix();
        }
    }

    private static enum Type {
        NONE(IDrawable.EMPTY),
        TEXTURE(GuiTextures.MUI_LOGO),
        ITEM((x$0, x$1, x$2, x$3, x$4, x$5) -> GLTestGui.access$800(x$0, x$1, x$2, x$3, x$4, x$5)),
        COLOR((x$0, x$1, x$2, x$3, x$4, x$5) -> GLTestGui.access$700(x$0, x$1, x$2, x$3, x$4, x$5));

        private final IDrawable render;

        private Type(IDrawable render) {
            this.render = render;
        }
    }

    private static enum Lighting {
        NONE(GlStateManager::disableLighting, GlStateManager::disableLighting),
        NORMAL(GlStateManager::enableLighting, GlStateManager::disableLighting),
        STANDARD(RenderHelper::enableStandardItemLighting, RenderHelper::disableStandardItemLighting),
        GUI_ITEM(RenderHelper::enableGUIStandardItemLighting, RenderHelper::disableStandardItemLighting);

        private final Runnable enable;
        private final Runnable disable;

        private Lighting(Runnable enable, Runnable disable) {
            this.enable = enable;
            this.disable = disable;
        }
    }
}

