/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class BlockPosUtil {
    public static final BlockPos MAX = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final BlockPos MIN = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);

    public static int getManhattanDistance(BlockPos p1, BlockPos p2) {
        return BlockPosUtil.getXDist(p1, p2) + BlockPosUtil.getYDist(p1, p2) + BlockPosUtil.getZDist(p1, p2);
    }

    public static int getBlockCountInside(BlockPos p1, BlockPos p2) {
        return BlockPosUtil.getXDist(p1, p2) * BlockPosUtil.getYDist(p1, p2) * BlockPosUtil.getZDist(p1, p2);
    }

    public static int getXDist(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.getX() - p2.getX());
    }

    public static int getYDist(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.getY() - p2.getY());
    }

    public static int getZDist(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.getZ() - p2.getZ());
    }

    public static BlockPos getMin(BlockPos p1, BlockPos p2) {
        return new BlockPos(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
    }

    public static BlockPos getMax(BlockPos p1, BlockPos p2) {
        return new BlockPos(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ()));
    }

    public static void setMin(BlockPos.MutableBlockPos p1, BlockPos p2) {
        p1.setPos(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
    }

    public static void setMax(BlockPos.MutableBlockPos p1, BlockPos p2) {
        p1.setPos(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ()));
    }

    public static BlockPos getCenter(BlockPos p1, BlockPos p2) {
        BlockPos min = BlockPosUtil.getMin(p1, p2);
        return new BlockPos(BlockPosUtil.getXDist(p1, p2) / 2 + min.getX(), BlockPosUtil.getYDist(p1, p2) / 2 + min.getY(), BlockPosUtil.getYDist(p1, p2) / 2 + min.getY());
    }

    public static Vec3d getCenterD(BlockPos p1, BlockPos p2) {
        return BlockPosUtil.getCenterD(BlockPosUtil.getMin(p1, p2), BlockPosUtil.getXDist(p1, p2), BlockPosUtil.getYDist(p1, p2), BlockPosUtil.getZDist(p1, p2));
    }

    public static Vec3d getCenterD(BlockPos origin, int xs, int ys, int zs) {
        return new Vec3d((double)xs / 2.0 + (double)origin.getX(), (double)ys / 2.0 + (double)origin.getY(), (double)zs / 2.0 + (double)origin.getZ());
    }

    public static Iterable<BlockPos.MutableBlockPos> getAllInside(BlockPos p1, BlockPos p2, boolean includeBorder) {
        int x0 = Math.min(p1.getX(), p2.getX());
        int y0 = Math.min(p1.getY(), p2.getY());
        int z0 = Math.min(p1.getZ(), p2.getZ());
        int x1 = Math.max(p1.getX(), p2.getX());
        int y1 = Math.max(p1.getY(), p2.getY());
        int z1 = Math.max(p1.getZ(), p2.getZ());
        if (includeBorder) {
            --x0;
            --y0;
            --z0;
        } else {
            --x1;
            --y1;
            --z1;
        }
        return BlockPos.getAllInBoxMutable((int)x0, (int)y0, (int)z0, (int)x1, (int)y1, (int)z1);
    }

    public static boolean isOnBorder(BlockPos boxMin, BlockPos boxMax, BlockPos p) {
        return p.getX() == boxMin.getX() || p.getX() == boxMax.getX() || p.getY() == boxMin.getY() || p.getY() == boxMax.getY() || p.getZ() == boxMin.getZ() || p.getZ() == boxMax.getZ();
    }

    public static BlockPos.MutableBlockPos add(BlockPos.MutableBlockPos pos, int x, int y, int z) {
        return pos.setPos(pos.getX() + x, pos.getY() + y, pos.getZ() + z);
    }
}

