/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.slot;

import com.cleanroommc.modularui.widgets.slot.InventoryCraftingWrapper;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ModularCraftingSlot
extends ModularSlot {
    private InventoryCraftingWrapper craftMatrix;
    private IRecipe recipeUsed;
    private int amountCrafted;

    public ModularCraftingSlot(IItemHandler itemHandler, int index) {
        super(itemHandler, index);
    }

    @Override
    public boolean isItemValid(@NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack decrStackSize(int amount) {
        if (this.getHasStack()) {
            this.amountCrafted += Math.min(amount, this.getStack().getCount());
        }
        return super.decrStackSize(amount);
    }

    protected void onCrafting(@NotNull ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.onCrafting(stack);
    }

    protected void onSwapCraft(int p_190900_1_) {
        this.amountCrafted += p_190900_1_;
    }

    protected void onCrafting(@NotNull ItemStack stack) {
        if (this.amountCrafted > 0) {
            stack.onCrafting(this.getPlayer().world, this.getPlayer(), this.amountCrafted);
            FMLCommonHandler.instance().firePlayerCraftingEvent(this.getPlayer(), stack, (IInventory)this.craftMatrix);
        }
        this.amountCrafted = 0;
        if (this.recipeUsed != null && !this.recipeUsed.isDynamic()) {
            this.getPlayer().unlockRecipes(Collections.singletonList(this.recipeUsed));
            this.recipeUsed = null;
        }
    }

    @Override
    public void onCraftShiftClick(EntityPlayer player, ItemStack stack) {
        if (!stack.isEmpty()) {
            player.dropItem(stack, false);
        }
    }

    @NotNull
    public ItemStack onTake(@NotNull EntityPlayer thePlayer, @NotNull ItemStack stack) {
        ForgeHooks.setCraftingPlayer((EntityPlayer)thePlayer);
        NonNullList nonnulllist = CraftingManager.getRemainingItems((InventoryCrafting)this.craftMatrix, (World)thePlayer.world);
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = this.craftMatrix.getStackInSlot(i);
            ItemStack itemstack1 = (ItemStack)nonnulllist.get(i);
            if (!itemstack.isEmpty()) {
                this.craftMatrix.decrStackSize(i, 1, false);
                itemstack = this.craftMatrix.getStackInSlot(i);
            }
            if (itemstack1.isEmpty()) continue;
            if (itemstack.isEmpty()) {
                this.craftMatrix.setSlot(i, itemstack1, false);
                continue;
            }
            if (ItemStack.areItemsEqual((ItemStack)itemstack, (ItemStack)itemstack1) && ItemStack.areItemStackTagsEqual((ItemStack)itemstack, (ItemStack)itemstack1)) {
                itemstack1.grow(itemstack.getCount());
                this.craftMatrix.setSlot(i, itemstack1, false);
                continue;
            }
            if (thePlayer.inventory.addItemStackToInventory(itemstack1)) continue;
            thePlayer.dropItem(itemstack1, false);
        }
        this.craftMatrix.notifyContainer();
        return stack;
    }

    public void updateResult(ItemStack stack) {
        this.putStack(stack);
        this.getSyncHandler().forceSyncItem();
    }

    public void setRecipeUsed(IRecipe recipeUsed) {
        this.recipeUsed = recipeUsed;
    }

    public void setCraftMatrix(InventoryCraftingWrapper craftMatrix) {
        this.craftMatrix = craftMatrix;
    }
}

