/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui;

import com.cleanroommc.modularui.CommonProxy;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.animation.AnimatorManager;
import com.cleanroommc.modularui.api.widget.ResizeDragArea;
import com.cleanroommc.modularui.drawable.DrawableSerialization;
import com.cleanroommc.modularui.factory.GuiFactories;
import com.cleanroommc.modularui.factory.inventory.InventoryTypes;
import com.cleanroommc.modularui.holoui.HoloScreenEntity;
import com.cleanroommc.modularui.holoui.ScreenEntityRender;
import com.cleanroommc.modularui.keybind.KeyBindHandler;
import com.cleanroommc.modularui.screen.ClientScreenHandler;
import com.cleanroommc.modularui.test.EventHandler;
import com.cleanroommc.modularui.test.OverlayTest;
import com.cleanroommc.modularui.test.TestItem;
import com.cleanroommc.modularui.theme.ThemeManager;
import com.cleanroommc.modularui.theme.ThemeReloadCommand;
import com.cleanroommc.modularui.utils.Platform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Timer;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private final Timer timer60Fps = new Timer(60.0f);
    public static KeyBinding testKey;
    public static Cursor resizeCursorDiag;
    public static Cursor resizeCursorDiagInverse;
    public static Cursor resizeCursorH;
    public static Cursor resizeCursorV;
    private static Cursor currentCursor;

    @Override
    void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new ClientScreenHandler());
        MinecraftForge.EVENT_BUS.register(KeyBindHandler.class);
        AnimatorManager.init();
        if (ModularUIConfig.enableTestGuis) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
            testKey = new KeyBinding("key.test", (IKeyConflictContext)KeyConflictContext.IN_GAME, 75, "key.categories.modularui");
            ClientRegistry.registerKeyBinding((KeyBinding)testKey);
        }
        if (ModularUIConfig.enableTestOverlays) {
            OverlayTest.init();
        }
        DrawableSerialization.init();
        RenderingRegistry.registerEntityRenderingHandler(HoloScreenEntity.class, ScreenEntityRender::new);
        if (!Minecraft.func_71410_x().func_147110_a().isStencilEnabled()) {
            Minecraft.func_71410_x().func_147110_a().enableStencil();
        }
        try {
            BufferedImage img = ImageIO.read(this.getClass().getClassLoader().getResourceAsStream("assets/modularui/textures/gui/icons/cursor_resize_diag.png"));
            int size = img.getHeight();
            resizeCursorDiagInverse = new Cursor(size, size, size / 2, size / 2, 1, ClientProxy.readPixel(img, true, false), null);
            resizeCursorDiag = new Cursor(size, size, size / 2, size / 2, 1, ClientProxy.readPixel(img, false, false), null);
            img = ImageIO.read(this.getClass().getClassLoader().getResourceAsStream("assets/modularui/textures/gui/icons/cursor_resize.png"));
            size = img.getHeight();
            resizeCursorH = new Cursor(size, size, size / 2, size / 2, 1, ClientProxy.readPixel(img, false, false), null);
            resizeCursorV = new Cursor(size, size, size / 2, size / 2, 1, ClientProxy.readPixel(img, false, true), null);
        }
        catch (IOException | LWJGLException e) {
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            ModularUI.LOGGER.info("Custom Cursors failed to load. This is likely because an incompatible LWJGL version was used like with CleanroomLoader.");
        }
    }

    public static IntBuffer readPixel(BufferedImage img, boolean inverse, boolean transpose) {
        int y;
        int size = img.getHeight();
        IntBuffer buffer = IntBuffer.allocate(size * size);
        int n = y = inverse ? 0 : size - 1;
        while (inverse ? y < size : y >= 0) {
            for (int x = 0; x < size; ++x) {
                int b;
                int a;
                if (transpose) {
                    a = y;
                    b = x;
                } else {
                    a = x;
                    b = y;
                }
                buffer.put(img.getRGB(a, b));
            }
            if (inverse) {
                ++y;
                continue;
            }
            --y;
        }
        buffer.flip();
        return buffer;
    }

    public static void setCursorResizeIcon(ResizeDragArea dragArea) {
        if (resizeCursorV == null) {
            return;
        }
        try {
            Cursor cursor;
            if (dragArea == null) {
                ClientProxy.resetCursorIcon();
                return;
            }
            switch (dragArea) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case TOP_LEFT: 
                case BOTTOM_RIGHT: {
                    cursor = resizeCursorDiagInverse;
                    break;
                }
                case TOP_RIGHT: 
                case BOTTOM_LEFT: {
                    cursor = resizeCursorDiag;
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    cursor = resizeCursorV;
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    cursor = resizeCursorH;
                }
            }
            Cursor cursor2 = cursor;
            currentCursor = Mouse.setNativeCursor((Cursor)cursor2);
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetCursorIcon() {
        if (resizeCursorV == null) {
            return;
        }
        try {
            if (currentCursor == resizeCursorDiag || currentCursor == resizeCursorDiagInverse || currentCursor == resizeCursorH || currentCursor == resizeCursorV) {
                currentCursor = null;
            }
            Mouse.setNativeCursor((Cursor)currentCursor);
            currentCursor = null;
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        ClientCommandHandler.instance.func_71560_a((ICommand)new ThemeReloadCommand());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new ThemeManager());
    }

    @SubscribeEvent
    public void onKeyboard(InputEvent.KeyInputEvent event) {
        if (ModularUIConfig.enableTestGuis && testKey != null && testKey.func_151468_f() && ModularUI.Mods.BAUBLES.isLoaded()) {
            InventoryTypes.BAUBLES.visitAll((EntityPlayer)Platform.getClientPlayer(), (type, index, stack) -> {
                if (stack.func_77973_b() instanceof TestItem) {
                    GuiFactories.playerInventory().openFromBaublesClient(index);
                    return true;
                }
                return false;
            });
        }
    }

    @Override
    public Timer getTimer60Fps() {
        return this.timer60Fps;
    }
}

